/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler;

import gololang.ir.Member;
import gololang.ir.Struct;
import org.eclipse.golo.compiler.CodeGenerationResult;
import org.eclipse.golo.compiler.JavaBytecodeUtils;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class JavaBytecodeStructGenerator {
    private static final String $_frozen = "$_frozen";

    JavaBytecodeStructGenerator() {
    }

    public CodeGenerationResult compile(Struct struct, String sourceFilename) {
        ClassWriter classWriter = new ClassWriter(3);
        classWriter.visitSource(sourceFilename, null);
        classWriter.visit(52, 49, struct.getPackageAndClass().toJVMType(), null, "gololang/GoloStruct", null);
        this.makeFields(classWriter, struct);
        this.makeAccessors(classWriter, struct);
        this.makeConstructors(classWriter, struct);
        this.makeImmutableFactory(classWriter, struct);
        this.makeToString(classWriter, struct);
        this.makeCopy(classWriter, struct, false);
        this.makeCopy(classWriter, struct, true);
        this.makeHashCode(classWriter, struct);
        this.makeEquals(classWriter, struct);
        this.makeToArrayMethod(classWriter, struct);
        this.makeGetMethod(classWriter, struct);
        this.makeSetMethod(classWriter, struct);
        classWriter.visitEnd();
        return new CodeGenerationResult(classWriter.toByteArray(), struct.getPackageAndClass());
    }

    private void makeSetMethod(ClassWriter classWriter, Struct struct) {
        String owner = struct.getPackageAndClass().toJVMType();
        MethodVisitor visitor = classWriter.visitMethod(1, "set", "(Ljava/lang/String;Ljava/lang/Object;)L" + owner + ";", null, null);
        visitor.visitCode();
        this.insertPrivateElementCheck(struct, visitor);
        Label nextCase = new Label();
        for (Member member : struct.getMembers()) {
            visitor.visitLdcInsn((Object)member.getName());
            visitor.visitVarInsn(25, 1);
            visitor.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z", false);
            visitor.visitJumpInsn(153, nextCase);
            visitor.visitVarInsn(25, 0);
            visitor.visitVarInsn(25, 2);
            visitor.visitMethodInsn(182, owner, member.getName(), "(Ljava/lang/Object;)L" + owner + ";", false);
            visitor.visitInsn(176);
            visitor.visitLabel(nextCase);
            nextCase = new Label();
        }
        this.insertUnknowElementCode(struct, visitor);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeGetMethod(ClassWriter classWriter, Struct struct) {
        String owner = struct.getPackageAndClass().toJVMType();
        MethodVisitor visitor = classWriter.visitMethod(1, "get", "(Ljava/lang/String;)Ljava/lang/Object;", null, null);
        visitor.visitCode();
        this.insertPrivateElementCheck(struct, visitor);
        Label nextCase = new Label();
        for (Member member : struct.getMembers()) {
            visitor.visitLdcInsn((Object)member.getName());
            visitor.visitVarInsn(25, 1);
            visitor.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z", false);
            visitor.visitJumpInsn(153, nextCase);
            visitor.visitVarInsn(25, 0);
            visitor.visitMethodInsn(182, owner, member.getName(), "()Ljava/lang/Object;", false);
            visitor.visitInsn(176);
            visitor.visitLabel(nextCase);
            nextCase = new Label();
        }
        this.insertUnknowElementCode(struct, visitor);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void throwLocalized(MethodVisitor visitor, String exceptionType, String message, String structName) {
        visitor.visitTypeInsn(187, exceptionType);
        visitor.visitInsn(89);
        visitor.visitLdcInsn((Object)message);
        visitor.visitInsn(4);
        visitor.visitTypeInsn(189, "java/lang/Object");
        visitor.visitInsn(89);
        visitor.visitInsn(3);
        visitor.visitLdcInsn((Object)structName);
        visitor.visitInsn(83);
        visitor.visitMethodInsn(184, "gololang/Messages", "message", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", false);
        visitor.visitMethodInsn(183, exceptionType, "<init>", "(Ljava/lang/String;)V", false);
        visitor.visitInsn(191);
    }

    private void insertPrivateElementCheck(Struct struct, MethodVisitor visitor) {
        Label afterPrivateCheck = new Label();
        visitor.visitVarInsn(25, 1);
        visitor.visitLdcInsn((Object)"_");
        visitor.visitMethodInsn(182, "java/lang/String", "startsWith", "(Ljava/lang/String;)Z", false);
        visitor.visitJumpInsn(153, afterPrivateCheck);
        this.throwLocalized(visitor, "java/lang/IllegalArgumentException", "struct_private_member", struct.getPackageAndClass().toString());
        visitor.visitLabel(afterPrivateCheck);
    }

    private void insertUnknowElementCode(Struct struct, MethodVisitor visitor) {
        this.throwLocalized(visitor, "java/lang/IllegalArgumentException", "unknown_struct_member", struct.getPackageAndClass().toString());
    }

    private void makeToArrayMethod(ClassWriter classWriter, Struct struct) {
        String owner = struct.getPackageAndClass().toJVMType();
        MethodVisitor visitor = classWriter.visitMethod(1, "toArray", "()[Ljava/lang/Object;", null, null);
        visitor.visitCode();
        JavaBytecodeUtils.loadInteger(visitor, struct.getPublicMembers().size());
        visitor.visitTypeInsn(189, "java/lang/Object");
        int index = 0;
        for (Member member : struct.getPublicMembers()) {
            visitor.visitInsn(89);
            JavaBytecodeUtils.loadInteger(visitor, index);
            visitor.visitVarInsn(25, 0);
            visitor.visitFieldInsn(180, owner, member.getName(), "Ljava/lang/Object;");
            visitor.visitInsn(83);
            ++index;
        }
        visitor.visitInsn(176);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeEquals(ClassWriter classWriter, Struct struct) {
        String owner = struct.getPackageAndClass().toJVMType();
        MethodVisitor visitor = classWriter.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        Label notFrozenLabel = new Label();
        Label falseLabel = new Label();
        Label sameTypeLabel = new Label();
        visitor.visitCode();
        visitor.visitVarInsn(25, 0);
        visitor.visitFieldInsn(180, owner, $_frozen, "Z");
        visitor.visitJumpInsn(154, notFrozenLabel);
        visitor.visitVarInsn(25, 0);
        visitor.visitVarInsn(25, 1);
        visitor.visitMethodInsn(183, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z", false);
        visitor.visitInsn(172);
        visitor.visitLabel(notFrozenLabel);
        visitor.visitVarInsn(25, 1);
        visitor.visitTypeInsn(193, owner);
        visitor.visitJumpInsn(154, sameTypeLabel);
        visitor.visitJumpInsn(167, falseLabel);
        visitor.visitLabel(sameTypeLabel);
        visitor.visitVarInsn(25, 1);
        visitor.visitTypeInsn(192, owner);
        visitor.visitFieldInsn(180, owner, $_frozen, "Z");
        visitor.visitJumpInsn(153, falseLabel);
        for (Member member : struct.getMembers()) {
            visitor.visitVarInsn(25, 0);
            visitor.visitFieldInsn(180, owner, member.getName(), "Ljava/lang/Object;");
            visitor.visitVarInsn(25, 1);
            visitor.visitTypeInsn(192, owner);
            visitor.visitFieldInsn(180, owner, member.getName(), "Ljava/lang/Object;");
            visitor.visitMethodInsn(184, "java/util/Objects", "equals", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
            visitor.visitJumpInsn(153, falseLabel);
        }
        visitor.visitInsn(4);
        visitor.visitInsn(172);
        visitor.visitLabel(falseLabel);
        visitor.visitInsn(3);
        visitor.visitInsn(172);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeHashCode(ClassWriter classWriter, Struct struct) {
        String owner = struct.getPackageAndClass().toJVMType();
        MethodVisitor visitor = classWriter.visitMethod(1, "hashCode", "()I", null, null);
        Label notFrozenLabel = new Label();
        visitor.visitCode();
        visitor.visitVarInsn(25, 0);
        visitor.visitFieldInsn(180, owner, $_frozen, "Z");
        visitor.visitJumpInsn(154, notFrozenLabel);
        visitor.visitVarInsn(25, 0);
        visitor.visitMethodInsn(183, "java/lang/Object", "hashCode", "()I", false);
        visitor.visitInsn(172);
        visitor.visitLabel(notFrozenLabel);
        JavaBytecodeUtils.loadInteger(visitor, struct.getMembers().size());
        visitor.visitTypeInsn(189, "java/lang/Object");
        int i = 0;
        for (Member member : struct.getMembers()) {
            visitor.visitInsn(89);
            JavaBytecodeUtils.loadInteger(visitor, i);
            visitor.visitVarInsn(25, 0);
            visitor.visitFieldInsn(180, owner, member.getName(), "Ljava/lang/Object;");
            visitor.visitInsn(83);
            ++i;
        }
        visitor.visitMethodInsn(184, "java/util/Objects", "hash", "([Ljava/lang/Object;)I", false);
        visitor.visitInsn(172);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeCopy(ClassWriter classWriter, Struct struct, boolean frozen) {
        String owner = struct.getPackageAndClass().toJVMType();
        String methodName = frozen ? "frozenCopy" : "copy";
        MethodVisitor visitor = classWriter.visitMethod(1, methodName, "()L" + owner + ";", null, null);
        visitor.visitCode();
        visitor.visitTypeInsn(187, owner);
        visitor.visitInsn(89);
        for (Member member : struct.getMembers()) {
            visitor.visitVarInsn(25, 0);
            visitor.visitFieldInsn(180, owner, member.getName(), "Ljava/lang/Object;");
        }
        visitor.visitMethodInsn(183, owner, "<init>", this.allArgsConstructorSignature(struct), false);
        visitor.visitInsn(89);
        visitor.visitInsn(frozen ? 4 : 3);
        visitor.visitFieldInsn(181, owner, $_frozen, "Z");
        visitor.visitInsn(176);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeToString(ClassWriter classWriter, Struct struct) {
        String owner = struct.getPackageAndClass().toJVMType();
        MethodVisitor visitor = classWriter.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        visitor.visitCode();
        visitor.visitTypeInsn(187, "java/lang/StringBuilder");
        visitor.visitInsn(89);
        visitor.visitLdcInsn((Object)("struct " + struct.getPackageAndClass().className() + "{"));
        visitor.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V", false);
        boolean first = true;
        for (Member member : struct.getPublicMembers()) {
            visitor.visitInsn(89);
            visitor.visitLdcInsn((Object)((!first ? ", " : "") + member.getName() + "="));
            first = false;
            visitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            visitor.visitInsn(89);
            visitor.visitVarInsn(25, 0);
            visitor.visitFieldInsn(180, owner, member.getName(), "Ljava/lang/Object;");
            visitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;", false);
        }
        visitor.visitLdcInsn((Object)"}");
        visitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        visitor.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        visitor.visitInsn(176);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeConstructors(ClassWriter classWriter, Struct struct) {
        String owner = struct.getPackageAndClass().toJVMType();
        this.makeNoArgsConstructor(classWriter, struct);
        this.makeAllArgsConstructor(classWriter, struct, owner);
    }

    private void makeAllArgsConstructor(ClassWriter classWriter, Struct struct, String owner) {
        MethodVisitor visitor = classWriter.visitMethod(1, "<init>", this.allArgsConstructorSignature(struct), null, null);
        for (Member member : struct.getMembers()) {
            visitor.visitParameter(member.getName(), 16);
        }
        visitor.visitCode();
        visitor.visitVarInsn(25, 0);
        visitor.visitMethodInsn(183, "gololang/GoloStruct", "<init>", "()V", false);
        int arg = 1;
        for (Member member : struct.getMembers()) {
            visitor.visitVarInsn(25, 0);
            visitor.visitVarInsn(25, arg);
            visitor.visitFieldInsn(181, owner, member.getName(), "Ljava/lang/Object;");
            ++arg;
        }
        this.initMembersField(struct, owner, visitor);
        visitor.visitVarInsn(25, 0);
        visitor.visitInsn(3);
        visitor.visitFieldInsn(181, owner, $_frozen, "Z");
        visitor.visitInsn(177);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeImmutableFactory(ClassWriter classWriter, Struct struct) {
        String constructorDesc = this.allArgsConstructorSignature(struct);
        String desc = constructorDesc.substring(0, constructorDesc.length() - 1);
        String classType = struct.getPackageAndClass().toJVMType();
        desc = desc + "L" + classType + ";";
        MethodVisitor visitor = classWriter.visitMethod(9, "$_immutable", desc, null, null);
        for (Member member : struct.getMembers()) {
            visitor.visitParameter(member.getName(), 16);
        }
        visitor.visitCode();
        visitor.visitTypeInsn(187, classType);
        visitor.visitInsn(89);
        for (int i = 0; i < struct.getMembers().size(); ++i) {
            visitor.visitVarInsn(25, i);
        }
        visitor.visitMethodInsn(183, classType, "<init>", constructorDesc, false);
        visitor.visitInsn(89);
        visitor.visitInsn(4);
        visitor.visitFieldInsn(181, classType, $_frozen, "Z");
        visitor.visitInsn(176);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void initMembersField(Struct struct, String owner, MethodVisitor visitor) {
        visitor.visitVarInsn(25, 0);
        JavaBytecodeUtils.loadInteger(visitor, struct.getPublicMembers().size());
        visitor.visitTypeInsn(189, "java/lang/String");
        int arg = 0;
        for (Member member : struct.getPublicMembers()) {
            visitor.visitInsn(89);
            JavaBytecodeUtils.loadInteger(visitor, arg);
            visitor.visitLdcInsn((Object)member.getName());
            visitor.visitInsn(83);
            ++arg;
        }
        visitor.visitFieldInsn(181, owner, "members", "[Ljava/lang/String;");
    }

    private String allArgsConstructorSignature(Struct struct) {
        StringBuilder signatureBuilder = new StringBuilder("(");
        for (int i = 0; i < struct.getMembers().size(); ++i) {
            signatureBuilder.append("Ljava/lang/Object;");
        }
        signatureBuilder.append(")V");
        return signatureBuilder.toString();
    }

    private void makeNoArgsConstructor(ClassWriter classWriter, Struct struct) {
        String owner = struct.getPackageAndClass().toJVMType();
        MethodVisitor visitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        for (Member member : struct.getMembers()) {
            visitor.visitParameter(member.getName(), 16);
        }
        visitor.visitCode();
        visitor.visitVarInsn(25, 0);
        visitor.visitMethodInsn(183, "gololang/GoloStruct", "<init>", "()V", false);
        visitor.visitVarInsn(25, 0);
        visitor.visitInsn(3);
        visitor.visitFieldInsn(181, struct.getPackageAndClass().toJVMType(), $_frozen, "Z");
        this.initMembersField(struct, owner, visitor);
        visitor.visitInsn(177);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeFields(ClassWriter classWriter, Struct struct) {
        classWriter.visitField(18, $_frozen, "Z", null, null).visitEnd();
        for (Member member : struct.getMembers()) {
            FieldVisitor fieldVisitor = classWriter.visitField(2, member.getName(), "Ljava/lang/Object;", null, null);
            fieldVisitor.visitEnd();
        }
    }

    private void makeAccessors(ClassWriter classWriter, Struct struct) {
        String owner = struct.getPackageAndClass().toJVMType();
        for (Member member : struct.getMembers()) {
            this.makeGetter(classWriter, owner, member.getName());
            this.makeSetter(classWriter, owner, member.getName(), struct);
        }
        this.makeFrozenGetter(classWriter, owner);
    }

    private void makeFrozenGetter(ClassWriter classWriter, String owner) {
        MethodVisitor visitor = classWriter.visitMethod(1, "isFrozen", "()Z", null, null);
        visitor.visitCode();
        visitor.visitVarInsn(25, 0);
        visitor.visitFieldInsn(180, owner, $_frozen, "Z");
        visitor.visitInsn(172);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeSetter(ClassWriter classWriter, String owner, String name, Struct struct) {
        int accessFlag = name.startsWith("_") ? 2 : 1;
        MethodVisitor visitor = classWriter.visitMethod(accessFlag, name, "(Ljava/lang/Object;)L" + struct.getPackageAndClass().toJVMType() + ";", null, null);
        visitor.visitCode();
        visitor.visitVarInsn(25, 0);
        visitor.visitFieldInsn(180, owner, $_frozen, "Z");
        Label setLabel = new Label();
        visitor.visitJumpInsn(153, setLabel);
        this.throwLocalized(visitor, "java/lang/IllegalStateException", "frozen_struct", struct.getPackageAndClass().toString());
        visitor.visitLabel(setLabel);
        visitor.visitVarInsn(25, 0);
        visitor.visitVarInsn(25, 1);
        visitor.visitFieldInsn(181, owner, name, "Ljava/lang/Object;");
        visitor.visitVarInsn(25, 0);
        visitor.visitInsn(176);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeGetter(ClassWriter classWriter, String owner, String name) {
        int accessFlag = name.startsWith("_") ? 2 : 1;
        MethodVisitor visitor = classWriter.visitMethod(accessFlag, name, "()Ljava/lang/Object;", null, null);
        visitor.visitCode();
        visitor.visitVarInsn(25, 0);
        visitor.visitFieldInsn(180, owner, name, "Ljava/lang/Object;");
        visitor.visitInsn(176);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }
}

