/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler;

import gololang.Messages;
import gololang.ir.AbstractInvocation;
import gololang.ir.Alternatives;
import gololang.ir.AssignmentStatement;
import gololang.ir.Augmentation;
import gololang.ir.BinaryOperation;
import gololang.ir.Block;
import gololang.ir.CaseStatement;
import gololang.ir.CollectionComprehension;
import gololang.ir.CollectionLiteral;
import gololang.ir.ConditionalBranching;
import gololang.ir.ConstantStatement;
import gololang.ir.Decorator;
import gololang.ir.DestructuringAssignment;
import gololang.ir.ExpressionStatement;
import gololang.ir.ForEachLoopStatement;
import gololang.ir.FunctionContainer;
import gololang.ir.FunctionInvocation;
import gololang.ir.GoloElement;
import gololang.ir.GoloFunction;
import gololang.ir.GoloModule;
import gololang.ir.GoloStatement;
import gololang.ir.LocalReference;
import gololang.ir.LoopBreakFlowStatement;
import gololang.ir.LoopStatement;
import gololang.ir.MatchExpression;
import gololang.ir.Member;
import gololang.ir.MethodInvocation;
import gololang.ir.ModuleImport;
import gololang.ir.NamedArgument;
import gololang.ir.NamedAugmentation;
import gololang.ir.OperatorType;
import gololang.ir.ReferenceLookup;
import gololang.ir.ReferenceTable;
import gololang.ir.ReturnStatement;
import gololang.ir.Struct;
import gololang.ir.ThrowStatement;
import gololang.ir.TryCatchFinally;
import gololang.ir.UnaryOperation;
import gololang.ir.Union;
import gololang.ir.UnionValue;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.golo.compiler.GoloCompilationException;
import org.eclipse.golo.compiler.PackageAndClass;
import org.eclipse.golo.compiler.PositionInSourceCode;
import org.eclipse.golo.compiler.parser.ASTAdditiveExpression;
import org.eclipse.golo.compiler.parser.ASTAndExpression;
import org.eclipse.golo.compiler.parser.ASTAnonymousFunctionInvocation;
import org.eclipse.golo.compiler.parser.ASTArgument;
import org.eclipse.golo.compiler.parser.ASTAssignment;
import org.eclipse.golo.compiler.parser.ASTAugmentDeclaration;
import org.eclipse.golo.compiler.parser.ASTBlock;
import org.eclipse.golo.compiler.parser.ASTBreak;
import org.eclipse.golo.compiler.parser.ASTCase;
import org.eclipse.golo.compiler.parser.ASTCollectionLiteral;
import org.eclipse.golo.compiler.parser.ASTCompilationUnit;
import org.eclipse.golo.compiler.parser.ASTConditionalBranching;
import org.eclipse.golo.compiler.parser.ASTContinue;
import org.eclipse.golo.compiler.parser.ASTDecoratorDeclaration;
import org.eclipse.golo.compiler.parser.ASTDestructuringAssignment;
import org.eclipse.golo.compiler.parser.ASTEqualityExpression;
import org.eclipse.golo.compiler.parser.ASTExpressionStatement;
import org.eclipse.golo.compiler.parser.ASTForEachLoop;
import org.eclipse.golo.compiler.parser.ASTForLoop;
import org.eclipse.golo.compiler.parser.ASTFunction;
import org.eclipse.golo.compiler.parser.ASTFunctionDeclaration;
import org.eclipse.golo.compiler.parser.ASTFunctionInvocation;
import org.eclipse.golo.compiler.parser.ASTImportDeclaration;
import org.eclipse.golo.compiler.parser.ASTInvocationExpression;
import org.eclipse.golo.compiler.parser.ASTLetOrVar;
import org.eclipse.golo.compiler.parser.ASTLiteral;
import org.eclipse.golo.compiler.parser.ASTLocalDeclaration;
import org.eclipse.golo.compiler.parser.ASTMatch;
import org.eclipse.golo.compiler.parser.ASTMemberDeclaration;
import org.eclipse.golo.compiler.parser.ASTMethodInvocation;
import org.eclipse.golo.compiler.parser.ASTModuleDeclaration;
import org.eclipse.golo.compiler.parser.ASTMultiplicativeExpression;
import org.eclipse.golo.compiler.parser.ASTNamedAugmentationDeclaration;
import org.eclipse.golo.compiler.parser.ASTOrExpression;
import org.eclipse.golo.compiler.parser.ASTOrIfNullExpression;
import org.eclipse.golo.compiler.parser.ASTReference;
import org.eclipse.golo.compiler.parser.ASTRelationalExpression;
import org.eclipse.golo.compiler.parser.ASTReturn;
import org.eclipse.golo.compiler.parser.ASTStructDeclaration;
import org.eclipse.golo.compiler.parser.ASTThrow;
import org.eclipse.golo.compiler.parser.ASTToplevelDeclaration;
import org.eclipse.golo.compiler.parser.ASTTryCatchFinally;
import org.eclipse.golo.compiler.parser.ASTUnaryExpression;
import org.eclipse.golo.compiler.parser.ASTUnionDeclaration;
import org.eclipse.golo.compiler.parser.ASTUnionValue;
import org.eclipse.golo.compiler.parser.ASTWhileLoop;
import org.eclipse.golo.compiler.parser.ASTerror;
import org.eclipse.golo.compiler.parser.GoloASTNode;
import org.eclipse.golo.compiler.parser.GoloParserVisitor;
import org.eclipse.golo.compiler.parser.NamedNode;
import org.eclipse.golo.compiler.parser.Node;
import org.eclipse.golo.compiler.parser.SimpleNode;

public class ParseTreeToGoloIrVisitor
implements GoloParserVisitor {
    @Override
    public Object visit(ASTerror node, Object data) {
        return null;
    }

    public GoloModule transform(ASTCompilationUnit compilationUnit, GoloCompilationException.Builder builder) {
        Context context = new Context();
        context.newObjectStack();
        context.setExceptionBuilder(builder);
        this.visit(compilationUnit, (Object)context);
        return context.module.sourceFile(compilationUnit.getFilename());
    }

    @Override
    public Object visit(SimpleNode node, Object data) {
        throw new IllegalStateException("visit(SimpleNode) shall never be invoked: " + node.getClass());
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        return node.childrenAccept(this, data);
    }

    @Override
    public Object visit(ASTModuleDeclaration node, Object data) {
        Context context = (Context)data;
        context.createModule(node.getName()).ofAST(node);
        return node.childrenAccept(this, data);
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        Context context = (Context)data;
        PackageAndClass name = node.isRelative() ? context.module.getPackageAndClass().createSiblingClass(node.getName()) : PackageAndClass.of(node.getName());
        if (node.getMultiple().isEmpty()) {
            context.addImport((ModuleImport)ModuleImport.of(name).ofAST(node));
        } else {
            for (String sub : node.getMultiple()) {
                context.addImport((ModuleImport)ModuleImport.of(name.createSubPackage(sub)).ofAST(node));
            }
        }
        return node.childrenAccept(this, data);
    }

    @Override
    public Object visit(ASTToplevelDeclaration node, Object data) {
        return node.childrenAccept(this, data);
    }

    @Override
    public Object visit(ASTMemberDeclaration node, Object data) {
        Context context = (Context)data;
        context.push(Member.of(node.getName()).ofAST(node));
        return context;
    }

    @Override
    public Object visit(ASTStructDeclaration node, Object data) {
        Context context = (Context)data;
        Struct theStruct = (Struct)Struct.struct(node.getName()).ofAST(node);
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, context);
            theStruct.withMember(context.pop());
        }
        context.addType(node, theStruct);
        return data;
    }

    @Override
    public Object visit(ASTUnionDeclaration node, Object data) {
        Context context = (Context)data;
        context.push(Union.union(node.getName()).ofAST(node));
        node.childrenAccept(this, data);
        context.addType(node, (Union)context.pop());
        return data;
    }

    @Override
    public Object visit(ASTUnionValue node, Object data) {
        Context context = (Context)data;
        UnionValue value = (UnionValue)new UnionValue(node.getName()).ofAST(node);
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, context);
            if (!(context.peek() instanceof Member)) continue;
            value.withMember(context.pop());
        }
        Union currentUnion = (Union)context.peek();
        if (!currentUnion.addValue(value)) {
            context.errorMessage(GoloCompilationException.Problem.Type.AMBIGUOUS_DECLARATION, node, Messages.message("ambiguous_unionvalue_declaration", node.getName()));
        }
        return data;
    }

    @Override
    public Object visit(ASTAugmentDeclaration node, Object data) {
        Context context = (Context)data;
        context.enterAugmentation(node);
        node.childrenAccept(this, data);
        context.leaveAugmentation();
        return data;
    }

    @Override
    public Object visit(ASTDecoratorDeclaration node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, data);
        context.push(Decorator.of(context.pop()).constant(node.isConstant()).ofAST(node));
        return data;
    }

    @Override
    public Object visit(ASTNamedAugmentationDeclaration node, Object data) {
        Context context = (Context)data;
        context.enterNamedAugmentation(node);
        node.childrenAccept(this, data);
        context.leaveNamedAugmentation();
        return data;
    }

    @Override
    public Object visit(ASTFunctionDeclaration node, Object data) {
        Context context = (Context)data;
        GoloFunction function = ((GoloFunction)GoloFunction.function(node.getName()).ofAST(node)).local(node.isLocal()).inAugment(node.isAugmentation()).decorator(node.isDecorator());
        while (context.peek() instanceof Decorator) {
            function.decoratedWith(context.pop());
        }
        context.push(function);
        node.childrenAccept(this, data);
        context.pop();
        return data;
    }

    @Override
    public Object visit(ASTContinue node, Object data) {
        Context context = (Context)data;
        LoopBreakFlowStatement statement = (LoopBreakFlowStatement)LoopBreakFlowStatement.newContinue().ofAST(node);
        context.push(statement);
        return data;
    }

    @Override
    public Object visit(ASTBreak node, Object data) {
        Context context = (Context)data;
        LoopBreakFlowStatement statement = (LoopBreakFlowStatement)LoopBreakFlowStatement.newBreak().ofAST(node);
        context.push(statement);
        return data;
    }

    @Override
    public Object visit(ASTFunction node, Object data) {
        Context context = (Context)data;
        GoloFunction function = ((GoloFunction)context.getOrCreateFunction().ofAST(node)).varargs(node.isVarargs()).withParameters(node.getParameters());
        if (node.isCompactForm()) {
            Node astChild = node.jjtGetChild(0);
            ASTReturn astReturn = new ASTReturn(0);
            astReturn.jjtAddChild(astChild, 0);
            ASTBlock astBlock = new ASTBlock(0);
            astBlock.jjtAddChild(astReturn, 0);
            astBlock.jjtAccept(this, data);
        } else {
            node.childrenAccept(this, data);
        }
        if (function.isSynthetic()) {
            context.pop();
            context.push(function.asClosureReference());
        } else {
            context.addFunction(function);
            context.pop();
        }
        return data;
    }

    @Override
    public Object visit(ASTUnaryExpression node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, data);
        context.push(UnaryOperation.create(node.getOperator(), context.pop()).ofAST(node));
        return data;
    }

    @Override
    public Object visit(ASTLiteral node, Object data) {
        Context context = (Context)data;
        ConstantStatement constantStatement = (ConstantStatement)ConstantStatement.of(node.getLiteralValue()).ofAST(node);
        context.push(constantStatement);
        return data;
    }

    @Override
    public Object visit(ASTCollectionLiteral node, Object data) {
        if (node.isComprehension()) {
            return this.createCollectionComprehension(node, (Context)data);
        }
        return this.createCollectionLiteral(node, (Context)data);
    }

    private Object createCollectionLiteral(ASTCollectionLiteral node, Context context) {
        CollectionLiteral collection = (CollectionLiteral)CollectionLiteral.create(node.getType(), new Object[0]).ofAST(node);
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, context);
            collection.add(context.pop());
        }
        context.push(collection);
        return context;
    }

    private Object createCollectionComprehension(ASTCollectionLiteral node, Context context) {
        CollectionComprehension col = (CollectionComprehension)CollectionComprehension.of(node.getType()).ofAST(node);
        node.jjtGetChild(0).jjtAccept(this, context);
        col.expression(context.pop());
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, context);
            col.loop(((Block)context.pop()).getStatements().get(0));
        }
        context.push(col);
        return context;
    }

    @Override
    public Object visit(ASTReference node, Object data) {
        ((Context)data).push(ReferenceLookup.of(node.getName()).ofAST(node));
        return data;
    }

    @Override
    public Object visit(ASTLetOrVar node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, data);
        AssignmentStatement assignmentStatement = (AssignmentStatement)AssignmentStatement.create(context.getOrCreateReference(node), context.pop(), true).ofAST(node);
        if (node.isModuleState()) {
            context.module.add(assignmentStatement);
        } else {
            context.push(assignmentStatement);
        }
        return data;
    }

    @Override
    public Object visit(ASTAssignment node, Object data) {
        Context context = (Context)data;
        LocalReference reference = context.getReference(node.getName(), node);
        node.childrenAccept(this, data);
        if (reference == null) {
            context.errorMessage(GoloCompilationException.Problem.Type.UNDECLARED_REFERENCE, node, Messages.message("undeclared_reference_assignment", node.getName()));
        } else {
            context.push(AssignmentStatement.create(reference, context.pop(), false).ofAST(node));
        }
        return data;
    }

    @Override
    public Object visit(ASTDestructuringAssignment node, Object data) {
        Context context = (Context)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        DestructuringAssignment builder = ((DestructuringAssignment)((DestructuringAssignment)DestructuringAssignment.destruct(context.pop()).ofAST(node)).declaring(node.getType() != null)).varargs(node.isVarargs());
        for (String name : node.getNames()) {
            LocalReference val = context.getOrCreateReference(node, name);
            if (val == null) continue;
            builder.to(val);
        }
        context.push(builder);
        return data;
    }

    @Override
    public Object visit(ASTReturn node, Object data) {
        Context context = (Context)data;
        if (node.jjtGetNumChildren() > 0) {
            node.childrenAccept(this, data);
        } else {
            context.push(ConstantStatement.of(null));
        }
        context.push(ReturnStatement.of(context.pop()).ofAST(node));
        return data;
    }

    @Override
    public Object visit(ASTArgument node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, data);
        context.push(node.isNamed() ? NamedArgument.of(node.getName(), context.pop()) : context.pop());
        return data;
    }

    @Override
    public Object visit(ASTThrow node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, data);
        context.push(ThrowStatement.of(context.pop()).ofAST(node));
        return data;
    }

    @Override
    public Object visit(ASTBlock node, Object data) {
        Context context = (Context)data;
        Block block = (Block)context.enterScope().ofAST(node);
        if (context.peek() instanceof GoloFunction) {
            GoloFunction function = (GoloFunction)context.peek();
            function.block(block);
            if (function.isSynthetic()) {
                context.pop();
            }
        }
        context.push(block);
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            GoloASTNode child = (GoloASTNode)node.jjtGetChild(i);
            child.jjtAccept(this, data);
            GoloStatement statement = (GoloStatement)context.pop();
            block.add(statement);
        }
        context.leaveScope();
        return data;
    }

    @Override
    public Object visit(ASTFunctionInvocation node, Object data) {
        Context context = (Context)data;
        context.push(this.visitAbstractInvocation(data, node, FunctionInvocation.of(node.getName()).constant(node.isConstant())));
        return data;
    }

    @Override
    public Object visit(ASTMethodInvocation node, Object data) {
        Context context = (Context)data;
        context.push(this.visitAbstractInvocation(data, node, MethodInvocation.invoke(node.getName())));
        return data;
    }

    @Override
    public Object visit(ASTAnonymousFunctionInvocation node, Object data) {
        Context context = (Context)data;
        ExpressionStatement<?> result = this.visitAbstractInvocation(data, node, FunctionInvocation.of(null).constant(node.isConstant()));
        if (node.isOnExpression()) {
            context.push(ExpressionStatement.of(context.pop()).call(result));
        } else {
            context.push(result);
        }
        return data;
    }

    private void checkNamedArgument(Context context, GoloASTNode node, AbstractInvocation<?> invocation, ExpressionStatement<?> statement) {
        if (statement instanceof NamedArgument) {
            if (!invocation.namedArgumentsComplete()) {
                context.errorMessage(GoloCompilationException.Problem.Type.INCOMPLETE_NAMED_ARGUMENTS_USAGE, node, Messages.message("incomplete_named_arguments_usage", invocation.getClass().getName(), invocation.getName()));
            }
            invocation.withNamedArguments();
        }
    }

    private ExpressionStatement<?> visitAbstractInvocation(Object data, GoloASTNode node, AbstractInvocation<?> invocation) {
        GoloASTNode argumentNode;
        Context context = (Context)data;
        invocation.ofAST(node);
        int i = 0;
        int numChildren = node.jjtGetNumChildren();
        for (i = 0; i < numChildren && !((argumentNode = (GoloASTNode)node.jjtGetChild(i)) instanceof ASTAnonymousFunctionInvocation); ++i) {
            argumentNode.jjtAccept(this, context);
            ExpressionStatement<?> statement = ExpressionStatement.of(context.pop());
            this.checkNamedArgument(context, node, invocation, statement);
            invocation.withArgs(statement);
        }
        ExpressionStatement result = invocation;
        if (i < numChildren) {
            while (i < numChildren) {
                node.jjtGetChild(i).jjtAccept(this, context);
                result = result.call(context.pop());
                ++i;
            }
        }
        return result;
    }

    @Override
    public Object visit(ASTConditionalBranching node, Object data) {
        Context context = (Context)data;
        node.jjtGetChild(1).jjtAccept(this, data);
        node.jjtGetChild(0).jjtAccept(this, data);
        ConditionalBranching conditionalBranching = ((ConditionalBranching)ConditionalBranching.branch().ofAST(node)).condition(context.pop()).whenTrue(context.pop());
        if (node.jjtGetNumChildren() > 2) {
            node.jjtGetChild(2).jjtAccept(this, data);
            conditionalBranching.otherwise(context.pop());
        }
        context.push(conditionalBranching);
        return data;
    }

    private Object visitAlternatives(Object data, GoloASTNode node, Alternatives<?> alternatives) {
        Context context = (Context)data;
        int lastWhen = node.jjtGetNumChildren() - 1;
        for (int i = 0; i < lastWhen; i += 2) {
            node.jjtGetChild(i).jjtAccept(this, data);
            alternatives.when(context.pop());
            node.jjtGetChild(i + 1).jjtAccept(this, data);
            alternatives.then(context.pop());
        }
        node.jjtGetChild(lastWhen).jjtAccept(this, data);
        alternatives.otherwise(context.pop());
        context.push(alternatives);
        return data;
    }

    @Override
    public Object visit(ASTCase node, Object data) {
        return this.visitAlternatives(data, node, (Alternatives)CaseStatement.cases().ofAST(node));
    }

    @Override
    public Object visit(ASTMatch node, Object data) {
        return this.visitAlternatives(data, node, (Alternatives)MatchExpression.match().ofAST(node));
    }

    @Override
    public Object visit(ASTWhileLoop node, Object data) {
        Context context = (Context)data;
        node.jjtGetChild(1).jjtAccept(this, data);
        node.jjtGetChild(0).jjtAccept(this, data);
        context.push(((LoopStatement)LoopStatement.loop().condition(context.pop()).ofAST(node)).block(Block.of(context.pop())));
        return data;
    }

    @Override
    public Object visit(ASTForLoop node, Object data) {
        Context context = (Context)data;
        Block containingBlock = context.enterScope();
        node.jjtGetChild(0).jjtAccept(this, data);
        node.jjtGetChild(1).jjtAccept(this, data);
        node.jjtGetChild(2).jjtAccept(this, data);
        LoopStatement loopStatement = ((LoopStatement)LoopStatement.loop().ofAST(node)).post(context.pop()).condition(context.pop()).init(context.pop());
        if (node.jjtGetNumChildren() == 4) {
            node.jjtGetChild(3).jjtAccept(this, data);
            loopStatement.block(Block.of(context.pop()));
        }
        context.push(containingBlock.add(loopStatement));
        context.leaveScope();
        return data;
    }

    @Override
    public Object visit(ASTForEachLoop node, Object data) {
        Context context = (Context)data;
        Block containingBlock = context.enterScope();
        node.jjtGetChild(0).jjtAccept(this, data);
        ForEachLoopStatement foreach = ((ForEachLoopStatement)ForEachLoopStatement.create().ofAST(node)).varargs(node.isVarargs()).in(context.pop());
        if (node.getElementIdentifier() != null) {
            foreach.var(node.getElementIdentifier());
        } else {
            for (String name : node.getNames()) {
                foreach.var(name);
            }
        }
        int numChildren = node.jjtGetNumChildren();
        if (numChildren > 2) {
            node.jjtGetChild(2).jjtAccept(this, data);
            node.jjtGetChild(1).jjtAccept(this, data);
            foreach.when(context.pop()).block(context.pop());
        } else if (numChildren == 2) {
            node.jjtGetChild(1).jjtAccept(this, data);
            Object child = context.pop();
            if (child instanceof Block) {
                foreach.block(child);
            } else if (child instanceof ExpressionStatement) {
                foreach.when(child);
            } else {
                context.errorMessage(GoloCompilationException.Problem.Type.PARSING, node, Messages.message("syntax_foreach"));
            }
        }
        context.push(containingBlock.add(foreach));
        context.leaveScope();
        return data;
    }

    @Override
    public Object visit(ASTTryCatchFinally node, Object data) {
        Context context = (Context)data;
        boolean hasCatchBlock = node.getExceptionId() != null;
        TryCatchFinally tryCatchFinally = (TryCatchFinally)TryCatchFinally.tryCatch().ofAST(node);
        context.enterScope();
        node.jjtGetChild(0).jjtAccept(this, data);
        tryCatchFinally.trying(context.pop());
        context.leaveScope();
        context.enterScope();
        node.jjtGetChild(1).jjtAccept(this, data);
        if (hasCatchBlock) {
            tryCatchFinally.catching(node.getExceptionId(), context.pop());
        } else {
            tryCatchFinally.finalizing(context.pop());
        }
        context.leaveScope();
        if (hasCatchBlock && node.jjtGetNumChildren() > 2) {
            context.enterScope();
            node.jjtGetChild(2).jjtAccept(this, data);
            tryCatchFinally.finalizing(context.pop());
            context.leaveScope();
        }
        context.push(tryCatchFinally);
        return data;
    }

    @Override
    public Object visit(ASTExpressionStatement node, Object data) {
        node.childrenAccept(this, data);
        return data;
    }

    private void createOperatorChain(List<String> opSymbols, GoloASTNode node, Context context) {
        List<OperatorType> operators = opSymbols.stream().map(OperatorType::of).collect(Collectors.toList());
        List<ExpressionStatement<?>> statements = this.operatorStatements(context, operators.size());
        ExpressionStatement operation = (ExpressionStatement)this.assembleBinaryOperation(statements, operators).ofAST(node);
        context.push(operation);
    }

    @Override
    public Object visit(ASTInvocationExpression node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, context);
        this.createOperatorChain(node.getOperators(), node, context);
        return data;
    }

    private BinaryOperation assembleBinaryOperation(List<ExpressionStatement<?>> statements, List<OperatorType> operators) {
        BinaryOperation current = null;
        int i = 2;
        for (OperatorType operator : operators) {
            if (current == null) {
                current = BinaryOperation.create((Object)operator, statements.get(0), statements.get(1));
                continue;
            }
            current = BinaryOperation.create((Object)operator, current, statements.get(i));
            ++i;
        }
        return current;
    }

    private List<ExpressionStatement<?>> operatorStatements(Context context, int operatorsCount) {
        LinkedList statements = new LinkedList();
        for (int i = 0; i < operatorsCount + 1; ++i) {
            statements.addFirst(ExpressionStatement.of(context.pop()));
        }
        return statements;
    }

    @Override
    public Object visit(ASTMultiplicativeExpression node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, context);
        this.createOperatorChain(node.getOperators(), node, context);
        return data;
    }

    @Override
    public Object visit(ASTAdditiveExpression node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, context);
        this.createOperatorChain(node.getOperators(), node, context);
        return data;
    }

    @Override
    public Object visit(ASTRelationalExpression node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, data);
        BinaryOperation operation = (BinaryOperation)BinaryOperation.of(node.getOperator()).right(context.pop()).left(context.pop()).ofAST(node);
        context.push(operation);
        return data;
    }

    @Override
    public Object visit(ASTEqualityExpression node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, data);
        BinaryOperation operation = (BinaryOperation)BinaryOperation.of(node.getOperator()).right(context.pop()).left(context.pop()).ofAST(node);
        context.push(operation);
        return data;
    }

    @Override
    public Object visit(ASTAndExpression node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, context);
        List<ExpressionStatement<?>> statements = this.operatorStatements(context, node.count());
        BinaryOperation operation = (BinaryOperation)this.assembleBinaryOperation(statements, Collections.nCopies(node.count(), OperatorType.AND)).ofAST(node);
        context.push(operation);
        return data;
    }

    @Override
    public Object visit(ASTOrExpression node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, context);
        List<ExpressionStatement<?>> statements = this.operatorStatements(context, node.count());
        BinaryOperation operation = (BinaryOperation)this.assembleBinaryOperation(statements, Collections.nCopies(node.count(), OperatorType.OR)).ofAST(node);
        context.push(operation);
        return data;
    }

    @Override
    public Object visit(ASTOrIfNullExpression node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, context);
        List<ExpressionStatement<?>> statements = this.operatorStatements(context, node.count());
        BinaryOperation operation = (BinaryOperation)this.assembleBinaryOperation(statements, Collections.nCopies(node.count(), OperatorType.ORIFNULL)).ofAST(node);
        context.push(operation);
        return data;
    }

    @Override
    public Object visit(ASTLocalDeclaration node, Object data) {
        Context context = (Context)data;
        ExpressionStatement expr = (ExpressionStatement)context.peek();
        boolean oldState = context.inLocalDeclaration;
        context.inLocalDeclaration = true;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, data);
            try {
                expr.with(context.pop());
                continue;
            }
            catch (UnsupportedOperationException ex) {
                context.errorMessage(GoloCompilationException.Problem.Type.PARSING, node, ex.getMessage());
            }
        }
        context.inLocalDeclaration = oldState;
        return data;
    }

    private static final class Context {
        public GoloModule module;
        private final Deque<FunctionContainer> functionContainersStack = new LinkedList<FunctionContainer>();
        private final Deque<Deque<Object>> objectStack = new LinkedList<Deque<Object>>();
        private final Deque<ReferenceTable> referenceTableStack = new LinkedList<ReferenceTable>();
        public boolean inLocalDeclaration = false;
        private GoloCompilationException.Builder exceptionBuilder;

        private Context() {
        }

        public void newObjectStack() {
            this.objectStack.push(new LinkedList());
        }

        public void popObjectStack() {
            this.objectStack.pop();
        }

        public void push(Object object) {
            if (this.objectStack.isEmpty()) {
                this.newObjectStack();
            }
            this.objectStack.peek().push(object);
        }

        public Object peek() {
            return this.objectStack.peek().peek();
        }

        public Object pop() {
            return this.objectStack.peek().pop();
        }

        public Block enterScope() {
            ReferenceTable blockReferenceTable = this.referenceTableStack.peek().fork();
            this.referenceTableStack.push(blockReferenceTable);
            return Block.empty().ref(blockReferenceTable);
        }

        public void leaveScope() {
            this.referenceTableStack.pop();
        }

        public GoloModule createModule(String name) {
            ReferenceTable global = new ReferenceTable();
            this.referenceTableStack.push(global);
            this.module = GoloModule.create(PackageAndClass.of(name), global);
            this.functionContainersStack.push(this.module);
            return this.module;
        }

        public void enterAugmentation(ASTAugmentDeclaration node) {
            this.functionContainersStack.push((FunctionContainer)Augmentation.of(node.getTarget()).with(node.getAugmentationNames()).ofAST(node));
            this.newObjectStack();
        }

        public void leaveAugmentation() {
            this.popObjectStack();
            this.module.add((Augmentation)this.functionContainersStack.pop());
        }

        public void enterNamedAugmentation(ASTNamedAugmentationDeclaration node) {
            NamedAugmentation namedAugmentation = (NamedAugmentation)NamedAugmentation.of(node.getName()).ofAST(node);
            this.functionContainersStack.push(namedAugmentation);
            this.newObjectStack();
        }

        public void leaveNamedAugmentation() {
            this.popObjectStack();
            this.module.add((NamedAugmentation)this.functionContainersStack.pop());
        }

        public <N extends GoloASTNode, T extends GoloElement<T>> void addType(N node, T type) {
            if (!this.checkExistingSubtype(node, ((NamedNode)((Object)node)).getName())) {
                this.module.add(type);
            }
        }

        public void addImport(ModuleImport i) {
            this.module.add(i);
        }

        public void addFunction(GoloFunction function) {
            FunctionContainer container = this.functionContainersStack.peek();
            GoloFunction firstDeclaration = container.getFunction(function);
            if (firstDeclaration != null) {
                this.errorMessage(GoloCompilationException.Problem.Type.AMBIGUOUS_DECLARATION, function, Messages.message("ambiguous_function_declaration", function.getName(), firstDeclaration == null ? "unknown" : firstDeclaration.positionInSourceCode()));
            } else if (function.isInAugment() && function.getArity() == 0) {
                this.errorMessage(GoloCompilationException.Problem.Type.AUGMENT_FUNCTION_NO_ARGS, function, Messages.message("augment_function_no_args", function.getName(), container.getPackageAndClass()));
            } else {
                container.addFunction(function);
            }
        }

        public boolean checkExistingSubtype(GoloASTNode node, String name) {
            GoloElement<?> existing = this.module.getSubtypeByName(name);
            if (existing != null) {
                this.errorMessage(GoloCompilationException.Problem.Type.AMBIGUOUS_DECLARATION, node, Messages.message("ambiguous_type_declaration", name, existing.positionInSourceCode()));
                return true;
            }
            return false;
        }

        public GoloFunction getOrCreateFunction() {
            if (!(this.peek() instanceof GoloFunction)) {
                this.push(GoloFunction.function(null).synthetic().local().asClosure());
            }
            return (GoloFunction)this.peek();
        }

        private LocalReference.Kind referenceKindOf(ASTLetOrVar.Type type, boolean moduleState) {
            if (moduleState) {
                return type == ASTLetOrVar.Type.LET ? LocalReference.Kind.MODULE_CONSTANT : LocalReference.Kind.MODULE_VARIABLE;
            }
            return type == ASTLetOrVar.Type.LET ? LocalReference.Kind.CONSTANT : LocalReference.Kind.VARIABLE;
        }

        public LocalReference getOrCreateReference(ASTLetOrVar node) {
            return this.getOrCreateReference(node.getType(), node.getName(), node.isModuleState(), node);
        }

        public LocalReference getOrCreateReference(ASTDestructuringAssignment node, String name) {
            return this.getOrCreateReference(node.getType(), name, false, node);
        }

        public LocalReference getReference(String name, GoloASTNode node) {
            if (this.inLocalDeclaration) {
                return this.getOrCreateReference(ASTLetOrVar.Type.LET, name, false, node);
            }
            return this.referenceTableStack.peek().get(name);
        }

        private LocalReference getOrCreateReference(ASTLetOrVar.Type type, String name, boolean module, GoloASTNode node) {
            if (type != null) {
                LocalReference val = (LocalReference)LocalReference.of(name).kind(this.referenceKindOf(type, module)).ofAST(node);
                if (!this.inLocalDeclaration) {
                    this.referenceTableStack.peek().add(val);
                }
                return val;
            }
            return this.getReference(name, node);
        }

        public void setExceptionBuilder(GoloCompilationException.Builder builder) {
            this.exceptionBuilder = builder;
        }

        private GoloCompilationException.Builder getOrCreateExceptionBuilder() {
            if (this.exceptionBuilder == null) {
                this.exceptionBuilder = new GoloCompilationException.Builder(this.module.getPackageAndClass().toString());
            }
            return this.exceptionBuilder;
        }

        private String errorDescription(PositionInSourceCode position, String message) {
            return message + ' ' + Messages.message("source_position", position.getStartLine(), position.getStartColumn());
        }

        public void errorMessage(GoloCompilationException.Problem.Type type, GoloASTNode node, String message) {
            this.getOrCreateExceptionBuilder().report(type, node, this.errorDescription(node.getPositionInSourceCode(), message));
        }

        public void errorMessage(GoloCompilationException.Problem.Type type, GoloElement<?> node, String message) {
            this.getOrCreateExceptionBuilder().report(type, node, this.errorDescription(node.positionInSourceCode(), message));
        }
    }
}

