/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import gololang.FunctionReference;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.util.Arrays;
import org.eclipse.golo.runtime.NamedArgumentsHelper;
import org.eclipse.golo.runtime.TypeMatching;

public final class ClosureCallSupport {
    private static final MethodHandle GUARD;
    private static final MethodHandle FALLBACK;

    private ClosureCallSupport() {
        throw new UnsupportedOperationException("Don't instantiate invokedynamic bootstrap class");
    }

    public static CallSite bootstrap(MethodHandles.Lookup caller, String name, MethodType type, Object ... bsmArgs) {
        MethodHandle fallbackHandle;
        boolean constant = (Integer)bsmArgs[0] == 1;
        String[] argumentNames = new String[bsmArgs.length - 1];
        for (int i = 0; i < bsmArgs.length - 1; ++i) {
            argumentNames[i] = (String)bsmArgs[i + 1];
        }
        InlineCache callSite = new InlineCache(type, constant, argumentNames);
        callSite.fallback = fallbackHandle = FALLBACK.bindTo(callSite).asCollector(Object[].class, type.parameterCount()).asType(type);
        callSite.setTarget(fallbackHandle);
        return callSite;
    }

    public static boolean guard(FunctionReference expected, FunctionReference actual) {
        return expected == actual;
    }

    public static Object fallback(InlineCache callSite, Object[] args) throws Throwable {
        FunctionReference targetFunctionReference = (FunctionReference)args[0];
        MethodHandle target = targetFunctionReference.handle();
        MethodHandle invoker = MethodHandles.dropArguments(target, 0, new Class[]{FunctionReference.class});
        MethodType type = invoker.type();
        if (callSite.argumentNames.length > 0) {
            invoker = ClosureCallSupport.reorderArguments(targetFunctionReference.parameterNames(), invoker, callSite.argumentNames);
        }
        invoker = target.isVarargsCollector() ? (TypeMatching.isLastArgumentAnArray(type.parameterCount(), args) ? invoker.asFixedArity().asType(callSite.type()) : invoker.asCollector(Object[].class, callSite.type().parameterCount() - target.type().parameterCount()).asType(callSite.type())) : invoker.asType(callSite.type());
        if (callSite.constant) {
            Object constantValue = invoker.invokeWithArguments(args);
            MethodHandle constant = constantValue == null ? MethodHandles.constant(Object.class, null) : MethodHandles.constant(constantValue.getClass(), constantValue);
            constant = MethodHandles.dropArguments(constant, 0, type.parameterArray());
            callSite.setTarget(constant.asType(type));
            return constantValue;
        }
        MethodHandle guard = GUARD.bindTo(targetFunctionReference);
        MethodHandle root = MethodHandles.guardWithTest(guard, invoker, callSite.fallback);
        callSite.setTarget(root);
        return invoker.invokeWithArguments(args);
    }

    private static MethodHandle reorderArguments(String[] parameterNames, MethodHandle handle, String[] argumentNames) {
        return NamedArgumentsHelper.reorderArguments("closure " + Arrays.toString(parameterNames), Arrays.asList(parameterNames), handle, argumentNames, 1, 1);
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            GUARD = lookup.findStatic(ClosureCallSupport.class, "guard", MethodType.methodType(Boolean.TYPE, FunctionReference.class, FunctionReference.class));
            FALLBACK = lookup.findStatic(ClosureCallSupport.class, "fallback", MethodType.methodType(Object.class, InlineCache.class, Object[].class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error("Could not bootstrap the required method handles", e);
        }
    }

    static class InlineCache
    extends MutableCallSite {
        MethodHandle fallback;
        final boolean constant;
        final String[] argumentNames;

        InlineCache(MethodType type, boolean constant, String[] argumentNames) {
            super(type);
            this.constant = constant;
            this.argumentNames = argumentNames;
        }
    }
}

