/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import gololang.Messages;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.golo.runtime.Warnings;

public final class NamedArgumentsHelper {
    private NamedArgumentsHelper() {
    }

    public static Boolean hasNamedParameters(Method method) {
        return Arrays.stream(method.getParameters()).allMatch(Parameter::isNamePresent);
    }

    public static List<String> getParameterNames(Method method) {
        if (NamedArgumentsHelper.hasNamedParameters(method).booleanValue()) {
            return Arrays.stream(method.getParameters()).map(Parameter::getName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static void checkArgumentPosition(int position, String argument, String declaration) {
        if (position == -1) {
            throw new IllegalArgumentException(Messages.message("invalid_argument_name", argument, declaration));
        }
    }

    public static int[] getArgumentsOrder(String methodName, List<String> parameterNames, String[] argumentNames, int nameOffset, int orderOffset) {
        int i;
        int[] argumentsOrder = new int[parameterNames.size() + orderOffset];
        for (i = 0; i <= orderOffset; ++i) {
            argumentsOrder[i] = i;
        }
        for (i = 0; i < argumentNames.length; ++i) {
            int actualPosition = parameterNames.indexOf(argumentNames[i]);
            NamedArgumentsHelper.checkArgumentPosition(actualPosition, argumentNames[i], methodName + parameterNames);
            argumentsOrder[actualPosition + orderOffset] = i + nameOffset;
        }
        return argumentsOrder;
    }

    public static MethodHandle reorderArguments(String methodName, List<String> parameterNames, MethodHandle handle, String[] argumentNames, int nameOffset, int orderOffset) {
        if (argumentNames.length == 0) {
            return handle;
        }
        if (parameterNames.isEmpty()) {
            Warnings.noParameterNames(methodName, argumentNames);
            return handle;
        }
        return MethodHandles.permuteArguments(handle, handle.type(), NamedArgumentsHelper.getArgumentsOrder(methodName, parameterNames, argumentNames, nameOffset, orderOffset));
    }
}

