/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli.command;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import gololang.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.golo.cli.command.spi.CliCommand;
import org.eclipse.golo.compiler.parser.ASTCompilationUnit;
import org.eclipse.golo.compiler.parser.GoloOffsetParser;
import org.eclipse.golo.compiler.parser.ParseException;
import org.eclipse.golo.doc.AbstractProcessor;
import org.eclipse.golo.doc.CtagsProcessor;
import org.eclipse.golo.doc.HtmlProcessor;
import org.eclipse.golo.doc.MarkdownProcessor;

@Parameters(commandNames={"doc"}, commandDescriptionKey="doc", resourceBundle="commands")
public class DocCommand
implements CliCommand {
    @Parameter(names={"--format"}, descriptionKey="doc.format", validateWith=DocFormatValidator.class)
    String format = "html";
    @Parameter(names={"--output"}, descriptionKey="doc.output")
    String output = ".";
    @Parameter(descriptionKey="source_files")
    List<String> sources = new LinkedList<String>();
    private static final Map<String, AbstractProcessor> FORMATS = new HashMap<String, AbstractProcessor>();

    @Override
    public void execute() throws Throwable {
        AbstractProcessor processor = FORMATS.get(this.format);
        HashMap<String, ASTCompilationUnit> units = new HashMap<String, ASTCompilationUnit>();
        for (String source : this.sources) {
            this.loadGoloFileCompilationUnit(source, units);
        }
        try {
            processor.process(units, Paths.get(this.output, new String[0]));
        }
        catch (Throwable throwable) {
            this.handleThrowable(throwable);
        }
    }

    private void loadGoloFileCompilationUnit(String goloFile, HashMap<String, ASTCompilationUnit> units) {
        block17: {
            File file;
            block16: {
                file = new File(goloFile);
                if (!file.isDirectory()) break block16;
                File[] directoryFiles = file.listFiles();
                if (directoryFiles == null) break block17;
                for (File directoryFile : directoryFiles) {
                    this.loadGoloFileCompilationUnit(directoryFile.getAbsolutePath(), units);
                }
                break block17;
            }
            if (!file.getName().endsWith(".golo")) break block17;
            try (FileInputStream in = new FileInputStream(goloFile);){
                units.put(goloFile, new GoloOffsetParser(in).CompilationUnit());
            }
            catch (IOException e) {
                Messages.error(Messages.message("file_not_found", goloFile));
            }
            catch (ParseException e) {
                Messages.error(Messages.message("syntax_errors", goloFile, e.getMessage()));
            }
        }
    }

    static {
        FORMATS.put("markdown", new MarkdownProcessor());
        FORMATS.put("html", new HtmlProcessor());
        FORMATS.put("ctags", new CtagsProcessor());
    }

    public static class DocFormatValidator
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            if (!FORMATS.keySet().contains(value)) {
                throw new ParameterException(Messages.message("format_error", FORMATS.keySet()));
            }
        }
    }
}

