/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.tests;

import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.integration.tests.ModelIndexingTest;
import org.eclipse.hawk.integration.tests.emf.EMFModelSupportFactory;
import org.eclipse.hawk.integration.tests.mm.Tree.Tree;
import org.eclipse.hawk.svn.tests.rules.TemporarySVNRepository;
import org.eclipse.hawk.timeaware.tests.AbstractTimeAwareModelIndexingTest;
import org.eclipse.hawk.timeaware.tests.TimeAwareTestSuite;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FileContextTimeAwareEOLQueryEngineTest
extends AbstractTimeAwareModelIndexingTest {
    @Rule
    public TemporarySVNRepository svnRepositoryA = new TemporarySVNRepository();
    @Rule
    public TemporarySVNRepository svnRepositoryB = new TemporarySVNRepository();

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> params() {
        return TimeAwareTestSuite.caseParams();
    }

    public FileContextTimeAwareEOLQueryEngineTest(File baseDir, IGraphDatabaseFactory dbFactory) {
        super(baseDir, dbFactory, (ModelIndexingTest.IModelSupportFactory)new EMFModelSupportFactory());
    }

    @Override
    protected void setUpMetamodels() throws Exception {
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Tree.ecore")});
    }

    @Test
    public void testCounts() throws Throwable {
        File fTreeA = new File(this.svnRepositoryA.getCheckoutDirectory(), "root.xmi");
        Resource rTreeA = this.rsTree.createResource(URI.createFileURI((String)fTreeA.getAbsolutePath()));
        Tree a1 = this.treeFactory.createTree();
        a1.setLabel("A1");
        rTreeA.getContents().add((Object)a1);
        rTreeA.save(null);
        this.svnRepositoryA.add(new File[]{fTreeA});
        this.svnRepositoryA.commit("first in A");
        long startMillis = System.currentTimeMillis();
        File fTreeB = new File(this.svnRepositoryB.getCheckoutDirectory(), "main.xmi");
        Resource rTreeB = this.rsTree.createResource(URI.createFileURI((String)fTreeB.getAbsolutePath()));
        long elapsed = System.currentTimeMillis() - startMillis;
        Thread.sleep(Math.max(0L, 1000L - elapsed));
        Tree b1 = this.treeFactory.createTree();
        b1.setLabel("B1");
        rTreeB.getContents().add((Object)b1);
        rTreeB.save(null);
        this.svnRepositoryB.add(new File[]{fTreeB});
        this.svnRepositoryB.commit("first in B");
        this.requestSVNIndex();
        Assert.assertEquals((Object)2, (Object)this.timeAwareEOL("return Tree.latest.all.size;"));
        Assert.assertEquals((Object)1, (Object)this.timeAwareEOLInRepository("return Tree.latest.all.size;", this.svnRepositoryA));
        Assert.assertEquals((Object)"A1", (Object)this.timeAwareEOLInRepository("return Tree.latest.all.first.label;", this.svnRepositoryA));
        Assert.assertEquals((Object)1, (Object)this.timeAwareEOLInRepository("return Tree.latest.all.size;", this.svnRepositoryB));
        Assert.assertEquals((Object)"B1", (Object)this.timeAwareEOLInRepository("return Tree.latest.all.first.label;", this.svnRepositoryB));
    }

    private void requestSVNIndex() throws Throwable {
        this.requestSVNIndex(this.svnRepositoryA);
        this.scheduleAndWait();
        this.requestSVNIndex(this.svnRepositoryB);
        this.scheduleAndWait();
    }
}

