/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui2.view;

import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IStateListener;
import org.eclipse.hawk.osgiserver.HManager;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.ui2.Activator;
import org.eclipse.hawk.ui2.dialog.HConfigDialog;
import org.eclipse.hawk.ui2.dialog.HImportDialog;
import org.eclipse.hawk.ui2.dialog.HQueryDialog;
import org.eclipse.hawk.ui2.util.HUIManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.prefs.BackingStoreException;

public class HView
extends ViewPart {
    public static final String ID = "hawk.ui.view.HawkView";
    private TableViewer viewer;
    private Action query;
    private Action start;
    private Action stop;
    private Action sync;
    private Action delete;
    private Action add;
    private Action config;
    private Action importRepos;
    HUIManager hm;
    private Shell shell;
    ViewLabelProvider vlp;

    public void createPartControl(Composite parent) {
        this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        this.viewer = new TableViewer(parent, 770);
        this.hm = HUIManager.getInstance();
        this.viewer.setContentProvider((IContentProvider)this.hm);
        this.vlp = new ViewLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.vlp);
        this.viewer.setComparator(new ViewerComparator());
        this.viewer.setInput((Object)this.getViewSite());
        TableColumn c = new TableColumn(this.viewer.getTable(), 65536);
        c.setText("Name");
        c.setWidth(150);
        c = new TableColumn(this.viewer.getTable(), 65536);
        c.setText("Location");
        c.setWidth(450);
        c = new TableColumn(this.viewer.getTable(), 65536);
        c.setText("Status");
        c.setWidth(150);
        c = new TableColumn(this.viewer.getTable(), 65536);
        c.setText("Info");
        c.setWidth(450);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "hawkview.viewer");
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.hookPermanentDeleteAction();
        this.contributeToActionBars();
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty() || selection.size() > 1) {
                    HView.this.initButtons();
                }
                if (selection.size() == 1) {
                    HView.this.enableButtons();
                    HModel hmodel = (HModel)selection.getFirstElement();
                    IStateListener.HawkState status = hmodel.getStatus();
                    if (status == IStateListener.HawkState.UPDATING) {
                        HView.this.start.setEnabled(false);
                        HView.this.stop.setEnabled(false);
                        HView.this.delete.setEnabled(false);
                        HView.this.sync.setEnabled(false);
                        HView.this.query.setEnabled(false);
                        HView.this.config.setEnabled(false);
                    } else {
                        boolean running = hmodel.isRunning();
                        HView.this.start.setEnabled(!running);
                        HView.this.stop.setEnabled(running);
                        HView.this.sync.setEnabled(running);
                        HView.this.query.setEnabled(running);
                        HView.this.config.setEnabled(running);
                    }
                }
            }
        });
        this.viewer.refresh();
    }

    private void hookPermanentDeleteAction() {
        this.viewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (HView.this.viewer.getSelection().isEmpty()) {
                    return;
                }
                if (e.character == '\u007f' && (e.stateMask & 0x20000) > 0 && MessageDialog.openConfirm((Shell)HView.this.shell, (String)"Are you sure?", (String)"Do you want to permanently delete these instances (including storage)?")) {
                    IStructuredSelection selected = (IStructuredSelection)HView.this.viewer.getSelection();
                    for (HModel hawkModel : selected) {
                        try {
                            HView.this.hm.delete(hawkModel, hawkModel.exists());
                            HView.removeRecursive(Paths.get(hawkModel.getFolder(), new String[0]));
                        }
                        catch (IOException | BackingStoreException ex) {
                            ex.printStackTrace();
                        }
                    }
                    HView.this.viewer.refresh();
                }
            }
        });
    }

    private void initButtons() {
        this.query.setEnabled(false);
        this.start.setEnabled(false);
        this.stop.setEnabled(false);
        this.sync.setEnabled(false);
        this.delete.setEnabled(false);
        this.config.setEnabled(false);
    }

    private void enableButtons() {
        this.query.setEnabled(true);
        this.start.setEnabled(true);
        this.stop.setEnabled(true);
        this.sync.setEnabled(true);
        this.delete.setEnabled(true);
        this.config.setEnabled(true);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                HView.this.populateContributionManager((IContributionManager)manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.populateContributionManager((IContributionManager)bars.getMenuManager());
        this.populateContributionManager((IContributionManager)bars.getToolBarManager());
    }

    private void populateContributionManager(IContributionManager manager) {
        manager.add((IAction)this.query);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.start);
        manager.add((IAction)this.stop);
        manager.add((IAction)this.sync);
        manager.add((IAction)this.delete);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.add);
        manager.add((IAction)this.importRepos);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.config);
    }

    private void makeActions() {
        this.query = new Action(){

            public void run() {
                IStructuredSelection selected = (IStructuredSelection)HView.this.viewer.getSelection();
                HQueryDialog dialog = new HQueryDialog(HView.this.shell, (HModel)selected.getFirstElement());
                dialog.open();
            }
        };
        this.query.setText("Query");
        this.query.setToolTipText("Query");
        this.query.setImageDescriptor(ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)FrameworkUtil.getBundle(((Object)((Object)this)).getClass()), (IPath)new Path("icons/query.gif"), null)));
        this.start = new Action(){

            public void run() {
                IStructuredSelection selected = (IStructuredSelection)HView.this.viewer.getSelection();
                if (selected.size() == 1) {
                    HModel hawkModel = (HModel)selected.getFirstElement();
                    if (hawkModel.start((HManager)HView.this.hm)) {
                        HView.this.viewer.refresh();
                        HView.this.start.setEnabled(false);
                        HView.this.stop.setEnabled(true);
                        HView.this.sync.setEnabled(true);
                        HView.this.query.setEnabled(true);
                        HView.this.config.setEnabled(true);
                    } else {
                        HView.this.viewer.refresh();
                    }
                }
            }
        };
        this.start.setText("Start");
        this.start.setToolTipText("Start");
        this.start.setImageDescriptor(ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)FrameworkUtil.getBundle(((Object)((Object)this)).getClass()), (IPath)new Path("icons/nav_go.gif"), null)));
        this.stop = new Action(){

            public void run() {
                IStructuredSelection selected = (IStructuredSelection)HView.this.viewer.getSelection();
                if (selected.size() == 1) {
                    ((HModel)selected.getFirstElement()).stop(IModelIndexer.ShutdownRequestType.ALWAYS);
                    HView.this.viewer.refresh();
                    HView.this.start.setEnabled(true);
                    HView.this.stop.setEnabled(false);
                    HView.this.sync.setEnabled(false);
                    HView.this.query.setEnabled(false);
                    HView.this.config.setEnabled(false);
                }
            }
        };
        this.stop.setText("Stop");
        this.stop.setToolTipText("Stop");
        this.stop.setImageDescriptor(ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)FrameworkUtil.getBundle(((Object)((Object)this)).getClass()), (IPath)new Path("icons/stop.gif"), null)));
        this.sync = new Action(){

            public void run() {
                IStructuredSelection selected = (IStructuredSelection)HView.this.viewer.getSelection();
                if (selected.size() == 1) {
                    try {
                        ((HModel)selected.getFirstElement()).sync();
                    }
                    catch (Exception e) {
                        Activator.logError("Failed to invoke manual sync", e);
                    }
                }
            }
        };
        this.sync.setText("Sync");
        this.sync.setToolTipText("Sync");
        this.sync.setImageDescriptor(ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)FrameworkUtil.getBundle(((Object)((Object)this)).getClass()), (IPath)new Path("icons/refresh.gif"), null)));
        this.delete = new Action(){

            public void run() {
                IStructuredSelection selected = (IStructuredSelection)HView.this.viewer.getSelection();
                if (selected.size() == 1) {
                    HModel hawkmodel = (HModel)selected.getFirstElement();
                    try {
                        HView.this.hm.delete(hawkmodel, hawkmodel.exists());
                    }
                    catch (BackingStoreException e) {
                        e.printStackTrace();
                    }
                    HView.this.viewer.refresh();
                }
            }
        };
        this.delete.setText("Delete");
        this.delete.setToolTipText("Delete");
        this.delete.setImageDescriptor(ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)FrameworkUtil.getBundle(((Object)((Object)this)).getClass()), (IPath)new Path("icons/rem_co.gif"), null)));
        this.add = new Action(){

            public void run() {
                IWizardDescriptor descriptor = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard("hawk.ui.wizard.HawkNewWizard");
                if (descriptor != null) {
                    try {
                        IWorkbenchWizard wizard = descriptor.createWizard();
                        WizardDialog wd = new WizardDialog(HView.this.shell, (IWizard)wizard);
                        wd.setTitle(wizard.getWindowTitle());
                        wd.open();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.add.setText("Add");
        this.add.setToolTipText("Add");
        this.add.setImageDescriptor(ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)FrameworkUtil.getBundle(((Object)((Object)this)).getClass()), (IPath)new Path("icons/new-hawk.png"), null)));
        this.config = new Action(){

            public void run() {
                IStructuredSelection selected = (IStructuredSelection)HView.this.viewer.getSelection();
                HConfigDialog dialog = new HConfigDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (HModel)selected.getFirstElement());
                dialog.open();
            }
        };
        this.config.setText("Configure");
        this.config.setToolTipText("Configure");
        this.config.setImageDescriptor(ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)FrameworkUtil.getBundle(((Object)((Object)this)).getClass()), (IPath)new Path("icons/configure.gif"), null)));
        this.initButtons();
        this.importRepos = new Action(){

            public void run() {
                HImportDialog dialog = new HImportDialog(HView.this.shell);
                dialog.open();
            }
        };
        this.importRepos.setText("Import");
        this.importRepos.setToolTipText("Import existing instances");
        this.importRepos.setImageDescriptor(ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)FrameworkUtil.getBundle(((Object)((Object)this)).getClass()), (IPath)new Path("icons/import_wiz.png"), null)));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (HView.this.config.isEnabled()) {
                    HView.this.config.run();
                } else if (HView.this.start.isEnabled()) {
                    HView.this.start.run();
                }
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void update() {
        IStructuredSelection selected = (IStructuredSelection)this.viewer.getSelection();
        if (selected.size() == 1) {
            HModel hmodel = (HModel)selected.getFirstElement();
            IStateListener.HawkState status = hmodel.getStatus();
            if (status == IStateListener.HawkState.UPDATING) {
                this.start.setEnabled(false);
                this.stop.setEnabled(false);
                this.delete.setEnabled(false);
                this.sync.setEnabled(false);
                this.query.setEnabled(false);
                this.config.setEnabled(false);
            } else {
                boolean running = hmodel.isRunning();
                this.start.setEnabled(!running);
                this.stop.setEnabled(running);
                this.sync.setEnabled(running);
                this.query.setEnabled(running);
                this.config.setEnabled(running);
            }
        }
        this.viewer.refresh();
    }

    public static void updateAsync(Display display) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        HView view = (HView)page.findView(HView.ID);
                        if (view != null) {
                            view.update();
                        }
                    }
                    catch (Exception e) {
                        Activator.logError(e.getMessage(), e);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    private static void removeRecursive(java.nio.file.Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

            @Override
            public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(java.nio.file.Path file, IOException exc) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(java.nio.file.Path dir, IOException exc) throws IOException {
                if (exc == null) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                throw exc;
            }
        });
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected Image runningImage = null;
        protected Image stoppedImage = null;

        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            HModel hModel = (HModel)obj;
            if (index == 0) {
                return hModel.getName();
            }
            if (index == 1) {
                return hModel.getFolder();
            }
            if (index == 2) {
                switch (hModel.getStatus()) {
                    case RUNNING: {
                        return "Running";
                    }
                    case STOPPED: {
                        return "Stopped";
                    }
                    case UPDATING: {
                        return "Updating";
                    }
                }
                return hModel.getStatus().toString();
            }
            return hModel.getInfo();
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                return this.getImage(obj);
            }
            return null;
        }

        public Image getImage(Object obj) {
            HModel hModel;
            if (this.runningImage == null) {
                this.runningImage = Activator.getImageDescriptor("icons/hawk-running.png").createImage();
                this.stoppedImage = Activator.getImageDescriptor("icons/hawk-stopped.png").createImage();
            }
            if ((hModel = (HModel)obj).isRunning()) {
                return this.runningImage;
            }
            return this.stoppedImage;
        }
    }
}

