/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.orientdb.util;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.hawk.orientdb.OrientDatabase;

public class OrientClusterDocumentIterable
implements Iterable<OIdentifiable> {
    private final String clusterName;
    private final OrientDatabase db;

    public OrientClusterDocumentIterable(String clusterName, OrientDatabase db) {
        this.clusterName = clusterName;
        this.db = db;
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        int clusterId = this.db.getGraph().getClusterIdByName(this.clusterName);
        if (clusterId == -1) {
            return Collections.emptyListIterator();
        }
        final ORecordIteratorCluster it = this.db.getGraph().browseCluster(this.clusterName);
        return new Iterator<OIdentifiable>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public OIdentifiable next() {
                ODocument doc = (ODocument)it.next();
                ORID id = doc.getIdentity();
                if (id.isPersistent()) {
                    return id;
                }
                return doc;
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }
}

