/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.servlet.ServletException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TZlibTransport;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.osgiserver.HManager;
import org.eclipse.hawk.service.api.Hawk;
import org.eclipse.hawk.service.api.utils.APIUtils;
import org.eclipse.hawk.service.artemis.server.Server;
import org.eclipse.hawk.service.servlet.config.HawkServerConfigurator;
import org.eclipse.hawk.service.servlet.processors.HawkThriftIface;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final String ARTEMIS_PORT_PROPERTY = "hawk.artemis.port";
    private static final String ARTEMIS_HOST_PROPERTY = "hawk.artemis.host";
    private static final String ARTEMIS_LISTENALL_PROPERTY = "hawk.artemis.listenAll";
    private static final String ARTEMIS_SSL_PROPERTY = "hawk.artemis.sslEnabled";
    private static final String TCP_PORT_PROPERTY = "hawk.tcp.port";
    private static final String TCP_TPROTOCOL_PROPERTY = "hawk.tcp.thriftProtocol";
    private static BundleContext context;
    private static Activator instance;
    private static HawkServerConfigurator serverConfigurator;
    private Server artemis;
    private TThreadPoolServer tcpServer;

    public static Activator getInstance() {
        return instance;
    }

    public static String getPluginId() {
        return context.getBundle().getSymbolicName();
    }

    public Activator() {
        instance = this;
    }

    public File getDataFile(String filename) {
        return context.getDataFile(filename);
    }

    public File writeToDataFile(String filename, ByteBuffer contents) throws FileNotFoundException, IOException {
        File destFile = this.getDataFile(filename);
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileChannel fc = new FileOutputStream(destFile).getChannel();){
            fc.write(contents);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return destFile;
    }

    public void start(BundleContext bundleContext) throws Exception {
        String sSSLEnabled;
        String sArtemisPort;
        context = bundleContext;
        HManager.getInstance();
        String artemisHost = System.getProperty(ARTEMIS_HOST_PROPERTY);
        if (artemisHost == null) {
            artemisHost = "localhost";
        }
        int artemisPort = (sArtemisPort = System.getProperty(ARTEMIS_PORT_PROPERTY)) == null ? 61616 : Integer.valueOf(sArtemisPort);
        this.artemis = new Server(artemisHost, artemisPort);
        String sListenAll = System.getProperty(ARTEMIS_LISTENALL_PROPERTY);
        if (sListenAll != null) {
            this.artemis.setListenOnAllInterfaces(Boolean.valueOf(sListenAll).booleanValue());
        }
        if ((sSSLEnabled = System.getProperty(ARTEMIS_SSL_PROPERTY)) != null) {
            this.artemis.setSSLEnabled(Boolean.valueOf(sSSLEnabled).booleanValue());
        }
        try {
            this.artemis.start();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        final String sTCPPort = System.getProperty(TCP_PORT_PROPERTY);
        if (sTCPPort != null) {
            String sThriftProtocol = System.getProperty(TCP_TPROTOCOL_PROPERTY);
            final APIUtils.ThriftProtocol thriftProtocol = sThriftProtocol != null ? APIUtils.ThriftProtocol.valueOf((String)sThriftProtocol) : APIUtils.ThriftProtocol.TUPLE;
            TServerSocket tcpServerSocket = new TServerSocket(Integer.valueOf(sTCPPort).intValue());
            HawkThriftIface hawkIface = new HawkThriftIface(APIUtils.ThriftProtocol.TUPLE, null, this.artemis);
            Hawk.Processor hawkTCPProcessor = new Hawk.Processor((Hawk.Iface)hawkIface);
            serverConfigurator = new HawkServerConfigurator(hawkIface);
            serverConfigurator.loadHawkServerConfigurations();
            TThreadPoolServer.Args tcpServerArgs = (TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)tcpServerSocket).maxWorkerThreads(10000).protocolFactory(new TProtocolFactory(){
                private static final long serialVersionUID = 1L;

                public TProtocol getProtocol(TTransport arg0) {
                    return thriftProtocol.getProtocolFactory().getProtocol((TTransport)new TZlibTransport(arg0));
                }
            })).processor((TProcessor)hawkTCPProcessor);
            this.tcpServer = new TThreadPoolServer(tcpServerArgs);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Bundle bundle = context.getBundle();
                    Platform.getLog((Bundle)bundle).log((IStatus)new Status(1, bundle.getSymbolicName(), "Starting Hawk TCP server on port " + sTCPPort + " with Thrift protocol " + thriftProtocol.name()));
                    Activator.this.tcpServer.serve();
                }
            }).start();
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
        HManager.getInstance().stopAllRunningInstances(IModelIndexer.ShutdownRequestType.ONLY_LOCAL);
        if (this.artemis != null) {
            this.artemis.stop();
            this.artemis = null;
        }
        if (this.tcpServer != null) {
            this.tcpServer.stop();
            this.tcpServer = null;
        }
    }

    public Server getArtemisServer() {
        return this.artemis;
    }
}

