/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.core;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.hawk.core.VcsChangeType;
import org.eclipse.hawk.core.VcsCommit;

public class VcsCommitItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String path;
    protected VcsChangeType changeType;
    protected VcsCommit commit;

    public VcsCommit getCommit() {
        return this.commit;
    }

    public void setCommit(VcsCommit commit) {
        this.commit = commit;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        assert (path.startsWith("/")) : "Path " + path + " should start with a slash";
        assert (this.isValidURI(path)) : "Path " + path + " should be a valid URI";
        this.path = path;
    }

    private boolean isValidURI(String path) {
        try {
            new URI(path);
            return true;
        }
        catch (URISyntaxException ex) {
            return false;
        }
    }

    public VcsChangeType getChangeType() {
        return this.changeType;
    }

    public void setChangeType(VcsChangeType changeType) {
        this.changeType = changeType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof VcsCommitItem) {
            if (!this.path.equals(((VcsCommitItem)obj).getPath())) {
                return false;
            }
            if (!this.changeType.equals((Object)((VcsCommitItem)obj).getChangeType())) {
                return false;
            }
            return this.commit.revision.equals(((VcsCommitItem)obj).getCommit().revision) && this.commit.date.equals(((VcsCommitItem)obj).getCommit().date);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.path) + " : " + (Object)((Object)this.changeType);
    }
}

