/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.emf;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hawk.core.model.IHawkClassifier;
import org.eclipse.hawk.core.model.IHawkReference;
import org.eclipse.hawk.emf.EMFModelElement;
import org.eclipse.hawk.emf.EMFWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMFReference
extends EMFModelElement
implements IHawkReference {
    private static final Logger LOGGER = LoggerFactory.getLogger(EMFReference.class);
    EReference r;

    public EMFReference(EReference re, EMFWrapperFactory wf) {
        super((EModelElement)re, wf);
        this.r = re;
    }

    public String getName() {
        return this.r.getName();
    }

    public EReference getEObject() {
        return this.r;
    }

    public boolean isContainment() {
        return this.r.isContainment();
    }

    public boolean isContainer() {
        return this.r.isContainer();
    }

    public boolean isMany() {
        return this.r.isMany();
    }

    public boolean isOrdered() {
        return this.r.isOrdered();
    }

    public boolean isUnique() {
        return this.r.isUnique();
    }

    @Override
    public IHawkClassifier getType() {
        EClassifier type = this.r.getEType();
        if (type instanceof EClass) {
            return this.wf.createClass((EClass)this.r.getEType());
        }
        if (type instanceof EDataType) {
            return this.wf.createDataType((EDataType)this.r.getEType());
        }
        LOGGER.warn("Unknown EClassifier subclass: {}", (Object)this.r.getEType());
        return null;
    }

    @Override
    public int hashCode() {
        return this.r.hashCode();
    }
}

