/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.servlet.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.hawk.core.util.DerivedAttributeParameters;
import org.eclipse.hawk.core.util.IndexedAttributeParameters;
import org.eclipse.hawk.service.servlet.config.HawkInstanceConfig;
import org.eclipse.hawk.service.servlet.config.MetamodelParameters;
import org.eclipse.hawk.service.servlet.config.RepositoryParameters;
import org.eclipse.hawk.service.servlet.config.SchemaErrorHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class ConfigFileParser {
    private static final String HAWK = "hawk";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String BACKEND = "backend";
    private static final String FACTORY = "factory";
    private static final String DELAY = "delay";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String PLUGINS = "plugins";
    private static final String PLUGIN = "plugin";
    private static final String METAMODELS = "metamodels";
    private static final String METAMODEL = "metamodel";
    private static final String LOCATION = "location";
    private static final String URI = "uri";
    private static final String DERIVED_ATTRIBUTES = "derivedAttributes";
    private static final String DERIVED_ATTRIBUTE = "derivedAttribute";
    private static final String INDEXED_ATTRIBUTES = "indexedAttributes";
    private static final String INDEXED_ATTRIBUTE = "indexedAttribute";
    private static final String METAMODEL_URI = "metamodelUri";
    private static final String TYPE_NAME = "typeName";
    private static final String ATTRIBUTE_NAME = "attributeName";
    private static final String ATTRIBUTE_TYPE = "attributeType";
    private static final String IS_MANY = "isMany";
    private static final String IS_ORDERED = "isOrdered";
    private static final String IS_UNIQUE = "isUnique";
    private static final String DERIVATION = "derivation";
    private static final String LANGUAGE = "language";
    private static final String LOGIC = "logic";
    private static final String REPOSITORIES = "repositories";
    private static final String REPOSITORY = "repository";
    private static final String USER = "user";
    private static final String PASS = "pass";
    private static final String FROZEN = "frozen";
    private InputStream xsd = ConfigFileParser.class.getResourceAsStream("/resources/HawkServerConfigurationSchema.xsd");
    private Schema schema = null;

    public void setSchemaFile(String filePath) throws Exception {
        FileInputStream is = new FileInputStream(filePath);
        if (is != null) {
            this.xsd = is;
        }
    }

    public HawkInstanceConfig parse(File xmlFile) {
        HawkInstanceConfig config = null;
        if (xmlFile != null && xmlFile.exists()) {
            try {
                Element element = this.getXmlDocumentRootElement(xmlFile);
                config = new HawkInstanceConfig(xmlFile.getAbsolutePath());
                this.parseConfig(element, config);
            }
            catch (Exception e) {
                System.err.print("error in parse(File file): ");
                e.printStackTrace();
            }
        }
        return config;
    }

    public void saveConfigAsXml(HawkInstanceConfig config) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element hawkElement = document.createElement(HAWK);
            this.createAndAddAttribute(document, hawkElement, NAME, config.getName());
            this.createAndAddAttribute(document, hawkElement, BACKEND, config.getBackend());
            this.writeDelay(config, document, hawkElement);
            this.writePlugins(config, document, hawkElement);
            this.writeMetamodels(config, document, hawkElement);
            this.writeDerivedAttributes(config, document, hawkElement);
            this.writeIndexedAttributes(config, document, hawkElement);
            this.writeRepositories(config, document, hawkElement);
            document.appendChild(hawkElement);
            this.writeXmlDocumentToFile(document, config.getFileName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Element getXmlDocumentRootElement(File xmlFile) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (this.schema == null && this.xsd != null) {
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            StreamSource schemaSource = new StreamSource(this.xsd);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.schema = schemaFactory.newSchema(schemaSource);
        }
        if (this.schema != null) {
            factory.setSchema(this.schema);
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new SchemaErrorHandler());
        Document document = builder.parse(xmlFile);
        Element element = document.getDocumentElement();
        return element;
    }

    private void parseConfig(Element hawkElement, HawkInstanceConfig config) {
        if (hawkElement.getNodeName().equals(HAWK)) {
            config.setName(hawkElement.getAttribute(NAME));
            config.setBackend(hawkElement.getAttribute(BACKEND));
            config.setFactory(hawkElement.hasAttribute(FACTORY) ? hawkElement.getAttribute(FACTORY) : null);
            this.readDelay(hawkElement.getElementsByTagName(DELAY), config);
            this.readPlugins(hawkElement.getElementsByTagName(PLUGINS), config);
            this.readMetamodels(hawkElement.getElementsByTagName(METAMODELS), config);
            this.readRepositories(hawkElement.getElementsByTagName(REPOSITORIES), config);
            this.readIndexedAttributes(hawkElement.getElementsByTagName(INDEXED_ATTRIBUTES), config);
            this.readDerivedAttributes(hawkElement.getElementsByTagName(DERIVED_ATTRIBUTES), config);
        }
    }

    private void writeDelay(HawkInstanceConfig config, Document document, Element hawkElement) {
        Element delayElement = document.createElement(DELAY);
        this.createAndAddAttribute(document, delayElement, MAX, config.getDelayMax());
        this.createAndAddAttribute(document, delayElement, MIN, config.getDelayMin());
        hawkElement.appendChild(delayElement);
    }

    private void writePlugins(HawkInstanceConfig config, Document document, Element hawkElement) {
        if (config.getPlugins() != null && !config.getPlugins().isEmpty()) {
            Element pluginsElement = document.createElement(PLUGINS);
            for (String plugin : config.getPlugins()) {
                Element pluginElement = document.createElement(PLUGIN);
                this.createAndAddAttribute(document, pluginElement, NAME, plugin);
                pluginsElement.appendChild(pluginElement);
            }
            hawkElement.appendChild(pluginsElement);
        }
    }

    private void writeRepositories(HawkInstanceConfig config, Document document, Element hawkElement) {
        if (config.getRepositories() != null && !config.getRepositories().isEmpty()) {
            Element repositoriesElement = document.createElement(REPOSITORIES);
            for (RepositoryParameters params : config.getRepositories()) {
                Element repositoryElement = document.createElement(REPOSITORY);
                this.createAndAddAttribute(document, repositoryElement, TYPE, params.getType());
                this.createAndAddAttribute(document, repositoryElement, LOCATION, params.getLocation());
                this.createAndAddAttribute(document, repositoryElement, USER, params.getUser());
                this.createAndAddAttribute(document, repositoryElement, PASS, params.getPass());
                this.createAndAddAttribute(document, repositoryElement, FROZEN, params.isFrozen());
                repositoriesElement.appendChild(repositoryElement);
            }
            hawkElement.appendChild(repositoriesElement);
        }
    }

    private void writeIndexedAttributes(HawkInstanceConfig config, Document document, Element hawkElement) {
        if (config.getIndexedAttributes() != null && !config.getIndexedAttributes().isEmpty()) {
            Element indexedAttributesElement = document.createElement(INDEXED_ATTRIBUTES);
            for (IndexedAttributeParameters params : config.getIndexedAttributes()) {
                Element indexedAttributeElement = document.createElement(INDEXED_ATTRIBUTE);
                this.createAndAddAttribute(document, indexedAttributeElement, METAMODEL_URI, params.getMetamodelUri());
                this.createAndAddAttribute(document, indexedAttributeElement, TYPE_NAME, params.getTypeName());
                this.createAndAddAttribute(document, indexedAttributeElement, ATTRIBUTE_NAME, params.getAttributeName());
                indexedAttributesElement.appendChild(indexedAttributeElement);
            }
            hawkElement.appendChild(indexedAttributesElement);
        }
    }

    private void writeDerivedAttributes(HawkInstanceConfig config, Document document, Element hawkElement) {
        if (config.getDerivedAttributes() != null && !config.getDerivedAttributes().isEmpty()) {
            Element derivedAttributesElement = document.createElement(DERIVED_ATTRIBUTES);
            for (DerivedAttributeParameters params : config.getDerivedAttributes()) {
                Element derivedAttributeElement = document.createElement(DERIVED_ATTRIBUTE);
                this.createAndAddAttribute(document, derivedAttributeElement, METAMODEL_URI, params.getMetamodelUri());
                this.createAndAddAttribute(document, derivedAttributeElement, TYPE_NAME, params.getTypeName());
                this.createAndAddAttribute(document, derivedAttributeElement, ATTRIBUTE_NAME, params.getAttributeName());
                this.createAndAddAttribute(document, derivedAttributeElement, ATTRIBUTE_TYPE, params.getAttributeType());
                this.createAndAddAttribute(document, derivedAttributeElement, IS_MANY, params.isMany());
                this.createAndAddAttribute(document, derivedAttributeElement, IS_UNIQUE, params.isUnique());
                this.createAndAddAttribute(document, derivedAttributeElement, IS_ORDERED, params.isOrdered());
                Element derivationElement = document.createElement(DERIVATION);
                this.createAndAddAttribute(document, derivationElement, LANGUAGE, params.getDerivationLanguage());
                Element derivationLogicElement = document.createElement(LOGIC);
                CDATASection derivationLogicCData = document.createCDATASection(params.getDerivationLogic());
                derivationLogicElement.appendChild(derivationLogicCData);
                derivationElement.appendChild(derivationLogicElement);
                derivedAttributeElement.appendChild(derivationElement);
                derivedAttributesElement.appendChild(derivedAttributeElement);
            }
            hawkElement.appendChild(derivedAttributesElement);
        }
    }

    private void writeMetamodels(HawkInstanceConfig config, Document document, Element hawkElement) {
        if (config.getMetamodels() != null && !config.getMetamodels().isEmpty()) {
            Element metamodelsElement = document.createElement(METAMODELS);
            for (MetamodelParameters metamodel : config.getMetamodels()) {
                Element metamodelElement = document.createElement(METAMODEL);
                this.createAndAddAttribute(document, metamodelElement, LOCATION, metamodel.getLocation());
                this.createAndAddAttribute(document, metamodelElement, URI, metamodel.getUri());
                metamodelsElement.appendChild(metamodelElement);
            }
            hawkElement.appendChild(metamodelsElement);
        }
    }

    private void readDerivedAttributes(NodeList nodes, HawkInstanceConfig config) {
        for (Element derivedAttributesElement : ConfigFileParser.elementListIterable(nodes)) {
            for (Element derivedAttributeElement : ConfigFileParser.elementListIterable(derivedAttributesElement.getElementsByTagName(DERIVED_ATTRIBUTE))) {
                DerivedAttributeParameters params = new DerivedAttributeParameters(derivedAttributeElement.getAttribute(METAMODEL_URI), derivedAttributeElement.getAttribute(TYPE_NAME), derivedAttributeElement.getAttribute(ATTRIBUTE_NAME), derivedAttributeElement.getAttribute(ATTRIBUTE_TYPE), Boolean.valueOf(derivedAttributeElement.getAttribute(IS_MANY)).booleanValue(), Boolean.valueOf(derivedAttributeElement.getAttribute(IS_UNIQUE)).booleanValue(), Boolean.valueOf(derivedAttributeElement.getAttribute(IS_ORDERED)).booleanValue());
                Element derivationElement = this.getFirstElement(derivedAttributeElement.getElementsByTagName(DERIVATION));
                if (derivationElement != null) {
                    params.setDerivationLanguage(derivationElement.getAttribute(LANGUAGE));
                    Element logic = this.getFirstElement(derivationElement.getElementsByTagName(LOGIC));
                    if (logic != null) {
                        params.setDerivationLogic(this.readElementCDataValue(logic));
                    }
                }
                config.getDerivedAttributes().add(params);
            }
        }
    }

    private String readElementCDataValue(Node node) {
        StringBuffer buffer = new StringBuffer();
        NodeList cDataElements = node.getChildNodes();
        for (Node cDataElement : ConfigFileParser.nodeListIterable(cDataElements)) {
            buffer.append(cDataElement.getNodeValue());
        }
        return buffer.toString();
    }

    private void readIndexedAttributes(NodeList nodes, HawkInstanceConfig config) {
        for (Element indexedAttributeElements : ConfigFileParser.elementListIterable(nodes)) {
            for (Element indexedAttributeElement : ConfigFileParser.elementListIterable(indexedAttributeElements.getElementsByTagName(INDEXED_ATTRIBUTE))) {
                IndexedAttributeParameters params = new IndexedAttributeParameters(indexedAttributeElement.getAttribute(METAMODEL_URI), indexedAttributeElement.getAttribute(TYPE_NAME), indexedAttributeElement.getAttribute(ATTRIBUTE_NAME));
                config.getIndexedAttributes().add(params);
            }
        }
    }

    private void readRepositories(NodeList nodes, HawkInstanceConfig config) {
        for (Element repoElements : ConfigFileParser.elementListIterable(nodes)) {
            for (Element repoElement : ConfigFileParser.elementListIterable(repoElements.getElementsByTagName(REPOSITORY))) {
                RepositoryParameters params = new RepositoryParameters(repoElement.getAttribute(TYPE), repoElement.getAttribute(LOCATION), repoElement.hasAttribute(USER) ? repoElement.getAttribute(USER) : null, repoElement.hasAttribute(PASS) ? repoElement.getAttribute(PASS) : null, Boolean.valueOf(repoElement.getAttribute(FROZEN)));
                config.getRepositories().add(params);
            }
        }
    }

    private void readMetamodels(NodeList nodes, HawkInstanceConfig config) {
        for (Element metamodelElements : ConfigFileParser.elementListIterable(nodes)) {
            for (Element metamodelElement : ConfigFileParser.elementListIterable(metamodelElements.getElementsByTagName(METAMODEL))) {
                MetamodelParameters params = new MetamodelParameters(metamodelElement.getAttribute(URI), metamodelElement.getAttribute(LOCATION));
                config.getMetamodels().add(params);
            }
        }
    }

    private void readDelay(NodeList nodes, HawkInstanceConfig config) {
        Element element = this.getFirstElement(nodes);
        if (element != null) {
            config.setDelayMax(Integer.valueOf(element.getAttribute(MAX)));
            config.setDelayMin(Integer.valueOf(element.getAttribute(MIN)));
        }
    }

    private void readPlugins(NodeList nodes, HawkInstanceConfig config) {
        for (Element pluginsElement : ConfigFileParser.elementListIterable(nodes)) {
            for (Element pluginElement : ConfigFileParser.elementListIterable(pluginsElement.getElementsByTagName(PLUGIN))) {
                config.getPlugins().add(pluginElement.getAttribute(NAME));
            }
        }
    }

    private void writeXmlDocumentToFile(Node node, String filename) {
        try {
            File file = new File(filename);
            if (!file.exists()) {
                file.createNewFile();
            }
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS implementationLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSOutput output = implementationLS.createLSOutput();
            output.setEncoding("UTF-8");
            output.setCharacterStream(new FileWriter(file));
            LSSerializer serializer = implementationLS.createLSSerializer();
            serializer.getDomConfig().setParameter("format-pretty-print", true);
            serializer.write(node, output);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void createAndAddAttribute(Document document, Element element, String tagName, boolean value) {
        this.createAndAddAttribute(document, element, tagName, String.valueOf(value));
    }

    private void createAndAddAttribute(Document document, Element element, String tagName, String value) {
        if (value != null) {
            Attr attr = document.createAttribute(tagName);
            attr.setValue(value);
            element.setAttributeNode(attr);
        }
    }

    private void createAndAddAttribute(Document document, Element element, String tagName, int value) {
        this.createAndAddAttribute(document, element, tagName, String.valueOf(value));
    }

    private Element getFirstElement(NodeList n) {
        if (n.getLength() > 0) {
            return (Element)n.item(0);
        }
        return null;
    }

    public static Iterable<Element> elementListIterable(final NodeList n) {
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return new Iterator<Element>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < n.getLength();
                    }

                    @Override
                    public Element next() {
                        if (this.hasNext()) {
                            return (Element)n.item(this.index++);
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterable<Node> nodeListIterable(final NodeList n) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < n.getLength();
                    }

                    @Override
                    public Node next() {
                        if (this.hasNext()) {
                            return n.item(this.index++);
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

