/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui2.dialog;

import org.eclipse.hawk.core.IStateListener;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class HStateBasedDialog
extends TitleAreaDialog
implements IStateListener {
    protected HModel hawkModel;

    public HStateBasedDialog(HModel hawkModel, Shell parentShell) {
        super(parentShell);
        this.hawkModel = hawkModel;
        hawkModel.getHawk().getModelIndexer().addStateListener((IStateListener)this);
    }

    public boolean close() {
        this.hawkModel.getHawk().getModelIndexer().removeStateListener((IStateListener)this);
        return super.close();
    }

    protected boolean enableIfRunning(final IStateListener.HawkState s) {
        Display display;
        final boolean ret = s == IStateListener.HawkState.RUNNING;
        Shell shell = this.getShell();
        if (shell != null && (display = shell.getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ret) {
                        HStateBasedDialog.this.setErrorMessage(String.format("The index is %s - cannot confirm changes", s.toString().toLowerCase()));
                    } else {
                        HStateBasedDialog.this.setErrorMessage(null);
                    }
                    HStateBasedDialog.this.getButton(0).setEnabled(ret);
                }
            });
        }
        return ret;
    }

    public void state(IStateListener.HawkState state) {
        this.enableIfRunning(state);
    }

    public void info(String s) {
    }

    public void error(String s) {
    }

    public void removed() {
    }
}

