/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.modelio.exml.metamodel.parser;

import java.io.StringWriter;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.hawk.modelio.exml.metamodel.parser.MAggregationType;
import org.eclipse.hawk.modelio.exml.metamodel.parser.MAttributeType;
import org.eclipse.hawk.modelio.exml.metamodel.parser.MEnumeration;
import org.eclipse.hawk.modelio.exml.metamodel.parser.MFragment;
import org.eclipse.hawk.modelio.exml.metamodel.parser.MFragmentReference;
import org.eclipse.hawk.modelio.exml.metamodel.parser.MLinkMetaclass;
import org.eclipse.hawk.modelio.exml.metamodel.parser.MMetaclass;
import org.eclipse.hawk.modelio.exml.metamodel.parser.MMetaclassAttribute;
import org.eclipse.hawk.modelio.exml.metamodel.parser.MMetaclassDependency;
import org.eclipse.hawk.modelio.exml.metamodel.parser.MMetaclassReference;
import org.eclipse.hawk.modelio.exml.metamodel.parser.MMetamodelDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class MMetamodelParser {
    private MMetamodelDescriptor metamodelDescriptor = new MMetamodelDescriptor();
    private String xmlEncoding = "UTF-8";
    private MFragment currentFragment;

    public MMetamodelDescriptor parse(InputSource is) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(is);
            Element element = document.getDocumentElement();
            this.xmlEncoding = document.getXmlEncoding();
            if (this.isElement(element, "metamodel")) {
                this.parseMetamodel(element);
            } else if (this.isElement(element, "fragment")) {
                this.addFragment(element);
            } else {
                System.err.print("error in parse(File f): ");
            }
            this.resolveReferences();
        }
        catch (Exception e) {
            System.err.print("error in parse(File f): ");
            System.err.println(e.getCause());
            e.printStackTrace();
        }
        return this.metamodelDescriptor;
    }

    private void parseMetamodel(Node node) {
        this.metamodelDescriptor.setMetamodelFormat(this.getNodeNamedAttribute(node, "format"));
        this.metamodelDescriptor.setMetamodelDescriptorFormat(this.getNodeNamedAttribute(node, "MetamodelDescriptor.format"));
        for (Node childNode : MMetamodelParser.NodeListIterable(((Element)node).getElementsByTagName("fragment"))) {
            this.addFragment(childNode);
        }
    }

    private void addFragment(Node node) {
        this.currentFragment = new MFragment();
        this.currentFragment.setName(this.getNodeNamedAttribute(node, "name"));
        this.currentFragment.setVersion(this.getNodeNamedAttribute(node, "version"));
        this.currentFragment.setProvider(this.getNodeNamedAttribute(node, "provider"));
        this.currentFragment.setProviderVersion(this.getNodeNamedAttribute(node, "providerVersion"));
        for (Node enumerationsNode : MMetamodelParser.NodeListIterable(((Element)node).getElementsByTagName("enumerations"))) {
            for (Node enumerationNode : MMetamodelParser.NodeListIterable(((Element)enumerationsNode).getElementsByTagName("enumeration"))) {
                MEnumeration enumeration = this.parseEnumeration(enumerationNode);
                this.currentFragment.addDataType(enumeration);
            }
        }
        for (Node metaclassesNode : MMetamodelParser.NodeListIterable(((Element)node).getElementsByTagName("metaclasses"))) {
            for (Node metaclassNode : MMetamodelParser.NodeListIterable(((Element)metaclassesNode).getElementsByTagName("metaclass"))) {
                this.currentFragment.addMetaclass(this.parseMetaclass(metaclassNode));
            }
            for (Node metaclassNode : MMetamodelParser.NodeListIterable(((Element)metaclassesNode).getElementsByTagName("link_metaclass"))) {
                this.currentFragment.addMetaclass(this.parseLinkMetaclass(metaclassNode));
            }
        }
        for (Node dependenciesNode : MMetamodelParser.NodeListIterable(((Element)node).getElementsByTagName("dependencies"))) {
            for (Node dependencyNode : MMetamodelParser.NodeListIterable(((Element)dependenciesNode).getElementsByTagName("metamodel_fragment"))) {
                MFragmentReference fragmentRef = new MFragmentReference(this.getNodeNamedAttribute(dependencyNode, "name"), this.getNodeNamedAttribute(dependencyNode, "version"));
                this.currentFragment.addDependency(fragmentRef);
            }
        }
        this.currentFragment.setXmlString(this.getXmlString(node));
        this.metamodelDescriptor.addFragment(this.currentFragment);
    }

    private String getXmlString(Node node) {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS implementationLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSOutput output = implementationLS.createLSOutput();
            output.setEncoding(this.xmlEncoding);
            output.setCharacterStream(new StringWriter());
            LSSerializer serializer = implementationLS.createLSSerializer();
            serializer.write(node, output);
            return output.getCharacterStream().toString();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    private MEnumeration parseEnumeration(Node node) {
        MEnumeration enumeration = new MEnumeration(this.getNodeNamedAttribute(node, "name"));
        for (Node valueNode : MMetamodelParser.NodeListIterable(((Element)node).getElementsByTagName("value"))) {
            enumeration.addValue(this.getNodeNamedAttribute(valueNode, "name"));
        }
        return enumeration;
    }

    private MMetaclass parseMetaclass(Node node) {
        MMetaclass metaclass = new MMetaclass();
        this.parseMetaclassAttributes(metaclass, node);
        for (Node childNode : MMetamodelParser.NodeListIterable(node.getChildNodes())) {
            this.parseMetaclassChildren(metaclass, childNode);
        }
        return metaclass;
    }

    private MLinkMetaclass parseLinkMetaclass(Node node) {
        MLinkMetaclass metaclass = new MLinkMetaclass();
        this.parseMetaclassAttributes(metaclass, node);
        for (Node childNode : MMetamodelParser.NodeListIterable(node.getChildNodes())) {
            this.parseLinkMetaclassChildren(metaclass, childNode);
        }
        return metaclass;
    }

    private void parseMetaclassAttributes(MMetaclass metaclass, Node node) {
        metaclass.setName(this.getNodeNamedAttribute(node, "name"));
        metaclass.setVersion(this.getNodeNamedAttribute(node, "version"));
        metaclass.setAbstract(Boolean.valueOf(this.getNodeNamedAttribute(node, "abstract")));
        metaclass.setCmsNode(Boolean.valueOf(this.getNodeNamedAttribute(node, "cmsNode")));
    }

    private void parseMetaclassChildren(MMetaclass metaclass, Node node) {
        if (this.isElement(node, "attribute")) {
            String enumTypeName = this.getNodeNamedAttribute(node, "enumType");
            String typeName = this.getNodeNamedAttribute(node, "type");
            MAttributeType type = typeName.equals("java.lang.Enum") ? this.currentFragment.getDataType(enumTypeName) : this.resolveAttributeBasicType(typeName);
            MMetaclassAttribute attribute = new MMetaclassAttribute(this.getNodeNamedAttribute(node, "name"), type);
            metaclass.addAttribute(attribute);
        } else if (this.isElement(node, "parent")) {
            MMetaclassReference parent = new MMetaclassReference(this.getNodeNamedAttribute(node, "fragment"), this.getNodeNamedAttribute(node, "name"));
            metaclass.setParent(parent);
        } else if (this.isElement(node, "dependency")) {
            metaclass.addDependency(this.parseMetaclassDependency(node));
        }
    }

    private MAttributeType resolveAttributeBasicType(String typeName) {
        MAttributeType type = this.currentFragment.getDataType(typeName);
        if (type == null) {
            type = new MAttributeType(typeName);
            this.currentFragment.addDataType(type);
        }
        return type;
    }

    private MMetaclassDependency parseMetaclassDependency(Node node) {
        MMetaclassDependency dependency = new MMetaclassDependency();
        dependency.setName(this.getNodeNamedAttribute(node, "name"));
        String aggregationString = this.getNodeNamedAttribute(node, "aggregation");
        if (aggregationString == null) {
            dependency.setAggregation(MAggregationType.None);
        } else if (aggregationString.equals(MAggregationType.Composition.toString())) {
            dependency.setAggregation(MAggregationType.Composition);
        } else if (aggregationString.equals(MAggregationType.SharedAggregation.toString())) {
            dependency.setAggregation(MAggregationType.SharedAggregation);
        }
        dependency.setNavigate(Boolean.valueOf(this.getNodeNamedAttribute(node, "navigate")));
        dependency.setCascadeDelete(Boolean.valueOf(this.getNodeNamedAttribute(node, "cascadeDelete")));
        dependency.setWeakReference(Boolean.valueOf(this.getNodeNamedAttribute(node, "weakReference")));
        dependency.setMin(Integer.valueOf(this.getNodeNamedAttribute(node, "min")));
        dependency.setMax(Integer.valueOf(this.getNodeNamedAttribute(node, "max")));
        for (Node childNode : MMetamodelParser.NodeListIterable(node.getChildNodes())) {
            if (this.isElement(childNode, "target")) {
                MMetaclassReference target = new MMetaclassReference(this.getNodeNamedAttribute(childNode, "fragment"), this.getNodeNamedAttribute(childNode, "name"));
                dependency.setTarget(target);
                continue;
            }
            if (!this.isElement(childNode, "opposite")) continue;
            dependency.setOppositeName(this.getNodeNamedAttribute(childNode, "name"));
        }
        return dependency;
    }

    private void parseLinkMetaclassChildren(MLinkMetaclass metaclass, Node node) {
        if (this.isElement(node, "targets")) {
            for (Node depNode : MMetamodelParser.NodeListIterable(((Element)node).getElementsByTagName("dep"))) {
                metaclass.addTarget(this.getNodeNamedAttribute(depNode, "name"));
            }
        } else if (this.isElement(node, "sources")) {
            for (Node depNode : MMetamodelParser.NodeListIterable(((Element)node).getElementsByTagName("dep"))) {
                metaclass.addSource(this.getNodeNamedAttribute(depNode, "name"));
            }
        } else {
            this.parseMetaclassChildren(metaclass, node);
        }
    }

    private void resolveReferences() {
        for (MFragment fragment : this.metamodelDescriptor.getFragments().values()) {
            for (MFragmentReference fragmentDependencyEntry : fragment.getDependencies()) {
                this.resolveFragmentReference(fragmentDependencyEntry);
            }
            for (MMetaclass metaclass : fragment.getMetaclasses().values()) {
                this.resolveMetaclassReference(metaclass.getParent());
                if (metaclass.getParent() != null) {
                    MMetaclassReference childRef = new MMetaclassReference(fragment.getName(), metaclass.getName());
                    childRef.setMetaclass(metaclass);
                    if (metaclass.getParent().getMetaclass() != null) {
                        metaclass.getParent().getMetaclass().addChild(childRef);
                    }
                }
                for (MMetaclassDependency dependency : metaclass.getDependencies().values()) {
                    this.resolveMetaclassReference(dependency.getTarget());
                    this.resolveOppositeDependency(dependency);
                }
            }
        }
    }

    private void resolveMetaclassReference(MMetaclassReference ref) {
        MFragment targetFragment;
        if (ref != null && (targetFragment = this.metamodelDescriptor.getFragment(ref.getFragmentName())) != null) {
            MMetaclass targetMetaclass = targetFragment.getMetaclass(ref.getName());
            ref.setMetaclass(targetMetaclass);
        }
    }

    private void resolveFragmentReference(MFragmentReference ref) {
        if (ref != null) {
            MFragment targetFragment = this.metamodelDescriptor.getFragment(ref.getName());
            ref.setFragment(targetFragment);
        }
    }

    private void resolveOppositeDependency(MMetaclassDependency ref) {
        if (ref != null) {
            MFragment targetFragment = this.metamodelDescriptor.getFragment(ref.getTarget().getFragmentName());
            MMetaclass targetMetaclass = targetFragment.getMetaclass(ref.getTarget().getName());
            MMetaclassDependency dependency = targetMetaclass.getDependency(ref.getOppositeName());
            ref.setOppositeDependency(dependency);
        }
    }

    private String getNodeNamedAttribute(Node node, String attributeName) {
        if (node.hasAttributes() && node.getAttributes().getNamedItem(attributeName) != null) {
            return node.getAttributes().getNamedItem(attributeName).getNodeValue();
        }
        return null;
    }

    private boolean isElement(Node node, String name) {
        return node.getNodeType() == 1 && node.getNodeName().equals(name);
    }

    public static Iterable<Node> NodeListIterable(final NodeList n) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < n.getLength();
                    }

                    @Override
                    public Node next() {
                        if (this.hasNext()) {
                            return n.item(this.index++);
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

