/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.svn.tests;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.VcsChangeType;
import org.eclipse.hawk.core.VcsCommit;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.VcsRepositoryDelta;
import org.eclipse.hawk.core.util.DefaultConsole;
import org.eclipse.hawk.svn.SvnManager;
import org.eclipse.hawk.svn.tests.rules.TemporarySVNRepository;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.tmatesoft.svn.core.SVNException;

public class SvnManagerTest {
    private static final String DUMMY_PASS = "dummypass";
    private static final String DUMMY_USER = "dummyuser";
    @Rule
    public TemporarySVNRepository svn = new TemporarySVNRepository();
    private SvnManager vcs;
    private ICredentialsStore credStore;

    @Before
    public void setUp() throws Exception {
        this.credStore = (ICredentialsStore)Mockito.mock(ICredentialsStore.class);
        Mockito.when((Object)this.credStore.get(ArgumentMatchers.anyString())).thenReturn((Object)new ICredentialsStore.Credentials(DUMMY_USER, DUMMY_PASS));
        IModelIndexer indexer = (IModelIndexer)Mockito.mock(IModelIndexer.class);
        Mockito.when((Object)indexer.getConsole()).thenReturn((Object)new DefaultConsole());
        Mockito.when((Object)indexer.getCredentialsStore()).thenReturn((Object)this.credStore);
        this.vcs = new SvnManager();
        this.vcs.init(this.svn.getRepositoryURL().toString(), indexer);
        this.vcs.run();
        Assert.assertTrue((boolean)this.vcs.isActive());
    }

    @After
    public void tearDown() {
        this.vcs.shutdown();
    }

    @Test
    public void frozen() {
        Assert.assertFalse((boolean)this.vcs.isFrozen());
        this.vcs.setFrozen(true);
        Assert.assertTrue((boolean)this.vcs.isFrozen());
        this.vcs.setFrozen(false);
        Assert.assertFalse((boolean)this.vcs.isFrozen());
    }

    @Test
    public void emptyHistory() throws Exception {
        Assert.assertEquals((Object)"0", (Object)this.vcs.getFirstRevision());
        Assert.assertEquals((Object)"0", (Object)this.vcs.getCurrentRevision());
        Assert.assertEquals((Object)this.svn.getRepositoryURL().toString(), (Object)this.vcs.getLocation());
        Assert.assertEquals((Object)DUMMY_USER, (Object)this.vcs.getUsername());
        Assert.assertEquals((Object)DUMMY_PASS, (Object)this.vcs.getPassword());
    }

    @Test
    public void oneAdd() throws Exception {
        File testFile = this.svn.write("example", "test.txt", new String[0]).toFile();
        this.svn.add(testFile);
        this.svn.commit("initial commit");
        Assert.assertEquals((Object)"1", (Object)this.vcs.getCurrentRevision());
        Assert.assertEquals((Object)"0", (Object)this.vcs.getFirstRevision());
        Collection items = this.vcs.getDelta("0");
        Assert.assertEquals((long)1L, (long)items.size());
        VcsCommitItem item = (VcsCommitItem)items.iterator().next();
        Assert.assertEquals((Object)VcsChangeType.ADDED, (Object)item.getChangeType());
        Assert.assertEquals((Object)("/" + testFile.getName()), (Object)item.getPath());
        Assert.assertEquals((long)0L, (long)this.vcs.getDelta("1").size());
    }

    @Test
    public void compactedChanges() throws Exception {
        File testFile = this.svn.write("one more test", "my.xmi", new String[0]).toFile();
        this.svn.add(testFile);
        this.svn.commit("initial commit");
        this.svn.write("replacing contents", "my.xmi", new String[0]);
        this.svn.commit("rewrote my.xmi");
        this.svn.remove(testFile);
        this.svn.commit("deleted my.xmi");
        Collection items = this.vcs.getDelta("0");
        Assert.assertEquals((long)1L, (long)items.size());
        VcsCommitItem item = (VcsCommitItem)items.iterator().next();
        Assert.assertEquals((Object)VcsChangeType.DELETED, (Object)item.getChangeType());
        VcsRepositoryDelta delta = this.vcs.getDelta("1", "3");
        Assert.assertSame((Object)this.vcs, (Object)delta.getManager());
        Assert.assertEquals((long)3L, (long)delta.size());
        Assert.assertEquals((Object)items, (Object)delta.getCompactedCommitItems());
        Iterator commits = delta.getCommits().iterator();
        Assert.assertEquals((Object)VcsChangeType.ADDED, (Object)((VcsCommitItem)((VcsCommit)commits.next()).getItems().get(0)).getChangeType());
        Assert.assertEquals((Object)VcsChangeType.UPDATED, (Object)((VcsCommitItem)((VcsCommit)commits.next()).getItems().get(0)).getChangeType());
        Assert.assertEquals((Object)VcsChangeType.DELETED, (Object)((VcsCommitItem)((VcsCommit)commits.next()).getItems().get(0)).getChangeType());
    }

    @Test
    public void noExtensionFilesAreIgnored() throws Exception {
        this.assertFilenameIsIgnored("ihavenoextension");
    }

    @Test
    public void photoFilesAreIgnored() throws Exception {
        this.assertFilenameIsIgnored("photo.jpg");
    }

    @Test
    public void startingDotFilesAreIgnored() throws Exception {
        this.assertFilenameIsIgnored(".gitignore");
    }

    @Test
    public void setCredentialsStoresUserPass() throws Exception {
        String newUser = "anotherUser";
        String newPass = "anotherPass";
        this.vcs.setCredentials("anotherUser", "anotherPass", this.credStore);
        ((ICredentialsStore)Mockito.verify((Object)this.credStore)).put(this.svn.getRepositoryURL().toString(), new ICredentialsStore.Credentials("anotherUser", "anotherPass"));
    }

    @Test
    public void repositoryPath() throws Exception {
        Assert.assertEquals((Object)"/test.txt", (Object)this.vcs.getRepositoryPath(String.valueOf(this.svn.getRepositoryURL().toString()) + "/test.txt"));
        Assert.assertEquals((Object)"/test.txt", (Object)this.vcs.getRepositoryPath("/test.txt"));
    }

    @Test
    public void importFileHEAD() throws Exception {
        File testFile = this.svn.write("example", "something.xmi", new String[0]).toFile();
        this.svn.add(testFile);
        this.svn.commit("initial commit");
        File fTempDir = Files.createTempDirectory("import", new FileAttribute[0]).toFile();
        try {
            File fImported = this.vcs.importFile(null, "something.xmi", new File(fTempDir, "something.xmi"));
            Assert.assertEquals(Collections.singletonList("example"), Files.readAllLines(fImported.toPath()));
        }
        finally {
            fTempDir.delete();
        }
    }

    @Test
    public void importPreviousFile() throws Exception {
        File testFile = this.svn.write("example", "something.xmi", new String[0]).toFile();
        this.svn.add(testFile);
        this.svn.commit("initial commit");
        this.svn.write("changed", "something.xmi", new String[0]).toFile();
        this.svn.commit("second commit");
        File fTempDir = Files.createTempDirectory("import", new FileAttribute[0]).toFile();
        try {
            File fImported = this.vcs.importFile("1", "something.xmi", new File(fTempDir, "something.xmi"));
            Assert.assertEquals(Collections.singletonList("example"), Files.readAllLines(fImported.toPath()));
            this.vcs.importFile("2", "something.xmi", new File(fTempDir, "something.xmi"));
            Assert.assertEquals(Collections.singletonList("changed"), Files.readAllLines(fImported.toPath()));
        }
        finally {
            fTempDir.delete();
        }
    }

    protected void assertFilenameIsIgnored(String filename) throws IOException, SVNException, Exception {
        File testFile = this.svn.write("this should not be seen", filename, new String[0]).toFile();
        this.svn.add(testFile);
        this.svn.commit("initial commit");
        Assert.assertEquals((long)0L, (long)this.vcs.getDelta("0").size());
    }
}

