/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.orientdb.query;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSelect;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeReference;
import org.eclipse.hawk.core.query.IAccessListener;
import org.eclipse.hawk.core.query.IQueryEngine;
import org.eclipse.hawk.core.query.InvalidQueryException;
import org.eclipse.hawk.core.query.QueryExecutionException;
import org.eclipse.hawk.orientdb.OrientDatabase;
import org.eclipse.hawk.orientdb.OrientTransaction;

public class OrientSQLQueryEngine
implements IQueryEngine {
    public IAccessListener calculateDerivedAttributes(IModelIndexer m, Iterable<IGraphNode> nodes) throws InvalidQueryException, QueryExecutionException {
        throw new UnsupportedOperationException();
    }

    public List<String> validate(String derivationlogic) {
        OCommandSQL cmd = new OCommandSQL(derivationlogic);
        try {
            new OCommandExecutorSQLSelect().parse((OCommandRequest)cmd);
        }
        catch (OCommandSQLParsingException ex) {
            return Collections.singletonList(ex.toString());
        }
        return Collections.emptyList();
    }

    public void setDefaultNamespaces(String defaultNamespaces) {
    }

    public Object query(IModelIndexer m, String query, Map<String, Object> context) throws InvalidQueryException, QueryExecutionException {
        if (m.getGraph() instanceof OrientDatabase) {
            OrientDatabase graph = (OrientDatabase)m.getGraph();
            Throwable throwable = null;
            Object var6_7 = null;
            try (OrientTransaction tx = graph.beginTransaction();){
                Object val = this.query(graph, query);
                tx.success();
                return val;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        throw new InvalidQueryException("Backend is not OrientDB - cannot use this native query driver");
    }

    private Object query(OrientDatabase db, String query) throws InvalidQueryException {
        OCommandSQL cmd = new OCommandSQL(query);
        try {
            new OCommandExecutorSQLSelect().parse((OCommandRequest)cmd);
            Object result = db.getGraph().command((OCommandRequest)cmd).execute(new Object[0]);
            if (result instanceof ODocument) {
                ORID identity = ((ODocument)result).getIdentity();
                return identity.isValid() ? db.getNodeById(identity) : null;
            }
            if (result instanceof Iterable) {
                ArrayList<Object> results = new ArrayList<Object>();
                for (Object elem : (Iterable)result) {
                    if (!(elem instanceof ODocument)) continue;
                    ODocument odoc = (ODocument)elem;
                    ORID identity = odoc.getIdentity();
                    if (identity.isPersistent()) {
                        results.add(new OrientNodeWrapper(identity, db));
                        continue;
                    }
                    Map mapResult = odoc.toMap();
                    mapResult.remove("@rid");
                    results.add(mapResult);
                }
                return results;
            }
            return result;
        }
        catch (OCommandSQLParsingException ex) {
            throw new InvalidQueryException((Throwable)ex);
        }
    }

    public String getHumanReadableName() {
        return "Orient SQL Query Engine";
    }

    private class OrientNodeWrapper
    implements IGraphNodeReference {
        private final ORID identity;
        private final OrientDatabase db;

        private OrientNodeWrapper(ORID identity, OrientDatabase db) {
            this.identity = identity;
            this.db = db;
        }

        public String getTypeName() {
            IGraphNode typeNode = ((IGraphEdge)this.getNode().getEdgesWithType("_hawkOfType").iterator().next()).getEndNode();
            return typeNode.getProperty("_hawkid").toString();
        }

        public IGraphNode getNode() {
            return this.db.getNodeById(this.identity);
        }

        public String getId() {
            return this.identity.toString();
        }

        public IQueryEngine getContainerModel() {
            return OrientSQLQueryEngine.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.identity == null ? 0 : this.identity.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OrientNodeWrapper other = (OrientNodeWrapper)obj;
            return !(this.identity == null ? other.identity != null : !this.identity.equals((Object)other.identity));
        }

        public String toString() {
            return "ONW|id:" + this.identity + "|" + this.getTypeName();
        }
    }
}

