/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.core.runtime;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IHawk;
import org.eclipse.hawk.core.IHawkFactory;
import org.eclipse.hawk.core.IHawkPlugin;
import org.eclipse.hawk.core.IStateListener;
import org.eclipse.hawk.core.runtime.LocalHawk;
import org.eclipse.hawk.core.util.HawkProperties;
import org.eclipse.hawk.core.util.XStreamUtils;

public class LocalHawkFactory
implements IHawkFactory {
    public static final String ID = "org.eclipse.hawk.core.hawkFactory.local";

    @Override
    public IHawk create(String name, File localStorageFolder, String location, ICredentialsStore credStore, IConsole console, List<String> plugins) throws Exception {
        return new LocalHawk(name, localStorageFolder, credStore, console);
    }

    @Override
    public boolean instancesAreExtensible() {
        return true;
    }

    @Override
    public boolean instancesCreateGraph() {
        return true;
    }

    @Override
    public boolean instancesUseLocation() {
        return true;
    }

    @Override
    public IHawkFactory.InstanceInfo[] listInstances(String location) throws FileNotFoundException {
        File basePath = new File(location);
        if (!basePath.exists()) {
            throw new FileNotFoundException(String.valueOf(location) + " does not exist");
        }
        if (!basePath.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(location) + " is not a directory");
        }
        ArrayList<IHawkFactory.InstanceInfo> entries = new ArrayList<IHawkFactory.InstanceInfo>();
        if (basePath.exists()) {
            File[] fileArray = basePath.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File fProps;
                File f = fileArray[n2];
                if (f.isDirectory() && (fProps = new File(f, "properties.xml")).canRead()) {
                    try {
                        XStream stream = XStreamUtils.createXStreamLoader(HawkProperties.class);
                        HawkProperties hp = (HawkProperties)stream.fromXML(fProps);
                        entries.add(new IHawkFactory.InstanceInfo(f.getName(), hp.getDbType(), IStateListener.HawkState.STOPPED));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ++n2;
            }
        } else {
            System.err.println(basePath + " does not exist: returning an empty set");
        }
        return entries.toArray(new IHawkFactory.InstanceInfo[entries.size()]);
    }

    @Override
    public List<String> listBackends(String location) throws Exception {
        return null;
    }

    @Override
    public List<IHawkPlugin> listPlugins(String location) throws Exception {
        return null;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public String getHumanReadableName() {
        return "Local Hawk";
    }
}

