/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.epsilon.emc.pgetters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.AbstractPropertyGetter;
import org.eclipse.epsilon.eol.types.EolOrderedSet;
import org.eclipse.epsilon.eol.types.EolSequence;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeReference;
import org.eclipse.hawk.core.util.Utils;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.epsilon.emc.tracking.AccessListener;
import org.eclipse.hawk.epsilon.emc.wrappers.GraphEdgeWrapper;
import org.eclipse.hawk.graph.ModelElementNode;
import org.eclipse.hawk.graph.Slot;
import org.eclipse.hawk.graph.TypeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphPropertyGetter
extends AbstractPropertyGetter {
    public static final String REVERSE_REFNAV_PREFIX = "revRefNav_";
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphPropertyGetter.class);
    protected static final int IDX_FLAG_MANY = 1;
    protected static final int IDX_FLAG_ORDERED = 2;
    protected static final int IDX_FLAG_UNIQUE = 3;
    protected boolean broadcastAccess = false;
    protected IGraphDatabase graph;
    protected EOLQueryEngine model;
    protected AccessListener accessListener = new AccessListener();
    protected Map<Object, Map<String, PropertyType>> propertyTypeCache = new WeakHashMap<Object, Map<String, PropertyType>>();
    protected Map<Object, Map<String, String[]>> propertyTypeFlagsCache = new WeakHashMap<Object, Map<String, String[]>>();
    protected Map<Object, Map<String, Optional<TypeNode>>> targetTypeNodeCache = new WeakHashMap<Object, Map<String, Optional<TypeNode>>>();
    private IGraphNode featureStartingNodeClassNode;

    public GraphPropertyGetter(IGraphDatabase graph, EOLQueryEngine m) {
        this.graph = graph;
        this.model = m;
    }

    public Object invoke(Object object, String property, IEolContext context) throws EolRuntimeException {
        return this.invoke(object, property);
    }

    public Object invoke(Object object, String property) throws EolRuntimeException {
        if (!(object instanceof EOLQueryEngine.GraphNodeWrapper)) {
            throw new EolRuntimeException("a non GraphNodeWrapper object passed to GraphPropertyGetter!");
        }
        EOLQueryEngine.GraphNodeWrapper gnw = (EOLQueryEngine.GraphNodeWrapper)object;
        IGraphNode node = gnw.getNode();
        Object ret = this.invokePredefined(property, node);
        if (ret == null) {
            ret = this.invokeElementProperty(object, property, node, gnw.getTypeNode());
        }
        if (this.broadcastAccess) {
            this.broadcastAccess(object, property);
        }
        return ret;
    }

    protected Object invokeElementProperty(Object obj, String property, IGraphNode node, Optional<IGraphNode> optionalTypeNode) throws EolRuntimeException, EolIllegalPropertyException {
        PropertyType propertyType = this.getPropertyType(node, optionalTypeNode, property);
        switch (propertyType) {
            case ATTRIBUTE: {
                Object value = node.getProperty(property);
                if (value != null) {
                    if (!this.isMany(property)) {
                        return value;
                    }
                    return new Utils().asList(value);
                }
                return null;
            }
            case DERIVED: {
                Object derivedValue = null;
                for (IGraphEdge r : node.getOutgoingWithType(property)) {
                    if (derivedValue != null) {
                        throw new EolRuntimeException(String.format("WARNING: a derived property node (arity 1) -- (%s) has more than 1 links in store!", property));
                    }
                    IGraphNode nDerived = r.getEndNode();
                    derivedValue = nDerived.getProperty(property);
                    if (derivedValue != null) continue;
                    EolSequence derivedTargets = null;
                    for (IGraphEdge edge : nDerived.getOutgoingWithType("de" + property)) {
                        if (derivedTargets == null) {
                            derivedTargets = new EolSequence();
                            derivedValue = derivedTargets;
                        }
                        derivedTargets.add(this.model.wrap(edge.getEndNode()));
                    }
                }
                if (derivedValue == null) {
                    throw new EolRuntimeException("derived attribute lookup failed for: " + node + " # " + property);
                }
                if (derivedValue instanceof String && ((String)derivedValue).startsWith("_NYD##")) {
                    System.err.println("attribute: " + property + " is NYD for node: " + node.getId());
                }
                return derivedValue;
            }
            case MIXED: {
                Collection<Object> retCollection = this.getCollectionForProperty(property);
                if (node.getProperty(property) != null) {
                    List values = new Utils().asList(node.getProperty(property));
                    retCollection.addAll(values);
                }
                for (IGraphEdge r : node.getOutgoingWithType(property)) {
                    retCollection.add(this.model.wrap(r.getEndNode()));
                }
                return retCollection;
            }
            case REFERENCE: {
                IGraphNodeReference otherNode = null;
                Collection<Object> otherNodes = null;
                if (this.isMany(property)) {
                    otherNodes = this.getCollectionForProperty(property);
                }
                Optional<TypeNode> optTargetTypeNode = this.computeTargetTypeNode(property, optionalTypeNode);
                for (IGraphEdge r : node.getOutgoingWithType(property)) {
                    if (otherNodes != null) {
                        otherNodes.add(this.model.wrap(r.getEndNode(), optTargetTypeNode));
                        continue;
                    }
                    if (otherNode == null) {
                        otherNode = this.model.wrap(r.getEndNode(), optTargetTypeNode);
                        continue;
                    }
                    throw new EolRuntimeException("A relationship with arity 1 ( " + property + " ) has more than 1 links");
                }
                return otherNodes != null ? otherNodes : otherNode;
            }
        }
        return null;
    }

    protected Optional<TypeNode> computeTargetTypeNode(String property, Optional<IGraphNode> optionalSourceTypeNode) {
        Map localTargetReferenceCache = this.targetTypeNodeCache.computeIfAbsent(optionalSourceTypeNode.get().getId(), k -> new WeakHashMap());
        Optional optTargetTypeNode = localTargetReferenceCache.computeIfAbsent(property, prop -> this.computeReferenceTargetTypeNode(property, (IGraphNode)optionalSourceTypeNode.get()));
        return optTargetTypeNode;
    }

    protected Optional<TypeNode> computeReferenceTargetTypeNode(String property, IGraphNode sourceTypeNode) {
        TypeNode tn = new TypeNode(sourceTypeNode);
        Slot slot = tn.getSlot(property);
        TypeNode targetTypeNode = slot.getReferenceTargetTypeNode();
        if (targetTypeNode != null && targetTypeNode.getAllSubtypes().isEmpty()) {
            LOGGER.debug("Precomputed target type of {}: {}", (Object)property, (Object)sourceTypeNode);
            return Optional.of(targetTypeNode);
        }
        return Optional.empty();
    }

    protected Object invokePredefined(String property, IGraphNode node) throws EolRuntimeException {
        if (property.startsWith(REVERSE_REFNAV_PREFIX)) {
            String referenceName = property.substring(REVERSE_REFNAV_PREFIX.length());
            EolSequence ret = new EolSequence();
            for (IGraphEdge r : node.getIncomingWithType(referenceName)) {
                ret.add((Object)this.model.wrap(r.getStartNode()));
            }
            for (IGraphEdge r : node.getIncomingWithType("de" + referenceName)) {
                IGraphNode derivedNode = r.getStartNode();
                IGraphNode elementNode = ((IGraphEdge)derivedNode.getIncoming().iterator().next()).getStartNode();
                ret.add((Object)this.model.wrap(elementNode));
            }
            return ret;
        }
        switch (property) {
            case "hawkFile": {
                String sep = "";
                StringBuilder buff = new StringBuilder(32);
                for (IGraphEdge e2 : node.getOutgoingWithType("_hawkFile")) {
                    buff.append(sep);
                    buff.append(e2.getEndNode().getProperty("_hawkid").toString());
                    sep = ";";
                }
                return buff.toString();
            }
            case "hawkRepo": {
                String sep = "";
                StringBuilder buff = new StringBuilder(32);
                for (IGraphEdge e3 : node.getOutgoingWithType("_hawkFile")) {
                    buff.append(sep);
                    buff.append(e3.getEndNode().getProperty("repository").toString());
                    sep = ";";
                }
                return buff.toString();
            }
            case "hawkFiles": {
                HashSet<String> files = new HashSet<String>();
                for (IGraphEdge e4 : node.getOutgoingWithType("_hawkFile")) {
                    files.add(e4.getEndNode().getProperty("_hawkid").toString());
                }
                return files;
            }
            case "hawkRepos": {
                HashSet<String> repos = new HashSet<String>();
                for (IGraphEdge e5 : node.getOutgoingWithType("_hawkFile")) {
                    repos.add(e5.getEndNode().getProperty("repository").toString());
                }
                return repos;
            }
            case "eContainer": {
                IGraphNodeReference ret = null;
                for (IGraphEdge r : node.getIncoming()) {
                    if (r.getProperty("isContainment") == null) continue;
                    ret = this.model.wrap(r.getStartNode());
                    break;
                }
                if (ret == null) {
                    for (IGraphEdge r : node.getOutgoing()) {
                        if (r.getProperty("isContainer") == null) continue;
                        ret = this.model.wrap(r.getEndNode());
                        break;
                    }
                }
                return ret;
            }
            case "eContainers": {
                Object ret = null;
                for (IGraphEdge r : node.getIncoming()) {
                    if (r.getProperty("isContainment") == null) continue;
                    return Collections.singletonList(this.model.wrap(r.getStartNode()));
                }
                if (ret == null) {
                    for (IGraphEdge r : node.getOutgoing()) {
                        if (r.getProperty("isContainer") == null) continue;
                        return Collections.singletonList(this.model.wrap(r.getEndNode()));
                    }
                }
                return Collections.emptyList();
            }
            case "eContents": {
                return this.getContents(node);
            }
            case "eAllContents": {
                return this.addAllContents(node, new ArrayList<IGraphNodeReference>());
            }
            case "hawkIn": 
            case "hawkOut": {
                List<GraphEdgeWrapper> edges = this.getEdges(node, property.equals("hawkIn"));
                return edges.stream().map(e -> e.getEndNode()).collect(Collectors.toList());
            }
            case "hawkOutEdges": 
            case "hawkInEdges": {
                return this.getEdges(node, property.equals("hawkInEdges"));
            }
            case "hawkURIFragment": {
                return node.getProperty("_hawkid");
            }
            case "hawkProxies": {
                ModelElementNode men = new ModelElementNode(node);
                return men.getProxies();
            }
            case "hawkNodeId": {
                return node.getId();
            }
        }
        return null;
    }

    protected List<GraphEdgeWrapper> getEdges(IGraphNode node, boolean isIncoming) {
        EolSequence results = new EolSequence();
        Iterable edges = isIncoming ? node.getIncoming() : node.getOutgoing();
        for (IGraphEdge r : edges) {
            if (ModelElementNode.TRANSIENT_EDGE_LABELS.contains(r.getType())) continue;
            if (r.getProperty("isDerived") != null) {
                IGraphNode derivedNode = isIncoming ? r.getStartNode() : r.getEndNode();
                Iterable it = isIncoming ? derivedNode.getIncoming() : derivedNode.getOutgoing();
                for (IGraphEdge derivedEdge : it) {
                    results.add(new GraphEdgeWrapper(derivedEdge, this.model));
                }
                continue;
            }
            results.add(new GraphEdgeWrapper(r, this.model));
        }
        return results;
    }

    private List<IGraphNodeReference> addAllContents(IGraphNode node, List<IGraphNodeReference> results) {
        for (IGraphNodeReference child : this.getContents(node)) {
            results.add(child);
            this.addAllContents(child.getNode(), results);
        }
        return results;
    }

    private List<IGraphNodeReference> getContents(IGraphNode node) {
        LinkedHashMap<Object, IGraphNodeReference> results = new LinkedHashMap<Object, IGraphNodeReference>();
        for (IGraphEdge r : node.getOutgoing()) {
            if (r.getProperty("isContainment") == null) continue;
            IGraphNode endNode = r.getEndNode();
            results.put(endNode.getId(), this.model.wrap(endNode));
        }
        for (IGraphEdge r : node.getIncoming()) {
            if (r.getProperty("isContainer") == null) continue;
            IGraphNode startNode = r.getStartNode();
            results.put(startNode.getId(), this.model.wrap(startNode));
        }
        return new ArrayList<IGraphNodeReference>(results.values());
    }

    protected Collection<Object> getCollectionForProperty(String property) {
        if (this.isUnique(property)) {
            return new EolOrderedSet();
        }
        return new EolSequence();
    }

    protected void broadcastAccess(Object object, String property) {
        this.accessListener.accessed(String.valueOf(((EOLQueryEngine.GraphNodeWrapper)object).getId()), property);
    }

    public void setBroadcastAccess(boolean b) {
        this.broadcastAccess = b;
    }

    public AccessListener getAccessListener() {
        return this.accessListener;
    }

    public IGraphDatabase getGraph() {
        return this.graph;
    }

    public boolean getBroadcastStatus() {
        return this.broadcastAccess;
    }

    protected boolean canHaveDerivedAttr(IGraphNode node, Optional<IGraphNode> optionalTypeNode, String property) {
        return this.getPropertyType(node, optionalTypeNode, property) == PropertyType.DERIVED;
    }

    protected boolean canHaveMixed(IGraphNode node, Optional<IGraphNode> optionalTypeNode, String property) {
        return this.getPropertyType(node, optionalTypeNode, property) == PropertyType.MIXED;
    }

    protected boolean canHaveAttr(IGraphNode node, Optional<IGraphNode> optionalTypeNode, String property) {
        return this.getPropertyType(node, optionalTypeNode, property) == PropertyType.ATTRIBUTE;
    }

    protected boolean canHaveRef(IGraphNode node, Optional<IGraphNode> optionalTypeNode, String property) {
        return this.getPropertyType(node, optionalTypeNode, property) == PropertyType.REFERENCE;
    }

    protected boolean isMany(String ref) {
        return this.isTypeFlagActive(ref, 1);
    }

    protected boolean isOrdered(String ref) {
        return this.isTypeFlagActive(ref, 2);
    }

    protected boolean isUnique(String ref) {
        return this.isTypeFlagActive(ref, 3);
    }

    protected PropertyType getPropertyType(IGraphNode node, Optional<IGraphNode> optionalTypeNode, String property) {
        if (optionalTypeNode.isPresent()) {
            this.featureStartingNodeClassNode = optionalTypeNode.get();
            Map knownProperties = this.propertyTypeCache.computeIfAbsent(this.featureStartingNodeClassNode.getId(), id -> new HashMap());
            PropertyType actual = knownProperties.computeIfAbsent(property, prop -> {
                PropertyType result;
                String value = "_null_hawk_value_error";
                Object nodeProperty = this.featureStartingNodeClassNode.getProperty(prop);
                if (nodeProperty instanceof String[]) {
                    value = ((String[])nodeProperty)[0];
                }
                if ((result = PropertyType.fromCharacter(value)) == PropertyType.INVALID) {
                    LOGGER.warn("property: {} not found in metamodel for type: {}", prop, this.featureStartingNodeClassNode.getProperty("_hawkid"));
                }
                return result;
            });
            return actual;
        }
        LOGGER.warn("type not found for node {}", (Object)node);
        return PropertyType.INVALID;
    }

    protected boolean isTypeFlagActive(String reference, int index) {
        if (this.featureStartingNodeClassNode == null) {
            LOGGER.warn("type not found previously for {}", (Object)reference);
            return false;
        }
        Map knownTypeFlags = this.propertyTypeFlagsCache.computeIfAbsent(this.featureStartingNodeClassNode.getId(), id -> new HashMap());
        String[] typeFlags = knownTypeFlags.computeIfAbsent(reference, ref -> (String[])this.featureStartingNodeClassNode.getProperty(reference));
        if (typeFlags != null) {
            return typeFlags[index].equals("t");
        }
        LOGGER.warn("reference: {} not found in metamodel (isMany) for type: {}", (Object)reference, this.featureStartingNodeClassNode.getProperty("_hawkid"));
        return false;
    }

    public String debug(EOLQueryEngine.GraphNodeWrapper object) {
        IGraphNode node = object.getNode();
        String ret = node.toString();
        for (String p : node.getPropertyKeys()) {
            Object n = node.getProperty(p);
            String temp = "error: " + n.getClass();
            if (n instanceof int[]) {
                temp = Arrays.toString((int[])n);
            }
            if (n instanceof long[]) {
                temp = Arrays.toString((long[])n);
            }
            if (n instanceof String[]) {
                temp = Arrays.toString((String[])n);
            }
            if (n instanceof boolean[]) {
                temp = Arrays.toString((boolean[])n);
            }
            ret = String.valueOf(ret) + "[" + p + ";" + (p.equals("class") || p.equals("superclass") ? (temp.length() < 1000 ? temp : "[<TOO LONG TO LOG (>1000chars)>]") : n) + "] ";
        }
        HashSet<String> refs = new HashSet<String>();
        for (IGraphEdge r : node.getOutgoing()) {
            refs.add(r.getType().toString());
        }
        return String.valueOf(ret) + "\nOF TYPE: " + new TypeNode(node).getTypeName() + "\nWITH OUTGOING REFERENCES: " + refs;
    }

    protected static enum PropertyType {
        ATTRIBUTE,
        DERIVED,
        REFERENCE,
        MIXED,
        INVALID;


        static PropertyType fromCharacter(String s) {
            switch (s) {
                case "d": {
                    return DERIVED;
                }
                case "r": {
                    return REFERENCE;
                }
                case "a": {
                    return ATTRIBUTE;
                }
                case "m": {
                    return MIXED;
                }
            }
            return INVALID;
        }
    }
}

