/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.auth;

import io.vertx.core.json.JsonObject;
import java.security.Principal;
import java.util.Objects;

public class Device
implements Principal {
    private final JsonObject principal;

    public Device(String tenantId, String deviceId) {
        this.principal = this.getPrincipal(tenantId, deviceId);
    }

    private JsonObject getPrincipal(String tenantId, String deviceId) {
        return new JsonObject().put("tenant-id", Objects.requireNonNull(tenantId)).put("device-id", Objects.requireNonNull(deviceId));
    }

    public final JsonObject principal() {
        return this.principal;
    }

    public final String getTenantId() {
        return this.principal.getString("tenant-id");
    }

    public final String getDeviceId() {
        return this.principal.getString("device-id");
    }

    @Override
    public final String getName() {
        return this.getDeviceId();
    }

    @Override
    public final String toString() {
        return String.format("device [%s: %s, %s: %s]", "device-id", this.getDeviceId(), "tenant-id", this.getTenantId());
    }

    public static final String asAddress(String tenantId, String deviceId) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        return String.format("%s/%s", tenantId, deviceId);
    }

    public static final String asAddress(Device device) {
        return String.format("%s/%s", device.getTenantId(), device.getDeviceId());
    }
}

