/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetCondition;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetConditionBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetConditionFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetStatus;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DaemonSetStatusFluentImpl<A extends DaemonSetStatusFluent<A>>
extends BaseFluent<A>
implements DaemonSetStatusFluent<A> {
    private Integer collisionCount;
    private ArrayList<DaemonSetConditionBuilder> conditions = new ArrayList();
    private Integer currentNumberScheduled;
    private Integer desiredNumberScheduled;
    private Integer numberAvailable;
    private Integer numberMisscheduled;
    private Integer numberReady;
    private Integer numberUnavailable;
    private Long observedGeneration;
    private Integer updatedNumberScheduled;
    private Map<String, Object> additionalProperties;

    public DaemonSetStatusFluentImpl() {
    }

    public DaemonSetStatusFluentImpl(DaemonSetStatus instance) {
        if (instance != null) {
            this.withCollisionCount(instance.getCollisionCount());
            this.withConditions(instance.getConditions());
            this.withCurrentNumberScheduled(instance.getCurrentNumberScheduled());
            this.withDesiredNumberScheduled(instance.getDesiredNumberScheduled());
            this.withNumberAvailable(instance.getNumberAvailable());
            this.withNumberMisscheduled(instance.getNumberMisscheduled());
            this.withNumberReady(instance.getNumberReady());
            this.withNumberUnavailable(instance.getNumberUnavailable());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withUpdatedNumberScheduled(instance.getUpdatedNumberScheduled());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    @Override
    public A withCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return (A)this;
    }

    @Override
    public Boolean hasCollisionCount() {
        return this.collisionCount != null;
    }

    @Override
    public A addToConditions(int index, DaemonSetCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        DaemonSetConditionBuilder builder = new DaemonSetConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToConditions(int index, DaemonSetCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        DaemonSetConditionBuilder builder = new DaemonSetConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(DaemonSetCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (DaemonSetCondition item : items) {
            DaemonSetConditionBuilder builder = new DaemonSetConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<DaemonSetCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (DaemonSetCondition item : items) {
            DaemonSetConditionBuilder builder = new DaemonSetConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(DaemonSetCondition ... items) {
        for (DaemonSetCondition item : items) {
            DaemonSetConditionBuilder builder = new DaemonSetConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<DaemonSetCondition> items) {
        for (DaemonSetCondition item : items) {
            DaemonSetConditionBuilder builder = new DaemonSetConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<DaemonSetConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<DaemonSetConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            DaemonSetConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<DaemonSetCondition> getConditions() {
        return this.conditions != null ? DaemonSetStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<DaemonSetCondition> buildConditions() {
        return this.conditions != null ? DaemonSetStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public DaemonSetCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public DaemonSetCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public DaemonSetCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public DaemonSetCondition buildMatchingCondition(Predicate<DaemonSetConditionBuilder> predicate) {
        for (DaemonSetConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<DaemonSetConditionBuilder> predicate) {
        for (DaemonSetConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<DaemonSetCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (DaemonSetCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(DaemonSetCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (DaemonSetCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new DaemonSetCondition(lastTransitionTime, message, reason, status, type));
    }

    @Override
    public DaemonSetStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public DaemonSetStatusFluent.ConditionsNested<A> addNewConditionLike(DaemonSetCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public DaemonSetStatusFluent.ConditionsNested<A> setNewConditionLike(int index, DaemonSetCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public DaemonSetStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public DaemonSetStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public DaemonSetStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public DaemonSetStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<DaemonSetConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Integer getCurrentNumberScheduled() {
        return this.currentNumberScheduled;
    }

    @Override
    public A withCurrentNumberScheduled(Integer currentNumberScheduled) {
        this.currentNumberScheduled = currentNumberScheduled;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentNumberScheduled() {
        return this.currentNumberScheduled != null;
    }

    @Override
    public Integer getDesiredNumberScheduled() {
        return this.desiredNumberScheduled;
    }

    @Override
    public A withDesiredNumberScheduled(Integer desiredNumberScheduled) {
        this.desiredNumberScheduled = desiredNumberScheduled;
        return (A)this;
    }

    @Override
    public Boolean hasDesiredNumberScheduled() {
        return this.desiredNumberScheduled != null;
    }

    @Override
    public Integer getNumberAvailable() {
        return this.numberAvailable;
    }

    @Override
    public A withNumberAvailable(Integer numberAvailable) {
        this.numberAvailable = numberAvailable;
        return (A)this;
    }

    @Override
    public Boolean hasNumberAvailable() {
        return this.numberAvailable != null;
    }

    @Override
    public Integer getNumberMisscheduled() {
        return this.numberMisscheduled;
    }

    @Override
    public A withNumberMisscheduled(Integer numberMisscheduled) {
        this.numberMisscheduled = numberMisscheduled;
        return (A)this;
    }

    @Override
    public Boolean hasNumberMisscheduled() {
        return this.numberMisscheduled != null;
    }

    @Override
    public Integer getNumberReady() {
        return this.numberReady;
    }

    @Override
    public A withNumberReady(Integer numberReady) {
        this.numberReady = numberReady;
        return (A)this;
    }

    @Override
    public Boolean hasNumberReady() {
        return this.numberReady != null;
    }

    @Override
    public Integer getNumberUnavailable() {
        return this.numberUnavailable;
    }

    @Override
    public A withNumberUnavailable(Integer numberUnavailable) {
        this.numberUnavailable = numberUnavailable;
        return (A)this;
    }

    @Override
    public Boolean hasNumberUnavailable() {
        return this.numberUnavailable != null;
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public Integer getUpdatedNumberScheduled() {
        return this.updatedNumberScheduled;
    }

    @Override
    public A withUpdatedNumberScheduled(Integer updatedNumberScheduled) {
        this.updatedNumberScheduled = updatedNumberScheduled;
        return (A)this;
    }

    @Override
    public Boolean hasUpdatedNumberScheduled() {
        return this.updatedNumberScheduled != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DaemonSetStatusFluentImpl that = (DaemonSetStatusFluentImpl)o;
        if (!Objects.equals(this.collisionCount, that.collisionCount)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.currentNumberScheduled, that.currentNumberScheduled)) {
            return false;
        }
        if (!Objects.equals(this.desiredNumberScheduled, that.desiredNumberScheduled)) {
            return false;
        }
        if (!Objects.equals(this.numberAvailable, that.numberAvailable)) {
            return false;
        }
        if (!Objects.equals(this.numberMisscheduled, that.numberMisscheduled)) {
            return false;
        }
        if (!Objects.equals(this.numberReady, that.numberReady)) {
            return false;
        }
        if (!Objects.equals(this.numberUnavailable, that.numberUnavailable)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.updatedNumberScheduled, that.updatedNumberScheduled)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.collisionCount, this.conditions, this.currentNumberScheduled, this.desiredNumberScheduled, this.numberAvailable, this.numberMisscheduled, this.numberReady, this.numberUnavailable, this.observedGeneration, this.updatedNumberScheduled, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.collisionCount != null) {
            sb.append("collisionCount:");
            sb.append(this.collisionCount + ",");
        }
        if (this.conditions != null) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.currentNumberScheduled != null) {
            sb.append("currentNumberScheduled:");
            sb.append(this.currentNumberScheduled + ",");
        }
        if (this.desiredNumberScheduled != null) {
            sb.append("desiredNumberScheduled:");
            sb.append(this.desiredNumberScheduled + ",");
        }
        if (this.numberAvailable != null) {
            sb.append("numberAvailable:");
            sb.append(this.numberAvailable + ",");
        }
        if (this.numberMisscheduled != null) {
            sb.append("numberMisscheduled:");
            sb.append(this.numberMisscheduled + ",");
        }
        if (this.numberReady != null) {
            sb.append("numberReady:");
            sb.append(this.numberReady + ",");
        }
        if (this.numberUnavailable != null) {
            sb.append("numberUnavailable:");
            sb.append(this.numberUnavailable + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.updatedNumberScheduled != null) {
            sb.append("updatedNumberScheduled:");
            sb.append(this.updatedNumberScheduled + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ConditionsNestedImpl<N>
    extends DaemonSetConditionFluentImpl<DaemonSetStatusFluent.ConditionsNested<N>>
    implements DaemonSetStatusFluent.ConditionsNested<N>,
    Nested<N> {
        DaemonSetConditionBuilder builder;
        int index;

        ConditionsNestedImpl(int index, DaemonSetCondition item) {
            this.index = index;
            this.builder = new DaemonSetConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new DaemonSetConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)DaemonSetStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

