/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import jakarta.annotation.Priority;
import java.io.Serializable;
import org.eclipse.microprofile.config.spi.Converter;
import org.wildfly.common.net.CidrAddress;
import org.wildfly.common.net.Inet;

@Priority(value=200)
public class CidrAddressConverter
implements Converter<CidrAddress>,
Serializable {
    private static final long serialVersionUID = 2023552088048952902L;

    @Override
    public CidrAddress convert(String value) {
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        CidrAddress result = Inet.parseCidrAddress(value);
        if (result == null) {
            throw new IllegalArgumentException("Failed to parse CIDR address \"" + value + "\"");
        }
        return result;
    }
}

