/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific.event;

import com.google.common.base.Preconditions;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IMatchUpdateListener;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.MatchUpdateAdapter;
import org.eclipse.incquery.runtime.evm.api.event.EventHandler;
import org.eclipse.incquery.runtime.evm.api.event.adapter.EventSourceAdapter;
import org.eclipse.incquery.runtime.evm.notification.IAttributeMonitorListener;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEvent;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventRealm;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventSourceSpecification;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventTypeEnum;
import org.eclipse.incquery.runtime.exception.IncQueryException;

public class IncQueryEventSource<Match extends IPatternMatch>
extends EventSourceAdapter<Match> {
    private final IncQueryMatcher<Match> matcher;
    private IAttributeMonitorListener<Match> attributeMonitorListener;
    private IMatchUpdateListener<Match> matchUpdateListener;

    protected IncQueryEventSource(IncQueryEventRealm realm, IncQueryEventSourceSpecification<Match> sourceDefinition) throws IncQueryException {
        super(sourceDefinition, realm);
        IncQueryMatcher _matcher;
        IQuerySpecification<IncQueryMatcher<Match>> factory = sourceDefinition.getQuerySpecification();
        this.matcher = _matcher = factory.getMatcher(realm.getEngine());
    }

    public IncQueryMatcher<Match> getMatcher() {
        return this.matcher;
    }

    @Override
    protected void beforeHandlerAdded(EventHandler<Match> handler, boolean handlersEmpty) {
        this.resendEventsForExistingMatches(handler);
        if (handlersEmpty) {
            ((AdvancedIncQueryEngine)this.matcher.getEngine()).addMatchUpdateListener(this.matcher, this.matchUpdateListener, false);
        }
    }

    @Override
    protected void afterHandlerRemoved(EventHandler<Match> handler, boolean handlersEmpty) {
        if (handlersEmpty) {
            ((AdvancedIncQueryEngine)this.matcher.getEngine()).removeMatchUpdateListener(this.matcher, this.matchUpdateListener);
        }
    }

    @Override
    protected void prepareSource() {
        this.attributeMonitorListener = this.prepareAttributeMonitorListener();
        this.matchUpdateListener = this.prepareMatchUpdateListener();
    }

    protected IAttributeMonitorListener<Match> prepareAttributeMonitorListener() {
        return new IAttributeMonitorListener<Match>(){

            @Override
            public void notifyUpdate(Match atom) {
                IncQueryEventSource.this.notifyHandlers(new IncQueryEvent(IncQueryEventTypeEnum.MATCH_UPDATES, atom));
            }
        };
    }

    protected IMatchUpdateListener<Match> prepareMatchUpdateListener() {
        IMatchProcessor matchAppearProcessor = new IMatchProcessor<Match>(){

            public void process(Match match) {
                IncQueryEventSource.this.notifyHandlers(new IncQueryEvent(IncQueryEventTypeEnum.MATCH_APPEARS, match));
            }
        };
        IMatchProcessor matchDisppearProcessor = new IMatchProcessor<Match>(){

            public void process(Match match) {
                IncQueryEventSource.this.notifyHandlers(new IncQueryEvent(IncQueryEventTypeEnum.MATCH_DISAPPEARS, match));
            }
        };
        return new MatchUpdateAdapter(matchAppearProcessor, matchDisppearProcessor);
    }

    private void resendEventsForExistingMatches(final EventHandler<Match> handler) {
        this.matcher.forEachMatch(new IMatchProcessor<Match>(){

            public void process(Match match) {
                handler.handleEvent(new IncQueryEvent(IncQueryEventTypeEnum.MATCH_APPEARS, match));
            }
        });
    }

    @Override
    public void dispose() {
        ((AdvancedIncQueryEngine)this.matcher.getEngine()).removeMatchUpdateListener(this.matcher, this.matchUpdateListener);
        super.dispose();
    }

    public IAttributeMonitorListener<Match> getAttributeMonitorListener() {
        Preconditions.checkState((this.attributeMonitorListener != null ? 1 : 0) != 0, (Object)"Event source not prepared yet!");
        return this.attributeMonitorListener;
    }
}

