/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.matcher;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.MatchingTable;
import org.eclipse.incquery.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.incquery.runtime.localsearch.matcher.ILocalSearchAdapter;
import org.eclipse.incquery.runtime.localsearch.plan.SearchPlanExecutor;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;

public class LocalSearchMatcher {
    private ImmutableList<SearchPlanExecutor> plan;
    private int frameSize;
    private int keySize;
    private PQuery query;
    private List<ILocalSearchAdapter> adapters = Lists.newLinkedList();

    public ImmutableList<SearchPlanExecutor> getPlan() {
        return this.plan;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public List<ILocalSearchAdapter> getAdapters() {
        return this.adapters;
    }

    protected LocalSearchMatcher(PQuery query) {
        Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"Cannot initialize matcher with null query.");
        this.query = query;
    }

    public LocalSearchMatcher(PQuery query, SearchPlanExecutor plan, int keySize, int frameSize) {
        this(query, (ImmutableList<SearchPlanExecutor>)ImmutableList.of((Object)plan), keySize, frameSize);
    }

    public LocalSearchMatcher(PQuery query, SearchPlanExecutor[] plan, int keySize, int frameSize) {
        this(query, (ImmutableList<SearchPlanExecutor>)ImmutableList.copyOf((Object[])plan), keySize, frameSize);
    }

    public LocalSearchMatcher(PQuery query, Collection<SearchPlanExecutor> plan, int keySize, int frameSize) {
        this(query, (ImmutableList<SearchPlanExecutor>)ImmutableList.copyOf(plan), keySize, frameSize);
    }

    protected LocalSearchMatcher(PQuery query, ImmutableList<SearchPlanExecutor> plan, int keySize, int frameSize) {
        this(query);
        this.keySize = keySize;
        this.plan = plan;
        this.frameSize = frameSize;
        this.adapters = Lists.newLinkedList(this.adapters);
    }

    public void addAdapter(ILocalSearchAdapter adapter) {
        this.adapters.add(adapter);
    }

    public void removeAdapter(ILocalSearchAdapter adapter) {
        this.adapters.remove(adapter);
    }

    protected void setPlan(SearchPlanExecutor plan) {
        this.plan = ImmutableList.of((Object)plan);
    }

    protected void setPlan(SearchPlanExecutor[] plan) {
        this.plan = ImmutableList.copyOf((Object[])plan);
    }

    protected void setFramesize(int frameSize) {
        this.frameSize = frameSize;
    }

    protected void setKeysize(int keySize) {
        this.keySize = keySize;
    }

    public MatchingFrame editableMatchingFrame() {
        return new MatchingFrame(null, this.keySize, this.frameSize);
    }

    public boolean hasMatch() throws LocalSearchException {
        boolean hasMatch = this.hasMatch(this.editableMatchingFrame());
        return hasMatch;
    }

    public boolean hasMatch(MatchingFrame initialFrame) throws LocalSearchException {
        this.matchingStarted();
        PlanExecutionIterator it = new PlanExecutionIterator(this.plan, initialFrame, this.adapters);
        boolean hasMatch = it.hasNext();
        this.matchingFinished();
        return hasMatch;
    }

    public int countMatches() throws LocalSearchException {
        int countMatches = this.countMatches(this.editableMatchingFrame());
        return countMatches;
    }

    public int countMatches(MatchingFrame initialFrame) throws LocalSearchException {
        this.matchingStarted();
        PlanExecutionIterator it = new PlanExecutionIterator(this.plan, initialFrame, this.adapters);
        this.matchingFinished();
        return Iterators.size((Iterator)((Object)it));
    }

    public MatchingFrame getOneArbitraryMatch() throws LocalSearchException {
        MatchingFrame oneArbitraryMatch = this.getOneArbitraryMatch(this.editableMatchingFrame());
        return oneArbitraryMatch;
    }

    public MatchingFrame getOneArbitraryMatch(MatchingFrame initialFrame) throws LocalSearchException {
        this.matchingStarted();
        PlanExecutionIterator it = new PlanExecutionIterator(this.plan, initialFrame, this.adapters);
        MatchingFrame returnValue = null;
        if (it.hasNext()) {
            returnValue = it.next();
        }
        this.matchingFinished();
        return returnValue;
    }

    public Collection<MatchingFrame> getAllMatches() throws LocalSearchException {
        Collection<MatchingFrame> allMatches = this.getAllMatches(this.editableMatchingFrame());
        return allMatches;
    }

    private void matchingStarted() {
        for (ILocalSearchAdapter adapter : this.adapters) {
            adapter.patternMatchingStarted(this);
        }
    }

    private void matchingFinished() {
        for (ILocalSearchAdapter adapter : this.adapters) {
            adapter.patternMatchingFinished(this);
        }
    }

    public Collection<MatchingFrame> getAllMatches(MatchingFrame initialFrame) throws LocalSearchException {
        this.matchingStarted();
        PlanExecutionIterator it = new PlanExecutionIterator(this.plan, initialFrame, this.adapters);
        MatchingTable results = new MatchingTable();
        while (it.hasNext()) {
            MatchingFrame frame = it.next();
            results.put(frame.getKey(), frame);
        }
        this.matchingFinished();
        return ImmutableList.copyOf(results.iterator());
    }

    public PQuery getQuerySpecification() {
        return this.query;
    }

    private static class PlanExecutionIterator
    extends UnmodifiableIterator<MatchingFrame> {
        private UnmodifiableIterator<SearchPlanExecutor> iterator;
        private SearchPlanExecutor currentPlan;
        private MatchingFrame frame;
        private boolean frameReturned;
        private List<ILocalSearchAdapter> adapters = Lists.newLinkedList();

        public PlanExecutionIterator(ImmutableList<SearchPlanExecutor> plan, MatchingFrame initialFrame, List<ILocalSearchAdapter> adapters) {
            this.adapters = adapters;
            this.frame = initialFrame.clone();
            Preconditions.checkArgument((plan.size() > 0 ? 1 : 0) != 0);
            this.iterator = plan.iterator();
            this.getNextPlan();
            this.frameReturned = true;
        }

        private void getNextPlan() {
            if (this.currentPlan != null) {
                this.currentPlan.removeAdapters(this.adapters);
            }
            this.currentPlan = (SearchPlanExecutor)this.iterator.next();
            this.currentPlan.addAdapters(this.adapters);
            this.currentPlan.resetPlan();
        }

        public boolean hasNext() {
            if (!this.frameReturned) {
                return true;
            }
            try {
                boolean foundMatch = this.currentPlan.execute(this.frame);
                while (!foundMatch && this.iterator.hasNext()) {
                    this.getNextPlan();
                    foundMatch = this.currentPlan.execute(this.frame);
                }
                if (foundMatch) {
                    this.frameReturned = false;
                }
                return foundMatch;
            }
            catch (LocalSearchException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        }

        public MatchingFrame next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more matches available.");
            }
            this.frameReturned = true;
            return this.frame.clone();
        }
    }
}

