/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.matcher.integration;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.incquery.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.incquery.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.incquery.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.incquery.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.incquery.runtime.localsearch.operations.extend.ExtendToEStructuralFeatureSource;
import org.eclipse.incquery.runtime.localsearch.operations.extend.IterateOverEClassInstances;
import org.eclipse.incquery.runtime.localsearch.operations.extend.IterateOverEDatatypeInstances;
import org.eclipse.incquery.runtime.localsearch.operations.extend.IterateOverEStructuralFeatureInstances;
import org.eclipse.incquery.runtime.localsearch.plan.SearchPlan;
import org.eclipse.incquery.runtime.localsearch.plan.SearchPlanExecutor;
import org.eclipse.incquery.runtime.localsearch.planner.LocalSearchPlanner;
import org.eclipse.incquery.runtime.localsearch.planner.LocalSearchPlannerStrategy;
import org.eclipse.incquery.runtime.localsearch.planner.POperationCompiler;
import org.eclipse.incquery.runtime.matchers.backend.IQueryBackend;
import org.eclipse.incquery.runtime.matchers.backend.IQueryBackendHintProvider;
import org.eclipse.incquery.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.incquery.runtime.matchers.backend.IUpdateable;
import org.eclipse.incquery.runtime.matchers.context.IPatternMatcherContext;
import org.eclipse.incquery.runtime.matchers.context.IPatternMatcherRuntimeContext;
import org.eclipse.incquery.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PBodyNormalizer;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PQueryFlattener;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;

public class LocalSearchResultProvider
implements IQueryResultProvider {
    private static final String UPDATE_LISTENER_NOT_SUPPORTED = "Local search backend does not support update listening.";
    private final IQueryBackend backend;
    private final IPatternMatcherRuntimeContext matcherContext;
    private final IQueryBackendHintProvider hintProvider;
    private final PQuery query;

    public LocalSearchResultProvider(IQueryBackend backend, IPatternMatcherRuntimeContext matcherContext, IQueryBackendHintProvider hintProvider, PQuery query) {
        this.backend = backend;
        this.matcherContext = matcherContext;
        this.hintProvider = hintProvider;
        this.query = query;
    }

    private LocalSearchMatcher initializeMatcher(Object[] parameters) {
        try {
            return this.newLocalSearchMatcher(parameters);
        }
        catch (QueryProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IncQueryException e) {
            throw new RuntimeException(e);
        }
    }

    public LocalSearchMatcher newLocalSearchMatcher(Object[] parameters) throws IncQueryException, QueryProcessingException {
        IncQueryEngine engine = (IncQueryEngine)this.hintProvider;
        ISearchContext.SearchContext searchContext = new ISearchContext.SearchContext(engine.getBaseIndex());
        HashSet classesToIndex = Sets.newHashSet();
        HashSet featuresToIndex = Sets.newHashSet();
        HashSet dataTypesToIndex = Sets.newHashSet();
        HashSet adornment = Sets.newHashSet();
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i] != null) {
                adornment.add(i);
            }
            ++i;
        }
        MatcherReference reference = new MatcherReference(this.query, adornment);
        HashSet dependencies = Sets.newHashSet((Object[])new MatcherReference[]{reference});
        HashSet processedDependencies = Sets.newHashSet();
        Sets.SetView todo = Sets.difference((Set)dependencies, (Set)processedDependencies);
        while (!todo.isEmpty()) {
            MatcherReference dependency = (MatcherReference)todo.iterator().next();
            Planner planner = new Planner();
            planner.createPlan(dependency, this.matcherContext, searchContext);
            planner.collectElementsToIndex(classesToIndex, featuresToIndex, dataTypesToIndex);
            planner.collectDependencies(dependencies);
            processedDependencies.add(dependency);
        }
        searchContext.registerObservedTypes(classesToIndex, dataTypesToIndex, featuresToIndex);
        return searchContext.getMatcher(reference);
    }

    public int countMatches(Object[] parameters) {
        try {
            LocalSearchMatcher matcher = this.initializeMatcher(parameters);
            MatchingFrame frame = matcher.editableMatchingFrame();
            int i = 0;
            while (i < parameters.length) {
                frame.setValue(i, parameters[i]);
                ++i;
            }
            return matcher.countMatches(frame);
        }
        catch (LocalSearchException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public Tuple getOneArbitraryMatch(Object[] parameters) {
        try {
            LocalSearchMatcher matcher = this.initializeMatcher(parameters);
            MatchingFrame frame = matcher.editableMatchingFrame();
            int i = 0;
            while (i < parameters.length) {
                frame.setValue(i, parameters[i]);
                ++i;
            }
            return matcher.getOneArbitraryMatch(frame);
        }
        catch (LocalSearchException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public Collection<? extends Tuple> getAllMatches(Object[] parameters) {
        try {
            LocalSearchMatcher matcher = this.initializeMatcher(parameters);
            MatchingFrame frame = matcher.editableMatchingFrame();
            int i = 0;
            while (i < parameters.length) {
                frame.setValue(i, parameters[i]);
                ++i;
            }
            return matcher.getAllMatches(frame);
        }
        catch (LocalSearchException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public IQueryBackend getQueryBackend() {
        return this.backend;
    }

    public void addUpdateListener(IUpdateable listener, Object listenerTag, boolean fireNow) {
    }

    public void removeUpdateListener(Object listenerTag) {
    }

    private static class Planner {
        List<List<ISearchOperation>> operations;
        private POperationCompiler compiler;

        private Planner() {
        }

        public void createPlan(MatcherReference key, IPatternMatcherRuntimeContext matcherContext, final ISearchContext searchContext) throws QueryProcessingException {
            PQueryFlattener flattener = new PQueryFlattener();
            PBodyNormalizer normalizer = new PBodyNormalizer((IPatternMatcherContext)matcherContext, false);
            LocalSearchPlannerStrategy strategy = new LocalSearchPlannerStrategy();
            this.compiler = new POperationCompiler();
            LocalSearchPlanner planner = new LocalSearchPlanner();
            planner.initializePlanner(flattener, (IPatternMatcherContext)matcherContext, normalizer, strategy, this.compiler);
            this.operations = planner.plan(key.getQuery(), key.getAdornment());
            Collection executors = Collections2.transform(this.operations, (Function)new Function<List<ISearchOperation>, SearchPlanExecutor>(){

                public SearchPlanExecutor apply(List<ISearchOperation> input) {
                    SearchPlan plan = new SearchPlan();
                    plan.addOperations(input);
                    return new SearchPlanExecutor(plan, searchContext);
                }
            });
            Collection parameterSizes = Collections2.transform((Collection)planner.getNormalizedDisjunction().getBodies(), (Function)new Function<PBody, Integer>(){

                public Integer apply(PBody input) {
                    return input.getUniqueVariables().size();
                }
            });
            int keySize = key.getQuery().getParameters().size();
            LocalSearchMatcher matcher = new LocalSearchMatcher(key.getQuery(), executors, keySize, (int)((Integer)Collections.max(parameterSizes)));
            searchContext.loadMatcher(key, matcher);
        }

        public void collectElementsToIndex(Set<EClass> classesToIndex, Set<EStructuralFeature> featuresToIndex, Set<EDataType> dataTypesToIndex) {
            for (List<ISearchOperation> plan : this.operations) {
                for (ISearchOperation operation : plan) {
                    if (operation instanceof ExtendToEStructuralFeatureSource) {
                        featuresToIndex.add(((ExtendToEStructuralFeatureSource)operation).getFeature());
                        continue;
                    }
                    if (operation instanceof IterateOverEClassInstances) {
                        classesToIndex.add(((IterateOverEClassInstances)operation).getClazz());
                        continue;
                    }
                    if (operation instanceof IterateOverEDatatypeInstances) {
                        dataTypesToIndex.add(((IterateOverEDatatypeInstances)operation).getDataType());
                        continue;
                    }
                    if (!(operation instanceof IterateOverEStructuralFeatureInstances)) continue;
                    featuresToIndex.add(((IterateOverEStructuralFeatureInstances)operation).getFeature());
                }
            }
        }

        public void collectDependencies(Set<MatcherReference> dependencies) {
            dependencies.addAll(this.compiler.getDependencies());
        }
    }
}

