/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.operations.check;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.incquery.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.incquery.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.incquery.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.incquery.runtime.localsearch.operations.check.CheckOperation;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;

public class NACOperation
extends CheckOperation {
    PQuery calledQuery;
    LocalSearchMatcher matcher;
    Map<Integer, Integer> frameMapping;

    public LocalSearchMatcher getCalledMatcher() {
        return this.matcher;
    }

    public NACOperation(PQuery calledQuery, Map<Integer, Integer> frameMapping) {
        this.calledQuery = calledQuery;
        this.frameMapping = frameMapping;
    }

    public PQuery getCalledQuery() {
        return this.calledQuery;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        super.onInitialize(frame, context);
        HashSet adornment = Sets.newHashSet();
        for (Map.Entry<Integer, Integer> mapping : this.frameMapping.entrySet()) {
            Integer source = mapping.getKey();
            if (frame.get(source) == null) continue;
            adornment.add(mapping.getValue());
        }
        this.matcher = context.getMatcher(new MatcherReference(this.calledQuery, adornment));
    }

    @Override
    protected boolean check(MatchingFrame frame) throws LocalSearchException {
        MatchingFrame mappedFrame = this.matcher.editableMatchingFrame();
        for (Map.Entry<Integer, Integer> entry : this.frameMapping.entrySet()) {
            mappedFrame.setValue(entry.getValue(), frame.getValue(entry.getKey()));
        }
        return !this.matcher.hasMatch(mappedFrame);
    }
}

