/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.operations.extend;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.incquery.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.incquery.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.incquery.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.incquery.runtime.localsearch.operations.extend.ExtendOperation;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;

public class CountOperation
extends ExtendOperation<Integer> {
    PQuery calledQuery;
    Map<Integer, Integer> frameMapping;
    private LocalSearchMatcher calledMatcher;

    public LocalSearchMatcher getCalledMatcher() {
        return this.calledMatcher;
    }

    public CountOperation(PQuery calledQuery, Map<Integer, Integer> frameMapping, int position) {
        super(position);
        this.calledQuery = calledQuery;
        this.frameMapping = frameMapping;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        HashSet adornment = Sets.newHashSet();
        for (Map.Entry<Integer, Integer> mapping : this.frameMapping.entrySet()) {
            Integer source = mapping.getKey();
            if (frame.get(source) == null) continue;
            adornment.add(mapping.getValue());
        }
        this.calledMatcher = context.getMatcher(new MatcherReference(this.calledQuery, adornment));
        MatchingFrame mappedFrame = this.calledMatcher.editableMatchingFrame();
        for (Map.Entry<Integer, Integer> entry : this.frameMapping.entrySet()) {
            mappedFrame.setValue(entry.getValue(), frame.getValue(entry.getKey()));
        }
        this.it = Iterators.singletonIterator((Object)this.calledMatcher.countMatches(mappedFrame));
    }
}

