/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.plan;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.incquery.runtime.localsearch.matcher.ILocalSearchAdapter;
import org.eclipse.incquery.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.incquery.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.incquery.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.incquery.runtime.localsearch.operations.check.BinaryTransitiveClosureCheck;
import org.eclipse.incquery.runtime.localsearch.operations.check.CountCheck;
import org.eclipse.incquery.runtime.localsearch.operations.check.NACOperation;
import org.eclipse.incquery.runtime.localsearch.operations.extend.CountOperation;
import org.eclipse.incquery.runtime.localsearch.plan.SearchPlan;

public class SearchPlanExecutor {
    private int currentOperation;
    SearchPlan plan;
    private List<ISearchOperation> operations;
    private ISearchContext context;
    private Set<ILocalSearchAdapter> adapters = Sets.newHashSet();

    public int getCurrentOperation() {
        return this.currentOperation;
    }

    public SearchPlan getSearchPlan() {
        return this.plan;
    }

    public void addAdapters(List<ILocalSearchAdapter> adapter) {
        this.adapters.addAll(adapter);
    }

    public void removeAdapters(List<ILocalSearchAdapter> adapter) {
        this.adapters.removeAll(adapter);
    }

    public SearchPlanExecutor(SearchPlan plan, ISearchContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"Context cannot be null");
        this.plan = plan;
        this.context = context;
        this.operations = plan.getOperations();
        this.currentOperation = -1;
    }

    private void planStarted() {
        for (ILocalSearchAdapter adapter : this.adapters) {
            adapter.planStarted(this);
        }
    }

    private void planFinished() {
        for (ILocalSearchAdapter adapter : this.adapters) {
            adapter.planFinished(this);
        }
    }

    private void init(MatchingFrame frame) throws LocalSearchException {
        if (this.currentOperation == -1) {
            ++this.currentOperation;
            ISearchOperation operation = this.operations.get(this.currentOperation);
            operation.onInitialize(frame, this.context);
            this.addAdaptersWhenNeeded(operation);
        } else if (this.currentOperation == this.operations.size()) {
            --this.currentOperation;
        } else {
            throw new LocalSearchException("Error while executing search plan");
        }
        this.operationSelected(frame);
    }

    public double cost() {
        return 0.0;
    }

    public boolean execute(MatchingFrame frame) throws LocalSearchException {
        this.planStarted();
        int upperBound = this.operations.size() - 1;
        this.init(frame);
        while (this.currentOperation >= 0 && this.currentOperation <= upperBound) {
            ISearchOperation operation;
            if (this.operations.get(this.currentOperation).execute(frame, this.context)) {
                this.operationExecuted(frame);
                ++this.currentOperation;
                if (this.currentOperation <= upperBound) {
                    operation = this.operations.get(this.currentOperation);
                    operation.onInitialize(frame, this.context);
                    this.addAdaptersWhenNeeded(operation);
                }
            } else {
                this.operationExecuted(frame);
                operation = this.operations.get(this.currentOperation);
                operation.onBacktrack(frame, this.context);
                this.removeAdaptersWhenNeeded(operation);
                --this.currentOperation;
            }
            this.operationSelected(frame);
        }
        this.planFinished();
        return this.currentOperation > upperBound;
    }

    public void resetPlan() {
        this.currentOperation = -1;
    }

    public void printDebugInformation() {
        int i = 0;
        while (i < this.operations.size()) {
            Logger.getRootLogger().debug((Object)("[" + i + "]\t" + this.operations.get(i).toString()));
            ++i;
        }
    }

    private void addAdaptersWhenNeeded(ISearchOperation currentSearchOperation) {
        LocalSearchMatcher calledMatcher = this.getCalledMatcherOfSearchOperation(currentSearchOperation);
        if (calledMatcher != null) {
            for (ILocalSearchAdapter adapter : this.adapters) {
                calledMatcher.addAdapter(adapter);
            }
        }
    }

    private void removeAdaptersWhenNeeded(ISearchOperation currentSearchOperation) {
        LocalSearchMatcher calledMatcher = this.getCalledMatcherOfSearchOperation(currentSearchOperation);
        if (calledMatcher != null) {
            for (ILocalSearchAdapter adapter : this.adapters) {
                calledMatcher.removeAdapter(adapter);
            }
        }
    }

    private LocalSearchMatcher getCalledMatcherOfSearchOperation(ISearchOperation currentSearchOperation) {
        LocalSearchMatcher calledMatcher = null;
        if (currentSearchOperation instanceof NACOperation) {
            calledMatcher = ((NACOperation)currentSearchOperation).getCalledMatcher();
        } else if (currentSearchOperation instanceof BinaryTransitiveClosureCheck) {
            calledMatcher = ((BinaryTransitiveClosureCheck)currentSearchOperation).getCalledMatcher();
        } else if (currentSearchOperation instanceof CountOperation) {
            calledMatcher = ((CountOperation)currentSearchOperation).getCalledMatcher();
        } else if (currentSearchOperation instanceof CountCheck) {
            calledMatcher = ((CountCheck)currentSearchOperation).getCalledMatcher();
        }
        return calledMatcher;
    }

    private void operationExecuted(MatchingFrame frame) {
        for (ILocalSearchAdapter adapter : this.adapters) {
            adapter.operationExecuted(this, frame);
        }
    }

    private void operationSelected(MatchingFrame frame) {
        for (ILocalSearchAdapter adapter : this.adapters) {
            adapter.operationSelected(this, frame);
        }
    }
}

