/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.planner;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.incquery.runtime.localsearch.planner.ISearchPlanCodeGenerator;
import org.eclipse.incquery.runtime.localsearch.planner.LocalSearchPlannerStrategy;
import org.eclipse.incquery.runtime.localsearch.planner.POperationCompiler;
import org.eclipse.incquery.runtime.matchers.context.IPatternMatcherContext;
import org.eclipse.incquery.runtime.matchers.planning.IQueryPlannerStrategy;
import org.eclipse.incquery.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.incquery.runtime.matchers.planning.SubPlan;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PBodyNormalizer;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PQueryFlattener;

public class LocalSearchPlanner {
    private PDisjunction flatDisjunction;
    private PDisjunction normalizedDisjunction;
    private List<SubPlan> plansForBodies;
    private PQueryFlattener flattener;
    private IQueryPlannerStrategy plannerStrategy;
    private IPatternMatcherContext context;
    private PBodyNormalizer normalizer;
    private POperationCompiler operationCompiler;
    private ISearchPlanCodeGenerator codeGenerator;

    public PDisjunction getFlatDisjunction() {
        return this.flatDisjunction;
    }

    public PDisjunction getNormalizedDisjunction() {
        return this.normalizedDisjunction;
    }

    public List<SubPlan> getPlansForBodies() {
        return this.plansForBodies;
    }

    public void initializePlanner(PQueryFlattener pQueryFlattener, IPatternMatcherContext context, PBodyNormalizer pBodyNormalizer, IQueryPlannerStrategy localSearchPlannerStrategy, POperationCompiler pOperationCompiler) {
        this.initializePlanner(pQueryFlattener, context, pBodyNormalizer, localSearchPlannerStrategy, pOperationCompiler, null);
    }

    public void initializePlanner(PQueryFlattener pQueryFlattener, IPatternMatcherContext context, PBodyNormalizer pBodyNormalizer, IQueryPlannerStrategy localSearchPlannerStrategy, POperationCompiler pOperationCompiler, ISearchPlanCodeGenerator codeGenerator) {
        this.flattener = pQueryFlattener;
        this.context = context;
        this.normalizer = pBodyNormalizer;
        this.plannerStrategy = localSearchPlannerStrategy;
        this.operationCompiler = pOperationCompiler;
        this.codeGenerator = codeGenerator;
    }

    public List<List<ISearchOperation>> plan(PQuery querySpec, Set<Integer> boundVarIndices) throws QueryProcessingException {
        this.flatDisjunction = this.flattener.rewrite(querySpec.getDisjunctBodies());
        Set flatBodies = this.flatDisjunction.getBodies();
        this.prepareFlatBodesForNormalize(flatBodies);
        this.normalizedDisjunction = this.normalizer.rewrite(this.flatDisjunction);
        Set normalizedBodies = this.normalizedDisjunction.getBodies();
        this.plansForBodies = Lists.newArrayList();
        for (PBody normalizedBody : normalizedBodies) {
            this.preparePatternAdornmentForPlanner(boundVarIndices, normalizedBody);
            SubPlan plan = this.plannerStrategy.plan(normalizedBody, this.context);
            this.plansForBodies.add(plan);
        }
        ArrayList compiledSubPlans = Lists.newArrayList();
        for (SubPlan subPlan : this.plansForBodies) {
            compiledSubPlans.add(this.operationCompiler.compile(subPlan, boundVarIndices));
        }
        if (this.codeGenerator != null) {
            this.codeGenerator.compile(compiledSubPlans);
        }
        return compiledSubPlans;
    }

    private void prepareFlatBodesForNormalize(Set<PBody> flatBodies) {
        for (PBody pBody : flatBodies) {
            pBody.setStatus(PQuery.PQueryStatus.UNINITIALIZED);
        }
    }

    private void preparePatternAdornmentForPlanner(Set<Integer> boundVarIndices, PBody normalizedBody) {
        HashSet boundVariables = Sets.newHashSet();
        for (Integer i : boundVarIndices) {
            boundVariables.add((PVariable)normalizedBody.getSymbolicParameterVariables().get(i));
        }
        ((LocalSearchPlannerStrategy)this.plannerStrategy).setBoundVariables(boundVariables);
    }
}

