/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.incquery.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.incquery.runtime.localsearch.operations.check.BinaryTransitiveClosureCheck;
import org.eclipse.incquery.runtime.localsearch.operations.check.CheckConstant;
import org.eclipse.incquery.runtime.localsearch.operations.check.CountCheck;
import org.eclipse.incquery.runtime.localsearch.operations.check.ExpressionCheck;
import org.eclipse.incquery.runtime.localsearch.operations.check.InequalityCheck;
import org.eclipse.incquery.runtime.localsearch.operations.check.InstanceOfCheck;
import org.eclipse.incquery.runtime.localsearch.operations.check.NACOperation;
import org.eclipse.incquery.runtime.localsearch.operations.check.StructuralFeatureCheck;
import org.eclipse.incquery.runtime.localsearch.operations.extend.CountOperation;
import org.eclipse.incquery.runtime.localsearch.operations.extend.ExpressionEval;
import org.eclipse.incquery.runtime.localsearch.operations.extend.ExtendConstant;
import org.eclipse.incquery.runtime.localsearch.operations.extend.ExtendToEStructuralFeatureSource;
import org.eclipse.incquery.runtime.localsearch.operations.extend.ExtendToEStructuralFeatureTarget;
import org.eclipse.incquery.runtime.localsearch.operations.extend.IterateOverEClassInstances;
import org.eclipse.incquery.runtime.localsearch.planner.util.CompilerHelper;
import org.eclipse.incquery.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.incquery.runtime.matchers.planning.SubPlan;
import org.eclipse.incquery.runtime.matchers.planning.operations.PApply;
import org.eclipse.incquery.runtime.matchers.planning.operations.POperation;
import org.eclipse.incquery.runtime.matchers.planning.operations.PProject;
import org.eclipse.incquery.runtime.matchers.planning.operations.PStart;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExpressionEvaluation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.PatternMatchCounter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.BinaryTransitiveClosure;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeBinary;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeUnary;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;

public class POperationCompiler {
    private List<ISearchOperation> operations;
    private Set<MatcherReference> dependencies = Sets.newHashSet();
    private Map<PConstraint, Set<Integer>> variableBindings;

    public List<ISearchOperation> compile(SubPlan plan, Set<Integer> boundVariableIndexes) throws QueryProcessingException {
        Map<PVariable, Integer> variableMappings = CompilerHelper.createVariableMapping(plan);
        this.variableBindings = CompilerHelper.cacheVariableBindings(plan, variableMappings, boundVariableIndexes);
        this.operations = Lists.newArrayList();
        List<POperation> operationList = CompilerHelper.createOperationsList(plan);
        for (POperation pOperation : operationList) {
            this.compile(pOperation, variableMappings);
        }
        return this.operations;
    }

    private void compile(POperation pOperation, Map<PVariable, Integer> variableMapping) throws QueryProcessingException {
        if (pOperation instanceof PApply) {
            PApply pApply = (PApply)pOperation;
            PConstraint pConstraint = pApply.getPConstraint();
            Set affectedVariables = pConstraint.getAffectedVariables();
            HashSet varIndices = Sets.newHashSet();
            for (PVariable variable : affectedVariables) {
                varIndices.add(variableMapping.get(variable));
            }
            if (this.variableBindings.get(pConstraint).containsAll(varIndices)) {
                this.createCheckDispatcher(pConstraint, variableMapping);
            } else {
                this.createExtendDispatcher(pConstraint, variableMapping);
            }
        } else if (!(pOperation instanceof PStart) && !(pOperation instanceof PProject)) {
            throw new QueryProcessingException("PStart, PApply or PProject was expected, received: " + pOperation.getClass(), null, "Unexpected POperation type", null);
        }
    }

    private void createCheckDispatcher(PConstraint pConstraint, Map<PVariable, Integer> variableMapping) {
        if (pConstraint instanceof Inequality) {
            this.createCheck((Inequality)pConstraint, variableMapping);
        } else if (pConstraint instanceof NegativePatternCall) {
            this.createCheck((NegativePatternCall)pConstraint, variableMapping);
        } else if (pConstraint instanceof PatternMatchCounter) {
            this.createCheck((PatternMatchCounter)pConstraint, variableMapping);
        } else if (pConstraint instanceof ExpressionEvaluation) {
            this.createCheck((ExpressionEvaluation)pConstraint, variableMapping);
        } else {
            boolean cfr_ignored_0 = pConstraint instanceof ExportedParameter;
        }
        if (pConstraint instanceof BinaryTransitiveClosure) {
            this.createCheck((BinaryTransitiveClosure)pConstraint, variableMapping);
        } else if (pConstraint instanceof ConstantValue) {
            this.createCheck((ConstantValue)pConstraint, variableMapping);
        } else if (pConstraint instanceof PositivePatternCall) {
            this.createCheck((PositivePatternCall)pConstraint, variableMapping);
        } else if (pConstraint instanceof TypeBinary) {
            this.createCheck((TypeBinary)pConstraint, variableMapping);
        } else if (pConstraint instanceof TypeUnary) {
            this.createCheck((TypeUnary)pConstraint, variableMapping);
        }
    }

    private void createCheck(ConstantValue constant, Map<PVariable, Integer> variableMapping) {
        int position = variableMapping.get(constant.getVariablesTuple().get(0));
        this.operations.add(new CheckConstant(position, constant.getSupplierKey()));
    }

    private void createCheck(TypeUnary typeUnary, Map<PVariable, Integer> variableMapping) {
        this.operations.add(new InstanceOfCheck(variableMapping.get(typeUnary.getVariablesTuple().get(0)), (EClass)typeUnary.getSupplierKey()));
    }

    private void createCheck(TypeBinary typeBinary, Map<PVariable, Integer> variableMapping) {
        Preconditions.checkArgument((boolean)(typeBinary.getSupplierKey() instanceof EStructuralFeature), (Object)("Unsupported type: " + typeBinary.getSupplierKey()));
        int sourcePosition = variableMapping.get(typeBinary.getVariablesTuple().get(0));
        int targetPosition = variableMapping.get(typeBinary.getVariablesTuple().get(1));
        this.operations.add(new StructuralFeatureCheck(sourcePosition, targetPosition, (EStructuralFeature)typeBinary.getSupplierKey()));
    }

    private void createCheck(PositivePatternCall positivePatternCall, Map<PVariable, Integer> variableMapping) {
        throw new UnsupportedOperationException("Pattern call not supported");
    }

    private void createCheck(BinaryTransitiveClosure binaryTransitiveColsure, Map<PVariable, Integer> variableMapping) {
        int sourcePosition = variableMapping.get(binaryTransitiveColsure.getVariablesTuple().get(0));
        int targetPosition = variableMapping.get(binaryTransitiveColsure.getVariablesTuple().get(1));
        PQuery referredQuery = binaryTransitiveColsure.getReferredQuery();
        this.operations.add(new BinaryTransitiveClosureCheck(referredQuery, sourcePosition, targetPosition));
        ImmutableSet adornment = ImmutableSet.of((Object)0);
        this.dependencies.add(new MatcherReference(referredQuery, (Set<Integer>)adornment));
    }

    private void createCheck(ExpressionEvaluation expressionEvaluation, Map<PVariable, Integer> variableMapping) {
        this.createExtend(expressionEvaluation, variableMapping);
    }

    private void createCheck(PatternMatchCounter patternMatchCounter, Map<PVariable, Integer> variableMapping) {
        HashMap frameMapping = Maps.newHashMap();
        HashSet adornment = Sets.newHashSet();
        Set<Integer> bindings = this.variableBindings.get(patternMatchCounter);
        int keySize = patternMatchCounter.getActualParametersTuple().getSize();
        int i = 0;
        while (i < keySize) {
            PVariable parameter = (PVariable)patternMatchCounter.getActualParametersTuple().get(i);
            frameMapping.put(variableMapping.get(parameter), i);
            if (bindings.contains(variableMapping.get(parameter))) {
                adornment.add(i);
            }
            ++i;
        }
        PQuery referredQuery = patternMatchCounter.getReferredQuery();
        this.operations.add(new CountCheck(referredQuery, frameMapping, variableMapping.get(patternMatchCounter.getResultVariable())));
        this.dependencies.add(new MatcherReference(referredQuery, adornment));
    }

    private void createCheck(NegativePatternCall negativePatternCall, Map<PVariable, Integer> variableMapping) {
        this.createExtend(negativePatternCall, variableMapping);
    }

    private void createCheck(Inequality inequality, Map<PVariable, Integer> variableMapping) {
        this.operations.add(new InequalityCheck(variableMapping.get(inequality.getWho()), variableMapping.get(inequality.getWithWhom())));
    }

    private void createExtendDispatcher(PConstraint pConstraint, Map<PVariable, Integer> variableMapping) {
        if (pConstraint instanceof Inequality) {
            this.createExtend((Inequality)pConstraint, variableMapping);
        } else if (pConstraint instanceof NegativePatternCall) {
            this.createExtend((NegativePatternCall)pConstraint, variableMapping);
        } else if (pConstraint instanceof PatternMatchCounter) {
            this.createExtend((PatternMatchCounter)pConstraint, variableMapping);
        } else if (pConstraint instanceof ExpressionEvaluation) {
            this.createExtend((ExpressionEvaluation)pConstraint, variableMapping);
        } else if (pConstraint instanceof ExportedParameter) {
            this.createExtend((ExportedParameter)pConstraint, variableMapping);
        }
        if (pConstraint instanceof BinaryTransitiveClosure) {
            this.createExtend((BinaryTransitiveClosure)pConstraint, variableMapping);
        } else if (pConstraint instanceof ConstantValue) {
            this.createExtend((ConstantValue)pConstraint, variableMapping);
        } else if (pConstraint instanceof TypeBinary) {
            this.createExtend((TypeBinary)pConstraint, variableMapping);
        } else if (pConstraint instanceof TypeUnary) {
            this.createExtend((TypeUnary)pConstraint, variableMapping);
        }
    }

    private void createExtend(ConstantValue constant, Map<PVariable, Integer> variableMapping) {
        int position = variableMapping.get(constant.getVariablesTuple().get(0));
        this.operations.add(new ExtendConstant(position, constant.getSupplierKey()));
    }

    private void createExtend(TypeUnary pConstraint, Map<PVariable, Integer> variableMapping) {
        this.operations.add(new IterateOverEClassInstances(variableMapping.get(pConstraint.getVariableInTuple(0)), (EClass)pConstraint.getSupplierKey()));
    }

    private void createExtend(TypeBinary typeBinary, Map<PVariable, Integer> variableMapping) {
        Object supplierKey = typeBinary.getSupplierKey();
        PVariable from = (PVariable)typeBinary.getVariablesTuple().get(0);
        PVariable to = (PVariable)typeBinary.getVariablesTuple().get(1);
        boolean fromBound = this.variableBindings.get(typeBinary).contains(variableMapping.get(from));
        boolean toBound = this.variableBindings.get(typeBinary).contains(variableMapping.get(to));
        if (fromBound && !toBound) {
            this.operations.add(new ExtendToEStructuralFeatureTarget(variableMapping.get(from), variableMapping.get(to), (EStructuralFeature)supplierKey));
        } else if (!fromBound && toBound) {
            this.operations.add(new ExtendToEStructuralFeatureSource(variableMapping.get(from), variableMapping.get(to), (EStructuralFeature)supplierKey));
        } else {
            this.operations.add(new IterateOverEClassInstances(variableMapping.get(from), (EClass)typeBinary.getTypeInfo(from)));
            this.operations.add(new ExtendToEStructuralFeatureTarget(variableMapping.get(from), variableMapping.get(to), (EStructuralFeature)supplierKey));
        }
    }

    private void createExtend(BinaryTransitiveClosure binaryTransitiveClosure, Map<PVariable, Integer> variableMapping) {
        throw new UnsupportedOperationException("Binary transitive closures must be checks");
    }

    private void createExtend(ExportedParameter exportedParameter, Map<PVariable, Integer> variableMapping) {
    }

    private void createExtend(ExpressionEvaluation expressionEvaluation, Map<PVariable, Integer> variableMapping) {
        Iterable inputParameterNames = expressionEvaluation.getEvaluator().getInputParameterNames();
        HashMap nameMap = Maps.newHashMap();
        for (String pVariableName : inputParameterNames) {
            PVariable pVariable = expressionEvaluation.getPSystem().getVariableByNameChecked((Object)pVariableName);
            nameMap.put(pVariableName, variableMapping.get(pVariable));
        }
        if (expressionEvaluation.getOutputVariable() == null) {
            this.operations.add(new ExpressionCheck(expressionEvaluation.getEvaluator(), nameMap));
        } else {
            this.operations.add(new ExpressionEval(expressionEvaluation.getEvaluator(), nameMap, variableMapping.get(expressionEvaluation.getOutputVariable())));
        }
    }

    private void createExtend(PatternMatchCounter patternMatchCounter, Map<PVariable, Integer> variableMapping) {
        HashMap frameMapping = Maps.newHashMap();
        HashSet adornment = Sets.newHashSet();
        Set<Integer> bindings = this.variableBindings.get(patternMatchCounter);
        int keySize = patternMatchCounter.getActualParametersTuple().getSize();
        int i = 0;
        while (i < keySize) {
            PVariable parameter = (PVariable)patternMatchCounter.getActualParametersTuple().get(i);
            frameMapping.put(variableMapping.get(parameter), i);
            if (bindings.contains(variableMapping.get(parameter))) {
                adornment.add(i);
            }
            ++i;
        }
        PQuery referredQuery = patternMatchCounter.getReferredQuery();
        this.operations.add(new CountOperation(referredQuery, frameMapping, variableMapping.get(patternMatchCounter.getResultVariable())));
        this.dependencies.add(new MatcherReference(referredQuery, adornment));
    }

    private void createExtend(NegativePatternCall negativePatternCall, Map<PVariable, Integer> variableMapping) {
        HashMap frameMapping = Maps.newHashMap();
        int keySize = negativePatternCall.getActualParametersTuple().getSize();
        HashSet adornment = Sets.newHashSet();
        Set<Integer> bindings = this.variableBindings.get(negativePatternCall);
        int i = 0;
        while (i < keySize) {
            PVariable parameter = (PVariable)negativePatternCall.getActualParametersTuple().get(i);
            frameMapping.put(variableMapping.get(parameter), i);
            if (bindings.contains(variableMapping.get(parameter))) {
                adornment.add(i);
            }
            ++i;
        }
        PQuery referredQuery = negativePatternCall.getReferredQuery();
        this.operations.add(new NACOperation(referredQuery, frameMapping));
        this.dependencies.add(new MatcherReference(referredQuery, adornment));
    }

    private void createExtend(Inequality pConstraint, Map<PVariable, Integer> variableMapping) {
        throw new UnsupportedOperationException("Unsafe operation. Requires iteration over the entire domain");
    }

    public Set<MatcherReference> getDependencies() {
        return this.dependencies;
    }
}

