/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.matcher;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.runtime.api.scope.IBaseIndex;
import org.eclipse.incquery.runtime.base.api.IncQueryBaseFactory;
import org.eclipse.incquery.runtime.base.api.NavigationHelper;
import org.eclipse.incquery.runtime.base.exception.IncQueryBaseException;
import org.eclipse.incquery.runtime.emf.EMFBaseIndexWrapper;
import org.eclipse.incquery.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.incquery.runtime.localsearch.matcher.MatcherReference;

public interface ISearchContext {
    public NavigationHelper getBaseIndex();

    public void registerObservedTypes(Set<EClass> var1, Set<EDataType> var2, Set<EStructuralFeature> var3);

    public void loadMatcher(MatcherReference var1, LocalSearchMatcher var2);

    public LocalSearchMatcher getMatcher(MatcherReference var1);

    public static class SearchContext
    implements ISearchContext {
        final NavigationHelper navigationHelper;
        final Logger logger = Logger.getLogger(this.getClass());
        Map<MatcherReference, LocalSearchMatcher> knownMatchers = Maps.newHashMap();

        public SearchContext(IBaseIndex baseIndex) {
            this.navigationHelper = ((EMFBaseIndexWrapper)baseIndex).getNavigationHelper();
        }

        public SearchContext(ResourceSet set, Set<EClass> classes, Set<EDataType> dataTypes, Set<EStructuralFeature> features) throws IncQueryBaseException {
            this.navigationHelper = IncQueryBaseFactory.getInstance().createNavigationHelper((Notifier)set, false, this.logger);
            this.navigationHelper.registerObservedTypes(classes, dataTypes, features);
        }

        public SearchContext(IBaseIndex baseIndex, Set<EClass> classes, Set<EDataType> dataTypes, Set<EStructuralFeature> features) {
            this.navigationHelper = ((EMFBaseIndexWrapper)baseIndex).getNavigationHelper();
            this.navigationHelper.registerObservedTypes(classes, dataTypes, features);
        }

        @Override
        public void registerObservedTypes(Set<EClass> classes, Set<EDataType> dataTypes, Set<EStructuralFeature> features) {
            this.navigationHelper.registerObservedTypes(classes, dataTypes, features);
        }

        @Override
        public NavigationHelper getBaseIndex() {
            return this.navigationHelper;
        }

        @Override
        public void loadMatcher(MatcherReference reference, LocalSearchMatcher matcher) {
            this.knownMatchers.put(reference, matcher);
        }

        @Override
        public LocalSearchMatcher getMatcher(MatcherReference reference) {
            if (!this.knownMatchers.containsKey(reference)) {
                throw new UnsupportedOperationException(String.format("No matcher for query %s initialized.", reference.getQuery().getFullyQualifiedName()));
            }
            return this.knownMatchers.get(reference);
        }
    }
}

