/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.incquery.runtime.localsearch.planner.cost.EvaluablePConstraint;
import org.eclipse.incquery.runtime.localsearch.planner.util.OrderingHeuristics;
import org.eclipse.incquery.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.incquery.runtime.matchers.planning.IQueryPlannerStrategy;
import org.eclipse.incquery.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.incquery.runtime.matchers.planning.SubPlan;
import org.eclipse.incquery.runtime.matchers.planning.SubPlanFactory;
import org.eclipse.incquery.runtime.matchers.planning.operations.PApply;
import org.eclipse.incquery.runtime.matchers.planning.operations.POperation;
import org.eclipse.incquery.runtime.matchers.planning.operations.PProject;
import org.eclipse.incquery.runtime.matchers.planning.operations.PStart;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;

public class LocalSearchPlannerStrategy
implements IQueryPlannerStrategy {
    private Set<PVariable> initialBoundVariables = Collections.emptySet();

    public void setBoundVariables(Set<PVariable> initialBoundVariables) {
        this.initialBoundVariables = ImmutableSet.copyOf(initialBoundVariables);
    }

    public SubPlan plan(PBody pBody, Logger logger, IQueryMetaContext context) throws QueryProcessingException {
        SubPlanFactory subPlanFactory = new SubPlanFactory(pBody);
        SubPlan plan = subPlanFactory.createSubPlan((POperation)new PStart(this.initialBoundVariables), new SubPlan[0]);
        Set constraintSet = pBody.getConstraints();
        while (!constraintSet.isEmpty()) {
            PConstraint pConstraint = this.selectNextPConstraint(pBody, plan, constraintSet, context);
            plan = subPlanFactory.createSubPlan((POperation)new PApply(pConstraint), new SubPlan[]{plan});
        }
        return subPlanFactory.createSubPlan((POperation)new PProject(pBody.getSymbolicParameterVariables()), new SubPlan[]{plan});
    }

    private PConstraint selectNextPConstraint(PBody pBody, SubPlan plan, Set<PConstraint> constraintSet, IQueryMetaContext context) {
        PConstraint pConstraint = null;
        if (plan.getOperation() instanceof PStart) {
            List parameterVariables = pBody.getSymbolicParameterVariables();
            for (PVariable pVariable : parameterVariables) {
                Set referringPConstraints = pVariable.getReferringConstraints();
                for (PConstraint referringPConstraint : referringPConstraints) {
                    if (!constraintSet.contains(referringPConstraint) || !(referringPConstraint instanceof TypeConstraint) || referringPConstraint.getAffectedVariables().size() != 1) continue;
                    pConstraint = referringPConstraint;
                }
            }
        }
        if (pConstraint == null) {
            pConstraint = Collections.min(Collections2.filter(constraintSet, (Predicate)new EvaluablePConstraint(plan)), new OrderingHeuristics(plan, context));
        }
        constraintSet.remove(pConstraint);
        return pConstraint;
    }

    protected EClassifier extractClassifierLiteral(String packageUriAndClassifierName) {
        int lastSlashPosition = packageUriAndClassifierName.lastIndexOf(47);
        int scopingPosition = packageUriAndClassifierName.lastIndexOf("::");
        String packageUri = packageUriAndClassifierName.substring(scopingPosition + 2, lastSlashPosition);
        String classifierName = packageUriAndClassifierName.substring(lastSlashPosition + 1);
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(packageUri);
        Preconditions.checkState((ePackage != null ? 1 : 0) != 0, (String)"EPackage %s not found in EPackage Registry.", (Object[])new Object[]{packageUri});
        EClassifier literal = ePackage.getEClassifier(classifierName);
        Preconditions.checkState((literal != null ? 1 : 0) != 0, (String)"Classifier %s not found in EPackage %s", (Object[])new Object[]{classifierName, packageUri});
        return literal;
    }
}

