/**
 * Copyright (c) 2010-2015, Grill Bal�zs, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Grill Bal�zs - initial API and implementation
 */
package org.eclipse.incquery.testing.core.api;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQueryGroup;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.extensibility.QuerySpecificationRegistry;
import org.eclipse.incquery.runtime.matchers.backend.IQueryBackend;
import org.eclipse.incquery.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.incquery.testing.core.EIQTestCase;
import org.eclipse.incquery.testing.core.PatternBasedMatchSetModelProvider;
import org.eclipse.incquery.testing.core.SnapshotMatchSetModelProvider;
import org.eclipse.incquery.testing.core.XmiModelUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * This class defines an API to easily construct test cases. The base conception is to provide
 * a set of match set sources (from a snapshot or from the execution of a pattern) and make assertions
 * on them being equal.
 */
@SuppressWarnings("all")
public class EIQTest {
  private final EIQTestCase testCase;
  
  /**
   * Test the specified query
   */
  public static <Match extends IPatternMatch> EIQTest test(final IQuerySpecification<? extends IncQueryMatcher<Match>> pattern) {
    EIQTest _eIQTest = new EIQTest();
    return _eIQTest.and(pattern);
  }
  
  public static EIQTest test(final IQueryGroup patterns) {
    EIQTest _eIQTest = new EIQTest();
    return _eIQTest.and(patterns);
  }
  
  public static EIQTest test() {
    return new EIQTest();
  }
  
  /**
   * Test the specified query
   */
  public static <Match extends IPatternMatch> EIQTest test(final String pattern) {
    return EIQTest.test();
  }
  
  public EIQTest and(final IQueryGroup patterns) {
    EIQTest _xblockexpression = null;
    {
      Set<IQuerySpecification<?>> _specifications = patterns.getSpecifications();
      final Procedure1<IQuerySpecification<?>> _function = new Procedure1<IQuerySpecification<?>>() {
        @Override
        public void apply(final IQuerySpecification<?> it) {
          EIQTest.this.patterns.add(((IQuerySpecification<IncQueryMatcher<IPatternMatch>>) it));
        }
      };
      IterableExtensions.<IQuerySpecification<?>>forEach(_specifications, _function);
      _xblockexpression = this;
    }
    return _xblockexpression;
  }
  
  public EIQTest and(final IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> pattern) {
    EIQTest _xblockexpression = null;
    {
      this.patterns.add(pattern);
      _xblockexpression = this;
    }
    return _xblockexpression;
  }
  
  public EIQTest and(final String pattern) {
    IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> _querySpecification = QuerySpecificationRegistry.getQuerySpecification(pattern);
    return this.and(
      ((IQuerySpecification<IncQueryMatcher<IPatternMatch>>) _querySpecification));
  }
  
  private final List<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> patterns = new LinkedList<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>>();
  
  private EIQTest() {
    EIQTestCase _eIQTestCase = new EIQTestCase();
    this.testCase = _eIQTestCase;
  }
  
  private EIQTest(final IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> pattern) {
    this();
    this.patterns.add(pattern);
  }
  
  /**
   * Add match result set with a query initialized using the given hints
   */
  public EIQTest with(final QueryEvaluationHint hint) {
    EIQTest _xblockexpression = null;
    {
      final PatternBasedMatchSetModelProvider modelProvider = new PatternBasedMatchSetModelProvider(hint);
      this.testCase.addMatchSetModelProvider(modelProvider);
      _xblockexpression = this;
    }
    return _xblockexpression;
  }
  
  /**
   * Add match result set with a query initialized using the given query backend
   */
  public EIQTest with(final Class<? extends IQueryBackend> queryBackendClass) {
    EIQTest _xblockexpression = null;
    {
      Map<String, Object> _emptyMap = CollectionLiterals.<String, Object>emptyMap();
      final QueryEvaluationHint hint = new QueryEvaluationHint(queryBackendClass, _emptyMap);
      _xblockexpression = this.with(hint);
    }
    return _xblockexpression;
  }
  
  /**
   * Add match result set loaded from the given snapshot
   */
  public EIQTest with(final URI snapshotURI) {
    EIQTest _xblockexpression = null;
    {
      SnapshotMatchSetModelProvider _snapshotMatchSetModelProvider = new SnapshotMatchSetModelProvider(snapshotURI);
      this.testCase.addMatchSetModelProvider(_snapshotMatchSetModelProvider);
      _xblockexpression = this;
    }
    return _xblockexpression;
  }
  
  /**
   * Add match result set loaded from the given snapshot
   */
  public EIQTest with(final String snapshotURI) {
    URI _resolvePlatformURI = XmiModelUtil.resolvePlatformURI(XmiModelUtil.XmiModelUtilRunningOptionEnum.BOTH, snapshotURI);
    return this.with(_resolvePlatformURI);
  }
  
  /**
   * Load input model
   */
  public EIQTest on(final URI inputURI) {
    EIQTest _xblockexpression = null;
    {
      this.testCase.loadModel(inputURI);
      _xblockexpression = this;
    }
    return _xblockexpression;
  }
  
  /**
   * Execute all queries and check that the result sets are equal
   */
  public void assertEquals() {
    final Procedure1<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> _function = new Procedure1<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>>() {
      @Override
      public void apply(final IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> it) {
        EIQTest.this.testCase.<IPatternMatch>assertMatchSetsEqual(((IQuerySpecification<IncQueryMatcher<IPatternMatch>>) it));
      }
    };
    IterableExtensions.<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>>forEach(this.patterns, _function);
  }
}
