/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.retevis.views;

import java.util.Map;
import org.eclipse.gef4.zest.core.viewers.IConnectionStyleProvider;
import org.eclipse.gef4.zest.core.viewers.IEntityStyleProvider;
import org.eclipse.incquery.runtime.matchers.psystem.queries.BasePQuery;
import org.eclipse.incquery.runtime.rete.index.IndexerWithMemory;
import org.eclipse.incquery.runtime.rete.index.IterableIndexer;
import org.eclipse.incquery.runtime.rete.network.Node;
import org.eclipse.incquery.runtime.rete.recipes.ProductionRecipe;
import org.eclipse.incquery.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.incquery.runtime.rete.single.UniquenessEnforcerNode;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.incquery.viewers.runtime.zest.sources.ZestLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ReteVisualizationLabelProvider
extends ZestLabelProvider
implements IEntityStyleProvider,
IConnectionStyleProvider {
    private final Map<ReteNodeRecipe, Node> nodeTrace;

    public ReteVisualizationLabelProvider(ViewerState state, Map<ReteNodeRecipe, Node> nodeTrace, Display display) {
        super(state, display);
        this.nodeTrace = nodeTrace;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        StringBuffer text = new StringBuffer(super.getText(element));
        if (element instanceof Item) {
            ProductionRecipe productionRecipe;
            Object pattern;
            Item item = (Item)element;
            Object paramObject = item.getParamObject();
            if (paramObject instanceof ProductionRecipe && (pattern = (productionRecipe = (ProductionRecipe)paramObject).getPattern()) instanceof BasePQuery) {
                BasePQuery pQuery = (BasePQuery)pattern;
                text.append(": ");
                text.append(pQuery.getFullyQualifiedName());
            }
            if (paramObject instanceof ReteNodeRecipe) {
                ReteNodeRecipe recipe = (ReteNodeRecipe)paramObject;
                Node node = this.nodeTrace.get(recipe);
                if (node instanceof UniquenessEnforcerNode) {
                    UniquenessEnforcerNode uniquenessEnforcerNode = (UniquenessEnforcerNode)node;
                    text.append(ReteVisualizationLabelProvider.formatSize(uniquenessEnforcerNode.getMemory().size()));
                } else if (node instanceof IndexerWithMemory) {
                    IndexerWithMemory indexerWithMemory = (IndexerWithMemory)node;
                    text.append(ReteVisualizationLabelProvider.formatSize(indexerWithMemory.getMemory().getKeysetSize()));
                } else if (node instanceof IterableIndexer) {
                    IterableIndexer iterableIndexer = (IterableIndexer)node;
                    text.append(ReteVisualizationLabelProvider.formatSize(iterableIndexer.getSignatures().size()));
                }
            }
        }
        return text.toString();
    }

    private static String formatSize(int size) {
        return " [" + size + "]";
    }
}

