/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.retevis.views;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef4.layout.LayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.TreeLayoutAlgorithm;
import org.eclipse.gef4.zest.core.viewers.GraphViewer;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.backend.IQueryBackend;
import org.eclipse.incquery.runtime.rete.matcher.ReteEngine;
import org.eclipse.incquery.runtime.rete.network.Node;
import org.eclipse.incquery.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.incquery.runtime.rete.traceability.ActiveNodeConflictTrace;
import org.eclipse.incquery.runtime.rete.traceability.PatternTraceInfo;
import org.eclipse.incquery.runtime.rete.traceability.RecipeTraceInfo;
import org.eclipse.incquery.runtime.rete.traceability.TraceInfo;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.PatternMatcherContent;
import org.eclipse.incquery.tooling.ui.retevis.views.ReteVisualizationLabelProvider;
import org.eclipse.incquery.viewers.runtime.extensions.ViewersComponentConfiguration;
import org.eclipse.incquery.viewers.runtime.model.IncQueryViewerDataModel;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.incquery.viewers.runtime.zest.extensions.IncQueryViewersZestViewSupport;
import org.eclipse.incquery.viewers.runtime.zest.sources.ZestContentWithIsolatedNodesProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ui.IViewPart;

public class ReteVisualizationViewSupport
extends IncQueryViewersZestViewSupport {
    private Map<ReteNodeRecipe, Node> nodeTrace;

    public ReteVisualizationViewSupport(IViewPart _owner, ViewersComponentConfiguration _config, GraphViewer _graphViewer) {
        super(_owner, _config, IModelConnectorTypeEnum.RESOURCESET, _graphViewer);
    }

    protected void init() {
        super.init();
        this.getGraphViewer().setLayoutAlgorithm((LayoutAlgorithm)new TreeLayoutAlgorithm());
    }

    protected Notifier extractModelSource(List<Object> objects) {
        this.nodeTrace = this.computeNodeTrace(objects);
        return this.createRecipeModel(this.nodeTrace);
    }

    private Map<ReteNodeRecipe, Node> computeNodeTrace(List<Object> objects) {
        HashMap nodeTrace = Maps.newHashMap();
        for (Object object : objects) {
            if (!(object instanceof PatternMatcherContent)) continue;
            PatternMatcherContent patternMatcherContent = (PatternMatcherContent)object;
            try {
                IQueryBackend reteEngine = ((AdvancedIncQueryEngine)patternMatcherContent.getMatcher().getEngine()).getQueryBackend(ReteEngine.class);
                Collection allNodes = ((ReteEngine)reteEngine).getReteNet().getHeadContainer().getAllNodes();
                for (Node node : allNodes) {
                    for (TraceInfo traceInfo : node.getTraceInfos()) {
                        if (!(traceInfo instanceof RecipeTraceInfo)) continue;
                        RecipeTraceInfo recipeTraceInfo = (RecipeTraceInfo)traceInfo;
                        if (!patternMatcherContent.getPatternName().equals(this.getPatternName(recipeTraceInfo))) continue;
                        ReteNodeRecipe recipe = recipeTraceInfo.getRecipe();
                        nodeTrace.put(recipe, node);
                    }
                }
            }
            catch (IncQueryException e) {
                throw new RuntimeException("Failed to get query backend", e);
            }
        }
        return nodeTrace;
    }

    private String getPatternName(RecipeTraceInfo recipeTraceInfo) {
        if (recipeTraceInfo instanceof PatternTraceInfo) {
            PatternTraceInfo patternTraceInfo = (PatternTraceInfo)recipeTraceInfo;
            return patternTraceInfo.getPatternName();
        }
        if (recipeTraceInfo instanceof ActiveNodeConflictTrace) {
            ActiveNodeConflictTrace activeNodeConflictTrace = (ActiveNodeConflictTrace)recipeTraceInfo;
            return this.getPatternName(activeNodeConflictTrace.getInactiveRecipeTrace());
        }
        return null;
    }

    private Notifier createRecipeModel(Map<ReteNodeRecipe, Node> nodeTrace) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)"temp"));
        for (ReteNodeRecipe recipe : nodeTrace.keySet()) {
            EObject rootContainer = EcoreUtil.getRootContainer((EObject)recipe);
            resource.getContents().add((Object)rootContainer);
        }
        return resourceSet;
    }

    protected void bindModel() {
        IncQueryEngine engine;
        Assert.isNotNull((Object)this.configuration);
        Assert.isNotNull((Object)this.configuration.getPatterns());
        if (this.state != null && !this.state.isDisposed()) {
            this.state.dispose();
        }
        if ((engine = this.getEngine()) != null) {
            this.state = IncQueryViewerDataModel.newViewerState((IncQueryEngine)engine, (Collection)this.configuration.getPatterns(), (ViewerDataFilter)this.configuration.getFilter(), (Collection)ImmutableSet.of((Object)ViewerState.ViewerStateFeature.EDGE, (Object)ViewerState.ViewerStateFeature.CONTAINMENT));
            GraphViewer viewer = (GraphViewer)this.jfaceViewer;
            viewer.setContentProvider((IContentProvider)new ZestContentWithIsolatedNodesProvider());
            viewer.setLabelProvider((IBaseLabelProvider)new ReteVisualizationLabelProvider(this.state, this.nodeTrace, viewer.getControl().getDisplay()));
            viewer.setInput((Object)this.state);
        }
    }
}

