/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.dialog;

import java.util.Collection;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.tooling.ui.dialog.PatternMatchDialogContentProvider;
import org.eclipse.incquery.tooling.ui.dialog.PatternMatchDialogLabelProvider;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.DisplayUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class SampleUIDialogCreator {
    public static final Dialog createDialog(IncQueryMatcher<? extends IPatternMatch> matcher) {
        String patternFqn = matcher.getPatternName();
        Collection matches = matcher.getAllMatches();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new PatternMatchDialogLabelProvider(), (ITreeContentProvider)new PatternMatchDialogContentProvider(matcher, matches));
        dialog.setTitle(String.format("Matchset of the pattern %s", patternFqn));
        dialog.setMessage(DisplayUtil.getMessage(matcher, matches.size(), patternFqn, null));
        dialog.setEmptyListMessage("No matches!");
        dialog.setAllowMultiple(false);
        dialog.setDoubleClickSelects(false);
        dialog.setInput(matcher);
        return dialog;
    }
}

