/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.incquery.runtime.extensibility.QueryBackendRegistry;
import org.eclipse.incquery.runtime.matchers.backend.IQueryBackend;
import org.eclipse.incquery.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.incquery.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.DisplayUtil;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class BackendSelectionControl
extends WorkbenchWindowControlContribution {
    public BackendSelectionControl() {
    }

    public BackendSelectionControl(String id) {
        super(id);
    }

    private QueryExplorer getQueryExplorer() {
        return QueryExplorer.getInstance(this.getWorkbenchWindow());
    }

    private void applyBackendSelection(Class<? extends IQueryBackend> backend) {
        QueryEvaluationHint oldHint = this.getQueryExplorer().getHints();
        QueryEvaluationHint newHint = new QueryEvaluationHint(backend, oldHint.getBackendHints());
        this.getQueryExplorer().setHints(newHint);
    }

    private static Collection<Class<? extends IQueryBackend>> getRegisteredQueryBackendImplementations() {
        LinkedList<Class<? extends IQueryBackend>> result = new LinkedList<Class<? extends IQueryBackend>>();
        for (Map.Entry entry : QueryBackendRegistry.getInstance().getAllKnownFactories()) {
            result.add((Class)entry.getKey());
        }
        return result;
    }

    protected Control createControl(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 2056);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Class) {
                    return DisplayUtil.getQueryBackendName((Class)element);
                }
                return super.getText(element);
            }
        });
        viewer.setInput((Object)BackendSelectionControl.getRegisteredQueryBackendImplementations().toArray());
        viewer.setSelection((ISelection)new StructuredSelection((Object)this.getQueryExplorer().getHints().getQueryBackendClass()));
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection;
                Object o;
                ISelection select = event.getSelection();
                if (select instanceof IStructuredSelection && (o = (selection = (IStructuredSelection)select).getFirstElement()) instanceof Class) {
                    BackendSelectionControl.this.applyBackendSelection((Class)o);
                }
            }
        });
        viewer.getControl().setToolTipText("Select query backend engine to be used on subsequent loads.");
        return viewer.getControl();
    }
}

