/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.CompositeContent;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ContentChildren;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.PatternMatcherRootContent;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.PatternMatcherRootContentKey;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorPart;

public class RootContent
extends CompositeContent<Object, PatternMatcherRootContent> {
    private Map<PatternMatcherRootContentKey, PatternMatcherRootContent> mapping;
    private ContentChildren<PatternMatcherRootContent> children = new ContentChildren();
    private TreeViewer viewer;

    public RootContent() {
        super(null);
        this.mapping = new HashMap<PatternMatcherRootContentKey, PatternMatcherRootContent>();
    }

    public void addPatternMatcherRoot(IEditorPart editorPart, Notifier notifier, QueryEvaluationHint hint) {
        PatternMatcherRootContentKey key = new PatternMatcherRootContentKey(editorPart, notifier);
        this.addPatternMatcherRoot(key, hint);
    }

    public void addPatternMatcherRoot(PatternMatcherRootContentKey key, QueryEvaluationHint hint) {
        if (!this.mapping.containsKey(key)) {
            PatternMatcherRootContent root = new PatternMatcherRootContent(this, key);
            List<IQuerySpecification<?>> activePatterns = QueryExplorerPatternRegistry.getInstance().getActivePatterns();
            root.registerPattern(hint, activePatterns.toArray(new IQuerySpecification[activePatterns.size()]));
            this.mapping.put(key, root);
            this.children.addChild(root);
            this.viewer.setExpandedState((Object)root, true);
        }
    }

    public void removePatternMatcherRoot(IEditorPart editorPart, ResourceSet res) {
        PatternMatcherRootContentKey key = new PatternMatcherRootContentKey(editorPart, (Notifier)res);
        this.removePatternMatcherRoot(key);
    }

    public void removePatternMatcherRoot(PatternMatcherRootContentKey key) {
        if (this.mapping.containsKey(key)) {
            PatternMatcherRootContent root = this.mapping.get(key);
            root.dispose();
            this.children.removeChild(root);
            if (!root.getChildren().isDisposed()) {
                root.getChildren().dispose();
            }
            this.mapping.remove(key);
        }
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public IObservableList getChildren() {
        return this.children;
    }

    @Override
    public Iterator<PatternMatcherRootContent> getChildrenIterator() {
        return this.children.getElements().iterator();
    }

    public void setViewer(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }
}

