/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.PatternMatcherRootContentKey;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class ResetUIHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        QueryExplorer queryExplorer = QueryExplorer.getInstance(activeWorkbenchWindow);
        QueryExplorerPatternRegistry patternRegistry = QueryExplorerPatternRegistry.getInstance();
        if (queryExplorer != null) {
            for (PatternMatcherRootContentKey patternMatcherRootContentKey : queryExplorer.getPatternMatcherRootContentKeys()) {
                queryExplorer.unload(patternMatcherRootContentKey);
            }
            for (IQuerySpecification iQuerySpecification : patternRegistry.getActivePatterns()) {
                if (patternRegistry.isGenerated(iQuerySpecification)) continue;
                patternRegistry.unregisterPattern(iQuerySpecification);
                patternRegistry.removeActivePattern(iQuerySpecification);
            }
            queryExplorer.getPatternsViewerRoot().getGeneratedPatternsRoot().setCheckedState(true);
            queryExplorer.getPatternsViewerRoot().getGenericPatternsRoot().clear();
            queryExplorer.getPatternsViewerRoot().getGenericPatternsRoot().setCheckedState(false);
            queryExplorer.getPatternsViewer().refresh();
        }
        return null;
    }
}

