package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.StateIsCompositeMatch;
import org.eclipse.incquery.uml.derivedfeatures.StateIsCompositeMatcher;
import org.eclipse.incquery.uml.derivedfeatures.util.StateIsComposite_0QuerySpecification;

/**
 * A pattern-specific query specification that can instantiate StateIsCompositeMatcher in a type-safe way.
 * 
 * @see StateIsCompositeMatcher
 * @see StateIsCompositeMatch
 * 
 */
@SuppressWarnings("all")
public final class StateIsCompositeQuerySpecification extends BaseGeneratedEMFQuerySpecification<StateIsCompositeMatcher> {
  private StateIsCompositeQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static StateIsCompositeQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected StateIsCompositeMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return StateIsCompositeMatcher.on(engine);
  }
  
  @Override
  public StateIsCompositeMatch newEmptyMatch() {
    return StateIsCompositeMatch.newEmptyMatch();
  }
  
  @Override
  public StateIsCompositeMatch newMatch(final Object... parameters) {
    return StateIsCompositeMatch.newMatch((org.eclipse.uml2.uml.State) parameters[0], (java.lang.Boolean) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static StateIsCompositeQuerySpecification INSTANCE = make();
    
    public static StateIsCompositeQuerySpecification make() {
      return new StateIsCompositeQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static StateIsCompositeQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.stateIsComposite";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("self","isComposite");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("self", "org.eclipse.uml2.uml.State"),new PParameter("isComposite", "java.lang.Boolean"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_self = body.getOrCreateVariableByName("self");
      	PVariable var_isComposite = body.getOrCreateVariableByName("isComposite");
      	PVariable var__region = body.getOrCreateVariableByName("_region");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_self, "self"),
      				
      		new ExportedParameter(body, var_isComposite, "isComposite")
      	));
      	new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "State")));
      	new PositivePatternCall(body, new FlatTuple(var_self, var__region), StateIsComposite_0QuerySpecification.instance().getInternalQueryRepresentation());
      	new ConstantValue(body, var__virtual_0_, true);
      	new Equality(body, var_isComposite, var__virtual_0_);
      	bodies.add(body);
      }
      {
      	PBody body = new PBody(this);
      	PVariable var_self = body.getOrCreateVariableByName("self");
      	PVariable var_isComposite = body.getOrCreateVariableByName("isComposite");
      	PVariable var__region = body.getOrCreateVariableByName("_region");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_self, "self"),
      				
      		new ExportedParameter(body, var_isComposite, "isComposite")
      	));
      	new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "State")));
      	new NegativePatternCall(body, new FlatTuple(var_self, var__region), StateIsComposite_0QuerySpecification.instance().getInternalQueryRepresentation());
      	new ConstantValue(body, var__virtual_0_, false);
      	new Equality(body, var_isComposite, var__virtual_0_);
      	bodies.add(body);
      }
      	{
      	PAnnotation annotation = new PAnnotation("Surrogate");
      	annotation.addAttribute("feature", "isComposite");
      	addAnnotation(annotation);
      }
      {
      	PAnnotation annotation = new PAnnotation("QueryExplorer");
      	annotation.addAttribute("checked", false);
      	addAnnotation(annotation);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
