package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.uml.derivedfeatures.MessageMessageKindMatch;
import org.eclipse.incquery.uml.derivedfeatures.util.MessageMessageKindQuerySpecification;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageKind;

/**
 * Generated pattern matcher API of the org.eclipse.incquery.uml.derivedfeatures.messageMessageKind pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(IncQueryEngine)},
 * e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link MessageMessageKindMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * MessageOperations.getMessageKind
 * 
 * {@literal @}Surrogate(feature = "messageKind")
 * {@literal @}QueryExplorer(checked = false)
 * pattern messageMessageKind(self: Message, messageKind: MessageKind) {
 *     neg find messageSendEvent(self, _);
 *     neg find messageReceiveEvent(self, _);
 *     messageKind == MessageKind::unknown;
 * } or {
 *     neg find messageSendEvent(self, _);
 *     find messageReceiveEvent(self, _);
 *     messageKind == MessageKind::found;
 * } or {
 *     find messageSendEvent(self, _);
 *     neg find messageReceiveEvent(self, _);
 *     messageKind == MessageKind::lost;
 * } or {
 *     find messageSendEvent(self, _);
 *     find messageReceiveEvent(self, _);
 *     messageKind == MessageKind::complete;
 * }
 * </pre></code>
 * 
 * @see MessageMessageKindMatch
 * @see MessageMessageKindProcessor
 * @see MessageMessageKindQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class MessageMessageKindMatcher extends BaseMatcher<MessageMessageKindMatch> {
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static MessageMessageKindMatcher on(final IncQueryEngine engine) throws IncQueryException {
    // check if matcher already exists
    MessageMessageKindMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = new MessageMessageKindMatcher(engine);
    	// do not have to "put" it into engine.matchers, reportMatcherInitialized() will take care of it
    }
    return matcher;
  }
  
  private final static int POSITION_SELF = 0;
  
  private final static int POSITION_MESSAGEKIND = 1;
  
  private final static Logger LOGGER = IncQueryLoggingUtil.getLogger(MessageMessageKindMatcher.class);
  
  /**
   * Initializes the pattern matcher over a given EMF model root (recommended: Resource or ResourceSet).
   * If a pattern matcher is already constructed with the same root, only a light-weight reference is returned.
   * The scope of pattern matching will be the given EMF model root and below (see FAQ for more precise definition).
   * The match set will be incrementally refreshed upon updates from this scope.
   * <p>The matcher will be created within the managed {@link IncQueryEngine} belonging to the EMF model root, so
   * multiple matchers will reuse the same engine and benefit from increased performance and reduced memory footprint.
   * @param emfRoot the root of the EMF containment hierarchy where the pattern matcher will operate. Recommended: Resource or ResourceSet.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead, e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}
   * 
   */
  @Deprecated
  public MessageMessageKindMatcher(final Notifier emfRoot) throws IncQueryException {
    this(IncQueryEngine.on(emfRoot));
  }
  
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead
   * 
   */
  @Deprecated
  public MessageMessageKindMatcher(final IncQueryEngine engine) throws IncQueryException {
    super(engine, querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pMessageKind the fixed value of pattern parameter messageKind, or null if not bound.
   * @return matches represented as a MessageMessageKindMatch object.
   * 
   */
  public Collection<MessageMessageKindMatch> getAllMatches(final Message pSelf, final MessageKind pMessageKind) {
    return rawGetAllMatches(new Object[]{pSelf, pMessageKind});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pMessageKind the fixed value of pattern parameter messageKind, or null if not bound.
   * @return a match represented as a MessageMessageKindMatch object, or null if no match is found.
   * 
   */
  public MessageMessageKindMatch getOneArbitraryMatch(final Message pSelf, final MessageKind pMessageKind) {
    return rawGetOneArbitraryMatch(new Object[]{pSelf, pMessageKind});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pMessageKind the fixed value of pattern parameter messageKind, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final Message pSelf, final MessageKind pMessageKind) {
    return rawHasMatch(new Object[]{pSelf, pMessageKind});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pMessageKind the fixed value of pattern parameter messageKind, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final Message pSelf, final MessageKind pMessageKind) {
    return rawCountMatches(new Object[]{pSelf, pMessageKind});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pMessageKind the fixed value of pattern parameter messageKind, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final Message pSelf, final MessageKind pMessageKind, final IMatchProcessor<? super MessageMessageKindMatch> processor) {
    rawForEachMatch(new Object[]{pSelf, pMessageKind}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pMessageKind the fixed value of pattern parameter messageKind, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final Message pSelf, final MessageKind pMessageKind, final IMatchProcessor<? super MessageMessageKindMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pSelf, pMessageKind}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pMessageKind the fixed value of pattern parameter messageKind, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public MessageMessageKindMatch newMatch(final Message pSelf, final MessageKind pMessageKind) {
    return MessageMessageKindMatch.newMatch(pSelf, pMessageKind);
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Message> rawAccumulateAllValuesOfself(final Object[] parameters) {
    Set<Message> results = new HashSet<Message>();
    rawAccumulateAllValues(POSITION_SELF, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Message> getAllValuesOfself() {
    return rawAccumulateAllValuesOfself(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Message> getAllValuesOfself(final MessageMessageKindMatch partialMatch) {
    return rawAccumulateAllValuesOfself(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Message> getAllValuesOfself(final MessageKind pMessageKind) {
    return rawAccumulateAllValuesOfself(new Object[]{
    null, 
    pMessageKind
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for messageKind.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<MessageKind> rawAccumulateAllValuesOfmessageKind(final Object[] parameters) {
    Set<MessageKind> results = new HashSet<MessageKind>();
    rawAccumulateAllValues(POSITION_MESSAGEKIND, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for messageKind.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<MessageKind> getAllValuesOfmessageKind() {
    return rawAccumulateAllValuesOfmessageKind(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for messageKind.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<MessageKind> getAllValuesOfmessageKind(final MessageMessageKindMatch partialMatch) {
    return rawAccumulateAllValuesOfmessageKind(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for messageKind.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<MessageKind> getAllValuesOfmessageKind(final Message pSelf) {
    return rawAccumulateAllValuesOfmessageKind(new Object[]{
    pSelf, 
    null
    });
  }
  
  @Override
  protected MessageMessageKindMatch tupleToMatch(final Tuple t) {
    try {
    	return MessageMessageKindMatch.newMatch((org.eclipse.uml2.uml.Message) t.get(POSITION_SELF), (org.eclipse.uml2.uml.MessageKind) t.get(POSITION_MESSAGEKIND));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected MessageMessageKindMatch arrayToMatch(final Object[] match) {
    try {
    	return MessageMessageKindMatch.newMatch((org.eclipse.uml2.uml.Message) match[POSITION_SELF], (org.eclipse.uml2.uml.MessageKind) match[POSITION_MESSAGEKIND]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected MessageMessageKindMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return MessageMessageKindMatch.newMutableMatch((org.eclipse.uml2.uml.Message) match[POSITION_SELF], (org.eclipse.uml2.uml.MessageKind) match[POSITION_MESSAGEKIND]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<MessageMessageKindMatcher> querySpecification() throws IncQueryException {
    return MessageMessageKindQuerySpecification.instance();
  }
}
