/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.operations.extend;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.runtime.base.api.IEStructuralFeatureProcessor;
import org.eclipse.incquery.runtime.base.api.NavigationHelper;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.incquery.runtime.localsearch.operations.ISearchOperation;

public class IterateOverEStructuralFeatureInstances
implements ISearchOperation {
    private NavigationHelper baseIndexNavigator;
    private EStructuralFeature feature;
    private Integer sourcePosition;
    private Integer targetPosition;
    protected Iterator<Map.Entry<EObject, Object>> it;

    public IterateOverEStructuralFeatureInstances(int sourcePosition, int targetPosition, EStructuralFeature feature, NavigationHelper baseIndexNavigator) {
        this.sourcePosition = sourcePosition;
        this.targetPosition = targetPosition;
        this.feature = feature;
        this.baseIndexNavigator = baseIndexNavigator;
    }

    @Override
    public void onBacktrack(MatchingFrame frame) throws LocalSearchException {
        frame.setValue(this.sourcePosition, null);
        frame.setValue(this.targetPosition, null);
        this.it = null;
    }

    @Override
    public void onInitialize(MatchingFrame frame) {
        final HashMap instances = Maps.newHashMap();
        this.baseIndexNavigator.processAllFeatureInstances(this.feature, new IEStructuralFeatureProcessor(){

            public void process(EStructuralFeature feature, EObject source, Object target) {
                instances.put(source, target);
            }
        });
        this.it = instances.entrySet().iterator();
    }

    @Override
    public boolean execute(MatchingFrame frame) {
        if (this.it.hasNext()) {
            Map.Entry<EObject, Object> next = this.it.next();
            frame.setValue(this.sourcePosition, next.getKey());
            frame.setValue(this.targetPosition, next.getValue());
            return true;
        }
        return false;
    }
}

