/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.matcher;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.runtime.base.api.IncQueryBaseFactory;
import org.eclipse.incquery.runtime.base.api.NavigationHelper;
import org.eclipse.incquery.runtime.base.exception.IncQueryBaseException;
import org.eclipse.incquery.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;

public interface ISearchContext {
    public NavigationHelper getBaseIndex();

    public void loadMatcher(LocalSearchMatcher var1);

    public LocalSearchMatcher getMatcher(PQuery var1);

    public static class SearchContext
    implements ISearchContext {
        final NavigationHelper baseIndex;
        final Logger logger = Logger.getLogger(this.getClass());
        Map<PQuery, LocalSearchMatcher> knownMatchers = Maps.newHashMap();

        public SearchContext(ResourceSet set, Set<EClass> classes, Set<EDataType> dataTypes, Set<EStructuralFeature> features) throws IncQueryBaseException {
            this.baseIndex = IncQueryBaseFactory.getInstance().createNavigationHelper((Notifier)set, false, this.logger);
            this.baseIndex.registerObservedTypes(classes, dataTypes, features);
        }

        public SearchContext(NavigationHelper baseIndex, Set<EClass> classes, Set<EDataType> dataTypes, Set<EStructuralFeature> features) {
            this.baseIndex = baseIndex;
            baseIndex.registerObservedTypes(classes, dataTypes, features);
        }

        @Override
        public NavigationHelper getBaseIndex() {
            return this.baseIndex;
        }

        @Override
        public void loadMatcher(LocalSearchMatcher matcher) {
            this.knownMatchers.put(matcher.getQuerySpecification(), matcher);
        }

        @Override
        public LocalSearchMatcher getMatcher(PQuery query) {
            if (!this.knownMatchers.containsKey(query)) {
                throw new UnsupportedOperationException("No on-the-fly matcher initialization supported.");
            }
            return this.knownMatchers.get(query);
        }
    }
}

