/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.basicdeferred;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.IPatternMatcherContext;
import org.eclipse.incquery.runtime.matchers.planning.SubPlan;
import org.eclipse.incquery.runtime.matchers.planning.helpers.TypeHelper;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.VariableDeferredPConstraint;

public abstract class BaseTypeSafeConstraint
extends VariableDeferredPConstraint {
    private Map<PVariable, Set<Object>> allTypeRestrictions;
    protected Set<PVariable> inputVariables;
    protected PVariable outputVariable;

    public PVariable getOutputVariable() {
        return this.outputVariable;
    }

    public BaseTypeSafeConstraint(PBody pSystem, Set<PVariable> inputVariables, PVariable outputVariable) {
        super(pSystem, (Set<PVariable>)(outputVariable == null ? inputVariables : new HashSet<PVariable>((Collection)inputVariables, outputVariable){
            {
                this.add(pVariable);
            }
        }));
        this.inputVariables = inputVariables;
        this.outputVariable = outputVariable;
    }

    @Override
    public Set<PVariable> getDeducedVariables() {
        if (this.outputVariable == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.outputVariable);
    }

    @Override
    public Set<PVariable> getDeferringVariables() {
        return this.inputVariables;
    }

    @Override
    public boolean isReadyAt(SubPlan plan, IPatternMatcherContext context) {
        if (super.isReadyAt(plan, context)) {
            return this.checkTypeSafety(plan, context) == null;
        }
        return false;
    }

    public PVariable checkTypeSafety(SubPlan plan, IPatternMatcherContext context) {
        for (PVariable pVariable : this.inputVariables) {
            Set<Object> checkedTypeRestrictions;
            Set<Object> allTypeRestrictionsForVariable = this.getAllTypeRestrictions().get(pVariable);
            Set<Object> uncheckedTypeRestrictions = TypeHelper.subsumeTypes(allTypeRestrictionsForVariable, checkedTypeRestrictions = TypeHelper.inferTypes(pVariable, plan.getAllEnforcedConstraints()), context);
            if (uncheckedTypeRestrictions.isEmpty()) continue;
            return pVariable;
        }
        return null;
    }

    public Map<PVariable, Set<Object>> getAllTypeRestrictions() {
        if (this.allTypeRestrictions == null) {
            this.allTypeRestrictions = new HashMap<PVariable, Set<Object>>();
            for (PVariable pVariable : this.inputVariables) {
                this.allTypeRestrictions.put(pVariable, TypeHelper.inferTypes(pVariable, pVariable.getReferringConstraints()));
            }
        }
        return this.allTypeRestrictions;
    }

    @Override
    protected void doReplaceVariable(PVariable obsolete, PVariable replacement) {
        if (this.inputVariables.remove(obsolete)) {
            this.inputVariables.add(replacement);
        }
        if (this.outputVariable == obsolete) {
            this.outputVariable = replacement;
        }
    }
}

