/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.context.surrogate;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.incquery.runtime.matchers.context.IInputKey;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;

public class SurrogateQueryRegistry {
    private Map<IInputKey, PQuery> registeredSurrogateQueryMap = Maps.newHashMap();
    private Map<IInputKey, PQuery> dynamicSurrogateQueryMap = Maps.newHashMap();
    private static final SurrogateQueryRegistry INSTANCE = new SurrogateQueryRegistry();

    private SurrogateQueryRegistry() {
    }

    public static SurrogateQueryRegistry instance() {
        return INSTANCE;
    }

    public PQuery registerSurrogateQueryForFeature(IInputKey feature, PQuery surrogateQuery) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        Preconditions.checkArgument((surrogateQuery != null ? 1 : 0) != 0, (Object)"Surrogate query must not be null!");
        return this.registeredSurrogateQueryMap.put(feature, surrogateQuery);
    }

    public PQuery addDynamicSurrogateQueryForFeature(IInputKey feature, PQuery surrogateQuery) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        Preconditions.checkArgument((surrogateQuery != null ? 1 : 0) != 0, (Object)"Surrogate query FQN must not be null!");
        return this.dynamicSurrogateQueryMap.put(feature, surrogateQuery);
    }

    public PQuery removeDynamicSurrogateQueryForFeature(IInputKey feature) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        return this.dynamicSurrogateQueryMap.remove(feature);
    }

    public boolean hasSurrogateQueryFQN(IInputKey feature) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        boolean surrogateExists = this.dynamicSurrogateQueryMap.containsKey(feature);
        if (!surrogateExists) {
            surrogateExists = this.registeredSurrogateQueryMap.containsKey(feature);
        }
        return surrogateExists;
    }

    public PQuery getSurrogateQuery(IInputKey feature) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        PQuery surrogate = this.dynamicSurrogateQueryMap.get(feature);
        if (surrogate == null) {
            surrogate = this.registeredSurrogateQueryMap.get(feature);
        }
        if (surrogate != null) {
            return surrogate;
        }
        throw new NoSuchElementException(String.format("Feature %s has no surrogate query defined! Use #hasSurrogateQueryFQN to check existence.", feature));
    }

    public Map<IInputKey, PQuery> getRegisteredSurrogateQueryFQNMap() {
        return this.registeredSurrogateQueryMap;
    }

    public Map<IInputKey, PQuery> getDynamicSurrogateQueryFQNMap() {
        return this.dynamicSurrogateQueryMap;
    }

    public Map<IInputKey, PQuery> getAllSurrogateQueryFQNMap() {
        HashMap allSurrogateQueries = Maps.newHashMap(this.registeredSurrogateQueryMap);
        allSurrogateQueries.putAll(this.dynamicSurrogateQueryMap);
        return allSurrogateQueries;
    }
}

