/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.network;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.incquery.runtime.matchers.context.IPatternMatcherRuntimeContext;
import org.eclipse.incquery.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.matchers.tuple.TupleMask;
import org.eclipse.incquery.runtime.rete.eval.CachedFunctionEvaluatorNode;
import org.eclipse.incquery.runtime.rete.eval.CachedPredicateEvaluatorNode;
import org.eclipse.incquery.runtime.rete.index.AggregatorNode;
import org.eclipse.incquery.runtime.rete.index.CountNode;
import org.eclipse.incquery.runtime.rete.index.ExistenceNode;
import org.eclipse.incquery.runtime.rete.index.Indexer;
import org.eclipse.incquery.runtime.rete.index.JoinNode;
import org.eclipse.incquery.runtime.rete.misc.ConstantNode;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.network.Supplier;
import org.eclipse.incquery.runtime.rete.recipes.AggregatorIndexerRecipe;
import org.eclipse.incquery.runtime.rete.recipes.AntiJoinRecipe;
import org.eclipse.incquery.runtime.rete.recipes.BinaryInputRecipe;
import org.eclipse.incquery.runtime.rete.recipes.CheckRecipe;
import org.eclipse.incquery.runtime.rete.recipes.ConstantRecipe;
import org.eclipse.incquery.runtime.rete.recipes.CountAggregatorRecipe;
import org.eclipse.incquery.runtime.rete.recipes.EqualityFilterRecipe;
import org.eclipse.incquery.runtime.rete.recipes.EvalRecipe;
import org.eclipse.incquery.runtime.rete.recipes.ExpressionDefinition;
import org.eclipse.incquery.runtime.rete.recipes.IndexerRecipe;
import org.eclipse.incquery.runtime.rete.recipes.InequalityFilterRecipe;
import org.eclipse.incquery.runtime.rete.recipes.JoinRecipe;
import org.eclipse.incquery.runtime.rete.recipes.Mask;
import org.eclipse.incquery.runtime.rete.recipes.ProductionRecipe;
import org.eclipse.incquery.runtime.rete.recipes.ProjectionIndexerRecipe;
import org.eclipse.incquery.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.incquery.runtime.rete.recipes.SemiJoinRecipe;
import org.eclipse.incquery.runtime.rete.recipes.TransitiveClosureRecipe;
import org.eclipse.incquery.runtime.rete.recipes.TransparentRecipe;
import org.eclipse.incquery.runtime.rete.recipes.TrimmerRecipe;
import org.eclipse.incquery.runtime.rete.recipes.UnaryInputRecipe;
import org.eclipse.incquery.runtime.rete.recipes.UniquenessEnforcerRecipe;
import org.eclipse.incquery.runtime.rete.single.DefaultProductionNode;
import org.eclipse.incquery.runtime.rete.single.EqualityFilterNode;
import org.eclipse.incquery.runtime.rete.single.InequalityFilterNode;
import org.eclipse.incquery.runtime.rete.single.InputNode;
import org.eclipse.incquery.runtime.rete.single.TransitiveClosureNode;
import org.eclipse.incquery.runtime.rete.single.TransparentNode;
import org.eclipse.incquery.runtime.rete.single.TrimmerNode;
import org.eclipse.incquery.runtime.rete.single.UniquenessEnforcerNode;
import org.eclipse.incquery.runtime.rete.traceability.TraceInfo;

class NodeFactory {
    IPatternMatcherRuntimeContext context;

    public NodeFactory(IPatternMatcherRuntimeContext context) {
        this.context = context;
    }

    public Indexer createIndexer(ReteContainer reteContainer, IndexerRecipe recipe, Supplier parentNode, TraceInfo ... traces) {
        if (recipe instanceof ProjectionIndexerRecipe) {
            return parentNode.constructIndex(this.toMask(recipe.getMask()), traces);
        }
        if (recipe instanceof AggregatorIndexerRecipe) {
            AggregatorNode.AggregatorOuterIndexer result = ((AggregatorNode)parentNode).getAggregatorOuterIndexer();
            TraceInfo[] traceInfoArray = traces;
            int n = traces.length;
            int n2 = 0;
            while (n2 < n) {
                TraceInfo traceInfo = traceInfoArray[n2];
                result.assignTraceInfo(traceInfo);
                ++n2;
            }
            return result;
        }
        throw new IllegalArgumentException("Unkown Indexer recipe: " + recipe);
    }

    public Supplier createNode(ReteContainer reteContainer, ReteNodeRecipe recipe, TraceInfo ... traces) {
        if (recipe instanceof IndexerRecipe) {
            throw new IllegalArgumentException("Indexers are not created by NodeFactory: " + recipe);
        }
        Supplier result = this.instantiateNodeDispatch(reteContainer, recipe);
        TraceInfo[] traceInfoArray = traces;
        int n = traces.length;
        int n2 = 0;
        while (n2 < n) {
            TraceInfo traceInfo = traceInfoArray[n2];
            result.assignTraceInfo(traceInfo);
            ++n2;
        }
        return result;
    }

    private Supplier instantiateNodeDispatch(ReteContainer reteContainer, ReteNodeRecipe recipe) {
        if (recipe instanceof ConstantRecipe) {
            return this.instantiateNode(reteContainer, (ConstantRecipe)recipe);
        }
        if (recipe instanceof UnaryInputRecipe) {
            return this.instantiateNode(reteContainer, (UnaryInputRecipe)recipe);
        }
        if (recipe instanceof BinaryInputRecipe) {
            return this.instantiateNode(reteContainer, (BinaryInputRecipe)recipe);
        }
        if (recipe instanceof InequalityFilterRecipe) {
            return this.instantiateNode(reteContainer, (InequalityFilterRecipe)recipe);
        }
        if (recipe instanceof EqualityFilterRecipe) {
            return this.instantiateNode(reteContainer, (EqualityFilterRecipe)recipe);
        }
        if (recipe instanceof TransparentRecipe) {
            return this.instantiateNode(reteContainer, (TransparentRecipe)recipe);
        }
        if (recipe instanceof TrimmerRecipe) {
            return this.instantiateNode(reteContainer, (TrimmerRecipe)recipe);
        }
        if (recipe instanceof TransitiveClosureRecipe) {
            return this.instantiateNode(reteContainer, (TransitiveClosureRecipe)recipe);
        }
        if (recipe instanceof CheckRecipe) {
            return this.instantiateNode(reteContainer, (CheckRecipe)recipe);
        }
        if (recipe instanceof EvalRecipe) {
            return this.instantiateNode(reteContainer, (EvalRecipe)recipe);
        }
        if (recipe instanceof CountAggregatorRecipe) {
            return this.instantiateNode(reteContainer, (CountAggregatorRecipe)recipe);
        }
        if (recipe instanceof UniquenessEnforcerRecipe) {
            return this.instantiateNode(reteContainer, (UniquenessEnforcerRecipe)recipe);
        }
        if (recipe instanceof ProductionRecipe) {
            return this.instantiateNode(reteContainer, (ProductionRecipe)recipe);
        }
        if (recipe instanceof JoinRecipe) {
            return this.instantiateNode(reteContainer, (JoinRecipe)recipe);
        }
        if (recipe instanceof SemiJoinRecipe) {
            return this.instantiateNode(reteContainer, (SemiJoinRecipe)recipe);
        }
        if (recipe instanceof AntiJoinRecipe) {
            return this.instantiateNode(reteContainer, (AntiJoinRecipe)recipe);
        }
        throw new IllegalArgumentException("Unsupported recipe type: " + recipe);
    }

    private Supplier instantiateNode(ReteContainer reteContainer, BinaryInputRecipe recipe) {
        return new InputNode(reteContainer, 2, recipe.getTypeKey());
    }

    private Supplier instantiateNode(ReteContainer reteContainer, UnaryInputRecipe recipe) {
        return new InputNode(reteContainer, 1, recipe.getTypeKey());
    }

    private Supplier instantiateNode(ReteContainer reteContainer, CountAggregatorRecipe recipe) {
        return new CountNode(reteContainer);
    }

    private Supplier instantiateNode(ReteContainer reteContainer, TransparentRecipe recipe) {
        return new TransparentNode(reteContainer);
    }

    private Supplier instantiateNode(ReteContainer reteContainer, EvalRecipe recipe) {
        IExpressionEvaluator evaluator = this.toIExpressionEvaluator(recipe.getExpression());
        Map<String, Integer> posMapping = this.toStringIndexMap((EMap<String, Integer>)recipe.getMappedIndices());
        return new CachedFunctionEvaluatorNode(reteContainer, this.context, evaluator, posMapping, recipe.getParent().getArity());
    }

    private Supplier instantiateNode(ReteContainer reteContainer, CheckRecipe recipe) {
        IExpressionEvaluator evaluator = this.toIExpressionEvaluator(recipe.getExpression());
        Map<String, Integer> posMapping = this.toStringIndexMap((EMap<String, Integer>)recipe.getMappedIndices());
        return new CachedPredicateEvaluatorNode(reteContainer, this.context, evaluator, posMapping, recipe.getParent().getArity());
    }

    private Supplier instantiateNode(ReteContainer reteContainer, TransitiveClosureRecipe recipe) {
        return new TransitiveClosureNode(reteContainer);
    }

    private Supplier instantiateNode(ReteContainer reteContainer, ProductionRecipe recipe) {
        return new DefaultProductionNode(reteContainer, this.toStringIndexMap((EMap<String, Integer>)recipe.getMappedIndices()));
    }

    private Supplier instantiateNode(ReteContainer reteContainer, UniquenessEnforcerRecipe recipe) {
        return new UniquenessEnforcerNode(reteContainer, recipe.getArity());
    }

    private Supplier instantiateNode(ReteContainer reteContainer, ConstantRecipe recipe) {
        EList constantValues = recipe.getConstantValues();
        Object[] constantArray = constantValues.toArray(new Object[constantValues.size()]);
        return new ConstantNode(reteContainer, (Tuple)new FlatTuple(constantArray));
    }

    private Supplier instantiateNode(ReteContainer reteContainer, TrimmerRecipe recipe) {
        return new TrimmerNode(reteContainer, this.toMask(recipe.getMask()));
    }

    private Supplier instantiateNode(ReteContainer reteContainer, InequalityFilterRecipe recipe) {
        int[] inequalIndices = this.integersToIntArray((List<Integer>)recipe.getInequals());
        InequalityFilterNode result = new InequalityFilterNode(reteContainer, recipe.getSubject(), new TupleMask(inequalIndices, recipe.getParent().getArity()));
        return result;
    }

    private Supplier instantiateNode(ReteContainer reteContainer, EqualityFilterRecipe recipe) {
        int[] equalIndices = this.integersToIntArray((List<Integer>)recipe.getIndices());
        return new EqualityFilterNode(reteContainer, equalIndices);
    }

    private Supplier instantiateNode(ReteContainer reteContainer, AntiJoinRecipe recipe) {
        return new ExistenceNode(reteContainer, true);
    }

    private Supplier instantiateNode(ReteContainer reteContainer, SemiJoinRecipe recipe) {
        return new ExistenceNode(reteContainer, false);
    }

    private Supplier instantiateNode(ReteContainer reteContainer, JoinRecipe recipe) {
        return new JoinNode(reteContainer, this.toMask(recipe.getRightParentComplementaryMask()));
    }

    private IExpressionEvaluator toIExpressionEvaluator(ExpressionDefinition expressionDefinition) {
        Object evaluator = expressionDefinition.getEvaluator();
        if (evaluator instanceof IExpressionEvaluator) {
            return (IExpressionEvaluator)evaluator;
        }
        throw new IllegalArgumentException("No runtime support for expression definition: " + evaluator);
    }

    private Map<String, Integer> toStringIndexMap(EMap<String, Integer> mappedIndices) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry entry : mappedIndices) {
            result.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return result;
    }

    private TupleMask toMask(Mask mask) {
        return new TupleMask(this.integersToIntArray((List<Integer>)mask.getSourceIndices()), mask.getSourceArity());
    }

    private int[] integersToIntArray(List<Integer> integers) {
        int[] result = new int[integers.size()];
        int k = 0;
        for (Integer index : integers) {
            result[k++] = index;
        }
        return result;
    }
}

