/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.boundary;

import java.util.Collection;
import java.util.Map;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.matchers.util.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.boundary.EntityFeeder;
import org.eclipse.incquery.runtime.rete.boundary.ReferenceFeeder;
import org.eclipse.incquery.runtime.rete.network.Network;
import org.eclipse.incquery.runtime.rete.network.Node;
import org.eclipse.incquery.runtime.rete.network.Supplier;
import org.eclipse.incquery.runtime.rete.network.Tunnel;
import org.eclipse.incquery.runtime.rete.recipes.BinaryInputRecipe;
import org.eclipse.incquery.runtime.rete.recipes.InputRecipe;
import org.eclipse.incquery.runtime.rete.recipes.TypeInputRecipe;
import org.eclipse.incquery.runtime.rete.recipes.UnaryInputRecipe;
import org.eclipse.incquery.runtime.rete.remote.Address;

public class InputConnector {
    Network network;
    protected Map<Object, Address<? extends Tunnel>> unaryRoots = CollectionsFactory.getMap();
    protected Map<Object, Address<? extends Tunnel>> ternaryEdgeRoots = CollectionsFactory.getMap();
    protected Map<Object, Address<? extends Tunnel>> binaryEdgeRoots = CollectionsFactory.getMap();
    protected Address<? extends Tunnel> containmentRoot = null;
    protected Address<? extends Supplier> containmentTransitiveRoot = null;
    protected Address<? extends Tunnel> instantiationRoot = null;
    protected Address<? extends Supplier> instantiationTransitiveRoot = null;
    protected Address<? extends Tunnel> generalizationRoot = null;
    protected Address<? extends Supplier> generalizationTransitiveRoot = null;

    public InputConnector(Network network) {
        this.network = network;
    }

    public Network getNetwork() {
        return this.network;
    }

    public void connectInput(InputRecipe recipe, Node freshNode) {
        Address<Tunnel> freshAddress = Address.of((Tunnel)freshNode);
        if (recipe instanceof TypeInputRecipe) {
            Object typeKey = ((TypeInputRecipe)recipe).getTypeKey();
            if (recipe instanceof UnaryInputRecipe) {
                this.unaryRoots.put(typeKey, freshAddress);
                new EntityFeeder(freshAddress, this, typeKey).feed();
            } else if (recipe instanceof BinaryInputRecipe) {
                this.binaryEdgeRoots.put(typeKey, freshAddress);
                new ReferenceFeeder(freshAddress, this, typeKey).feed();
            }
        }
    }

    public Object wrapElement(Object element) {
        return element;
    }

    public Object unwrapElement(Object wrapper) {
        return wrapper;
    }

    public Tuple wrapTuple(Tuple unwrapped) {
        return unwrapped;
    }

    public Tuple unwrapTuple(Tuple wrappers) {
        return wrappers;
    }

    public Address<? extends Tunnel> getUnaryRoot(Object label) {
        return this.unaryRoots.get(label);
    }

    public Collection<Address<? extends Tunnel>> getAllUnaryRoots() {
        return this.unaryRoots.values();
    }

    public Address<? extends Tunnel> getTernaryEdgeRoot(Object label) {
        return this.ternaryEdgeRoots.get(label);
    }

    public Collection<Address<? extends Tunnel>> getAllTernaryEdgeRoots() {
        return this.ternaryEdgeRoots.values();
    }

    public Address<? extends Tunnel> getBinaryEdgeRoot(Object label) {
        return this.binaryEdgeRoots.get(label);
    }

    public Collection<Address<? extends Tunnel>> getAllBinaryEdgeRoots() {
        return this.binaryEdgeRoots.values();
    }

    public Address<? extends Tunnel> getContainmentRoot() {
        return this.containmentRoot;
    }

    public Address<? extends Supplier> getContainmentTransitiveRoot() {
        return this.containmentTransitiveRoot;
    }

    public Address<? extends Tunnel> getInstantiationRoot() {
        return this.instantiationRoot;
    }

    public Address<? extends Supplier> getInstantiationTransitiveRoot() {
        return this.instantiationTransitiveRoot;
    }

    public Address<? extends Tunnel> getGeneralizationRoot() {
        return this.generalizationRoot;
    }
}

