/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.internal;

import com.google.inject.Injector;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.incquery.patternlanguage.emf.validation.PatternSetValidationDiagnostics;
import org.eclipse.incquery.patternlanguage.emf.validation.PatternSetValidator;
import org.eclipse.incquery.patternlanguage.emf.validation.PatternValidationStatus;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.internal.XtextInjectorProvider;

public class PatternSanitizer {
    Set<Pattern> admittedPatterns = new HashSet<Pattern>();
    Map<String, Pattern> patternsByName = new HashMap<String, Pattern>();
    Logger logger;

    public PatternSanitizer(Logger logger) {
        this.logger = logger;
    }

    public boolean admit(Pattern pattern) {
        return this.admit(Collections.singletonList(pattern));
    }

    public boolean admit(Collection<Pattern> patterns) {
        boolean ok;
        Set<Pattern> newPatterns = this.getAllReferencedUnvalidatedPatterns(patterns);
        if (newPatterns.isEmpty()) {
            return true;
        }
        HashSet<Pattern> inadmissible = new HashSet<Pattern>();
        HashMap<String, Pattern> newPatternsByName = new HashMap<String, Pattern>();
        for (Pattern current : newPatterns) {
            boolean duplicate;
            if (current == null) {
                inadmissible.add(current);
                this.logger.error((Object)"Null pattern value");
                continue;
            }
            String fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)current);
            boolean bl = duplicate = this.patternsByName.containsKey(fullyQualifiedName) || newPatternsByName.containsKey(fullyQualifiedName);
            if (duplicate) {
                inadmissible.add(current);
                this.logger.error((Object)("Duplicate (qualified) name of pattern: " + fullyQualifiedName));
                continue;
            }
            newPatternsByName.put(fullyQualifiedName, current);
        }
        Injector injector = XtextInjectorProvider.INSTANCE.getInjector();
        PatternSetValidator validator = (PatternSetValidator)injector.getInstance(PatternSetValidator.class);
        PatternSetValidationDiagnostics validatorResult = validator.validate(newPatternsByName.values());
        validatorResult.logErrors(this.logger);
        boolean bl = ok = inadmissible.isEmpty() && !validatorResult.getStatus().equals((Object)PatternValidationStatus.ERROR);
        if (ok) {
            this.admittedPatterns.addAll(newPatterns);
            this.patternsByName.putAll(newPatternsByName);
        }
        return ok;
    }

    protected Set<Pattern> getAllReferencedUnvalidatedPatterns(Collection<Pattern> patterns) {
        HashSet<Pattern> toBeValidated = new HashSet<Pattern>();
        LinkedList<Pattern> unexplored = new LinkedList<Pattern>();
        for (Pattern pattern : patterns) {
            if (this.admittedPatterns.contains(pattern)) continue;
            toBeValidated.add(pattern);
            unexplored.add(pattern);
        }
        while (!unexplored.isEmpty()) {
            Pattern current = (Pattern)unexplored.pollFirst();
            Set referencedPatterns = CorePatternLanguageHelper.getReferencedPatterns((Pattern)current);
            for (Pattern referenced : referencedPatterns) {
                if (this.admittedPatterns.contains(referenced) || toBeValidated.contains(referenced)) continue;
                toBeValidated.add(referenced);
                unexplored.add(referenced);
            }
        }
        return toBeValidated;
    }

    public Set<Pattern> getAdmittedPatterns() {
        return Collections.unmodifiableSet(this.admittedPatterns);
    }

    public Pattern getAdmittedPatternByName(String fqn) {
        return this.patternsByName.get(fqn);
    }
}

