package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Arrays;
import java.util.List;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.uml.derivedfeatures.util.PackageVisibleMemberQuerySpecification;
import org.eclipse.uml2.uml.PackageableElement;

/**
 * Pattern-specific match representation of the org.eclipse.incquery.uml.derivedfeatures.packageVisibleMember pattern,
 * to be used in conjunction with {@link PackageVisibleMemberMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see PackageVisibleMemberMatcher
 * @see PackageVisibleMemberProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class PackageVisibleMemberMatch extends BasePatternMatch {
  private org.eclipse.uml2.uml.Package fPackage_;
  
  private PackageableElement fVisibleMember;
  
  private static List<String> parameterNames = makeImmutableList("package_", "visibleMember");
  
  private PackageVisibleMemberMatch(final org.eclipse.uml2.uml.Package pPackage_, final PackageableElement pVisibleMember) {
    this.fPackage_ = pPackage_;
    this.fVisibleMember = pVisibleMember;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("package_".equals(parameterName)) return this.fPackage_;
    if ("visibleMember".equals(parameterName)) return this.fVisibleMember;
    return null;
  }
  
  public org.eclipse.uml2.uml.Package getPackage_() {
    return this.fPackage_;
  }
  
  public PackageableElement getVisibleMember() {
    return this.fVisibleMember;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("package_".equals(parameterName) ) {
    	this.fPackage_ = (org.eclipse.uml2.uml.Package) newValue;
    	return true;
    }
    if ("visibleMember".equals(parameterName) ) {
    	this.fVisibleMember = (org.eclipse.uml2.uml.PackageableElement) newValue;
    	return true;
    }
    return false;
  }
  
  public void setPackage_(final org.eclipse.uml2.uml.Package pPackage_) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fPackage_ = pPackage_;
  }
  
  public void setVisibleMember(final PackageableElement pVisibleMember) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fVisibleMember = pVisibleMember;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.incquery.uml.derivedfeatures.packageVisibleMember";
  }
  
  @Override
  public List<String> parameterNames() {
    return PackageVisibleMemberMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fPackage_, fVisibleMember};
  }
  
  @Override
  public PackageVisibleMemberMatch toImmutable() {
    return isMutable() ? newMatch(fPackage_, fVisibleMember) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"package_\"=" + prettyPrintValue(fPackage_) + ", ");
    
    result.append("\"visibleMember\"=" + prettyPrintValue(fVisibleMember)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fPackage_ == null) ? 0 : fPackage_.hashCode());
    result = prime * result + ((fVisibleMember == null) ? 0 : fVisibleMember.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof PackageVisibleMemberMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    PackageVisibleMemberMatch other = (PackageVisibleMemberMatch) obj;
    if (fPackage_ == null) {if (other.fPackage_ != null) return false;}
    else if (!fPackage_.equals(other.fPackage_)) return false;
    if (fVisibleMember == null) {if (other.fVisibleMember != null) return false;}
    else if (!fVisibleMember.equals(other.fVisibleMember)) return false;
    return true;
  }
  
  @Override
  public PackageVisibleMemberQuerySpecification specification() {
    try {
    	return PackageVisibleMemberQuerySpecification.instance();
    } catch (IncQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static PackageVisibleMemberMatch newEmptyMatch() {
    return new Mutable(null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pPackage_ the fixed value of pattern parameter package_, or null if not bound.
   * @param pVisibleMember the fixed value of pattern parameter visibleMember, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static PackageVisibleMemberMatch newMutableMatch(final org.eclipse.uml2.uml.Package pPackage_, final PackageableElement pVisibleMember) {
    return new Mutable(pPackage_, pVisibleMember);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pPackage_ the fixed value of pattern parameter package_, or null if not bound.
   * @param pVisibleMember the fixed value of pattern parameter visibleMember, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static PackageVisibleMemberMatch newMatch(final org.eclipse.uml2.uml.Package pPackage_, final PackageableElement pVisibleMember) {
    return new Immutable(pPackage_, pVisibleMember);
  }
  
  private static final class Mutable extends PackageVisibleMemberMatch {
    Mutable(final org.eclipse.uml2.uml.Package pPackage_, final PackageableElement pVisibleMember) {
      super(pPackage_, pVisibleMember);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends PackageVisibleMemberMatch {
    Immutable(final org.eclipse.uml2.uml.Package pPackage_, final PackageableElement pVisibleMember) {
      super(pPackage_, pVisibleMember);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
