package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.PackageNestingPackageMatch;
import org.eclipse.incquery.uml.derivedfeatures.PackageNestingPackageMatcher;
import org.eclipse.incquery.uml.derivedfeatures.util.PackageNestedPackageQuerySpecification;

/**
 * A pattern-specific query specification that can instantiate PackageNestingPackageMatcher in a type-safe way.
 * 
 * @see PackageNestingPackageMatcher
 * @see PackageNestingPackageMatch
 * 
 */
@SuppressWarnings("all")
public final class PackageNestingPackageQuerySpecification extends BaseGeneratedEMFQuerySpecification<PackageNestingPackageMatcher> {
  private PackageNestingPackageQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static PackageNestingPackageQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected PackageNestingPackageMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return PackageNestingPackageMatcher.on(engine);
  }
  
  @Override
  public PackageNestingPackageMatch newEmptyMatch() {
    return PackageNestingPackageMatch.newEmptyMatch();
  }
  
  @Override
  public PackageNestingPackageMatch newMatch(final Object... parameters) {
    return PackageNestingPackageMatch.newMatch((org.eclipse.uml2.uml.Package) parameters[0], (org.eclipse.uml2.uml.Package) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static PackageNestingPackageQuerySpecification INSTANCE = make();
    
    public static PackageNestingPackageQuerySpecification make() {
      return new PackageNestingPackageQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static PackageNestingPackageQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.packageNestingPackage";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("nested","nesting");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("nested", "org.eclipse.uml2.uml.Package"),new PParameter("nesting", "org.eclipse.uml2.uml.Package"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_nested = body.getOrCreateVariableByName("nested");
      		PVariable var_nesting = body.getOrCreateVariableByName("nesting");
      		new TypeConstraint(body, new FlatTuple(var_nested), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Package")));
      		new TypeConstraint(body, new FlatTuple(var_nesting), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Package")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_nested, "nested"),
      		   new ExportedParameter(body, var_nesting, "nesting")
      		));
      		//     find packageNestedPackage(nesting, nested)
      		new PositivePatternCall(body, new FlatTuple(var_nesting, var_nested), PackageNestedPackageQuerySpecification.instance().getInternalQueryRepresentation());
      		bodies.add(body);
      	}
      	                {
      		PAnnotation annotation = new PAnnotation("Surrogate");
      		annotation.addAttribute("feature", "nestingPackage");
      		addAnnotation(annotation);
      	}
      	                {
      		PAnnotation annotation = new PAnnotation("QueryExplorer");
      		annotation.addAttribute("checked", false);
      		addAnnotation(annotation);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
