/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.zest.sources;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef4.zest.core.viewers.IConnectionStyleProvider;
import org.eclipse.gef4.zest.core.viewers.IEntityStyleProvider;
import org.eclipse.gef4.zest.core.widgets.decoration.IConnectionDecorator;
import org.eclipse.incquery.runtime.rete.network.Node;
import org.eclipse.incquery.viewers.runtime.model.Containment;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.FormattableElement;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.incquery.viewers.runtime.sources.QueryLabelProvider;
import org.eclipse.incquery.viewers.runtime.util.FormatParser;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ZestLabelProvider
extends QueryLabelProvider
implements IEntityStyleProvider,
IConnectionStyleProvider {
    private Display display;
    private Map<RGB, Color> colorMap = Maps.newHashMap();

    public ZestLabelProvider(ViewerState state, Display display) {
        super(state);
        this.display = display;
    }

    private Color getColorProperty(FormattableElement element, String property) {
        RGB color;
        if (FormatParser.isFormatted((FormattableElement)element) && (color = FormatParser.getColorFormatProperty((FormattableElement)element, (String)property)) != null) {
            return this.getColor(color);
        }
        return null;
    }

    private int getIntProperty(FormattableElement element, String property) {
        if (FormatParser.isFormatted((FormattableElement)element)) {
            return FormatParser.getNumberProperty((FormattableElement)element, (String)property);
        }
        return -1;
    }

    private String getStringProperty(FormattableElement element, String property) {
        if (FormatParser.isFormatted((FormattableElement)element)) {
            return FormatParser.getStringProperty((FormattableElement)element, (String)property);
        }
        return "";
    }

    private Color getColor(RGB rgb) {
        if (!this.colorMap.containsKey(rgb)) {
            Color newColor = new Color((Device)this.display, rgb);
            this.colorMap.put(rgb, newColor);
            return newColor;
        }
        return this.colorMap.get(rgb);
    }

    public Color getNodeHighlightColor(Object entity) {
        return null;
    }

    public Color getBorderColor(Object entity) {
        if (entity instanceof Item) {
            return this.getColorProperty((FormattableElement)entity, "org.eclipse.incquery.viewers.format.linecolor");
        }
        return null;
    }

    public Color getBorderHighlightColor(Object entity) {
        return null;
    }

    public int getBorderWidth(Object entity) {
        if (entity instanceof Node) {
            return this.getIntProperty((FormattableElement)entity, "org.eclipse.incquery.viewers.format.linewidth");
        }
        return -1;
    }

    public Color getBackgroundColour(Object entity) {
        if (entity instanceof Item) {
            return this.getColorProperty((FormattableElement)entity, "org.eclipse.incquery.viewers.format.color");
        }
        return null;
    }

    public Color getForegroundColour(Object entity) {
        if (entity instanceof Item) {
            return this.getColorProperty((FormattableElement)entity, "org.eclipse.incquery.viewers.format.textcolor");
        }
        return null;
    }

    public IFigure getTooltip(Object entity) {
        if (!(entity instanceof Item)) {
            return null;
        }
        Object entityObject = ((Item)entity).getParamObject();
        if (!(entityObject instanceof EObject)) {
            return null;
        }
        EObject eobj = (EObject)entityObject;
        String text = "";
        for (EStructuralFeature feature : eobj.eClass().getEAllAttributes()) {
            text = text.concat(String.valueOf(feature.getName()) + ": ");
            Object obj = eobj.eGet(feature);
            text = obj == null ? text.concat("\n") : text.concat(String.valueOf(eobj.eGet(feature).toString()) + "\n");
        }
        Label label = new Label(text);
        return label;
    }

    public boolean fisheyeNode(Object entity) {
        return false;
    }

    public void dispose() {
        for (Map.Entry<RGB, Color> colorEntry : this.colorMap.entrySet()) {
            Color color = colorEntry.getValue();
            if (color == null || color.isDisposed()) continue;
            color.dispose();
        }
        super.dispose();
    }

    public int getConnectionStyle(Object rel) {
        if (rel instanceof Containment) {
            return 18;
        }
        if (rel instanceof FormattableElement) {
            String lS = this.getStringProperty((FormattableElement)rel, "org.eclipse.incquery.viewers.format.linestyle");
            if ("dashed".equalsIgnoreCase(lS)) {
                return 10;
            }
            if ("dotted".equalsIgnoreCase(lS)) {
                return 18;
            }
            if ("dashdot".equalsIgnoreCase(lS)) {
                return 34;
            }
        }
        return 6;
    }

    public Color getColor(Object rel) {
        if (rel instanceof Edge) {
            return this.getColorProperty((FormattableElement)rel, "org.eclipse.incquery.viewers.format.linecolor");
        }
        return null;
    }

    public Color getHighlightColor(Object rel) {
        return null;
    }

    public int getLineWidth(Object rel) {
        if (rel instanceof Edge) {
            return this.getIntProperty((FormattableElement)rel, "org.eclipse.incquery.viewers.format.linewidth");
        }
        return -1;
    }

    public ConnectionRouter getRouter(Object rel) {
        return new BendpointConnectionRouter();
    }

    public IConnectionDecorator getConnectionDecorator(Object rel) {
        return null;
    }
}

